/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.CheckBox;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.HtmlDisplayFieldBase;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.RadioButtonGroup;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemindersPaneView
extends RequestHandlingViewBase {
    public static final String CHILD_CHECKBOX_SEND_REMINDER = "send_reminder";
    public static final String CHILD_STATIC_SUFFIX_LABEL = "suffix_label";
    public static final String CHILD_TEXT_REMINDER_EMAIL = "reminder_email";
    public static final String CHILD_TEXT_REMIND_VALUE = "remind_value";
    public static final String CHILD_TEXTAREA_REMIND_MESSAGE = "reminder_message";
    public static final String CHILD_COMBO_REMIND_INCR = "select_remind_increment";
    public static final String CHILD_COMBO_REMIND_MONTH = "select_remind_month";
    public static final String CHILD_COMBO_REMIND_DAY = "select_remind_day";
    public static final String CHILD_COMBO_REMIND_YEAR = "select_remind_year";
    public static final String CHILD_COMBO_REMIND_HOUR = "select_remind_hour";
    public static final String CHILD_COMBO_REMIND_MINS = "select_remind_minute";
    public static final String CHILD_RADIO_REMIND = "radio_remind";
    private static final OptionList rOptions = new OptionList(new String[]{"", ""}, new String[]{"1", "2"});
    private HashMap _fieldsDataMap = new HashMap();
    private VAlarm _reminderObj;
    private UserPreferencesModel _userPrefModel;
    private boolean _12HrFormat;
    private boolean _viewInit = false;
    private boolean _isParentModeNew = true;
    private String _suffix_label = "uwc-calclient-event-suffix-label";
    private DateTime _defDateTime;
    private static final String BEFORE_EVENT_SUFFIX = "uwc-calclient-event-suffix-label";
    private static final String BEFORE_EVENT_SUFFIX_CONST = "before the event";
    private static final String BEFORE_DUETASK_SUFFIX = "uwc-calclient-task-suffix-label";
    private static final String BEFORE_DUETASK_SUFFIX_CONST = "before task due time";
    private static final String DEFAULT_REMIND_VALUE = "15";
    private static final String DEFAULT_REMIND_INCR = "M";
    private static final String DEFAULT_REMIND_MONTH = "1";
    private static final String DEFAULT_REMIND_DAY = "1";
    private static final String DEFAULT_REMIND_HOUR = "12";
    private static final String[] DEFAULT_REMIND_MINS = new String[]{":00 pm", ":00"};
    private static final String DEFAULT_REMIND_SELECTION = "1";
    private static final String[] REMIND_HOUR_NAMES = new String[]{"options-minutes", "options-hours", "options-days"};
    private static final String[] REMIND_HOUR_VALUES = new String[]{"M", "H", "D"};
    private static final String[] REMIND_RADIO_SELECT = new String[]{"1", "2"};
    private static final String ATTENDEE_MAILTO_KEYWORD = "MAILTO:";
    private static final String MAIL_SEPARATOR = ",";
    private static final String MINUTE_PREFIX = ":";
    private static final String VALARM_FETCH = "valarm-fetch";
    private static Logger _calLogger = UWCLogger.getLogger("uwc.calclient");
    private static final String REMINDERS_PANE_CLASS = "RemindersPane";
    private static final String PAGE_ATTR = "REMINDER";
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$CheckBox;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$TextField;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$HtmlDisplayFieldBase;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$ComboBox;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$RadioButtonGroup;

    public RemindersPaneView(View view, String string) {
        super(view, string);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_STATIC_SUFFIX_LABEL, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = RemindersPaneView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(CHILD_CHECKBOX_SEND_REMINDER, class$com$iplanet$jato$view$html$CheckBox == null ? (class$com$iplanet$jato$view$html$CheckBox = RemindersPaneView.class$("com.iplanet.jato.view.html.CheckBox")) : class$com$iplanet$jato$view$html$CheckBox);
        this.registerChild(CHILD_TEXT_REMINDER_EMAIL, class$com$iplanet$jato$view$html$TextField == null ? (class$com$iplanet$jato$view$html$TextField = RemindersPaneView.class$("com.iplanet.jato.view.html.TextField")) : class$com$iplanet$jato$view$html$TextField);
        this.registerChild(CHILD_TEXT_REMIND_VALUE, class$com$iplanet$jato$view$html$TextField == null ? (class$com$iplanet$jato$view$html$TextField = RemindersPaneView.class$("com.iplanet.jato.view.html.TextField")) : class$com$iplanet$jato$view$html$TextField);
        this.registerChild(CHILD_TEXTAREA_REMIND_MESSAGE, class$com$iplanet$jato$view$html$HtmlDisplayFieldBase == null ? (class$com$iplanet$jato$view$html$HtmlDisplayFieldBase = RemindersPaneView.class$("com.iplanet.jato.view.html.HtmlDisplayFieldBase")) : class$com$iplanet$jato$view$html$HtmlDisplayFieldBase);
        this.registerChild(CHILD_COMBO_REMIND_INCR, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_COMBO_REMIND_MONTH, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_COMBO_REMIND_DAY, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_COMBO_REMIND_YEAR, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_COMBO_REMIND_HOUR, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_COMBO_REMIND_MINS, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = RemindersPaneView.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(CHILD_RADIO_REMIND, class$com$iplanet$jato$view$html$RadioButtonGroup == null ? (class$com$iplanet$jato$view$html$RadioButtonGroup = RemindersPaneView.class$("com.iplanet.jato.view.html.RadioButtonGroup")) : class$com$iplanet$jato$view$html$RadioButtonGroup);
    }

    protected View createChild(String string) {
        if (!this._viewInit) {
            this.initializeView();
        }
        if (string.equals(CHILD_STATIC_SUFFIX_LABEL)) {
            StaticTextField staticTextField = new StaticTextField((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_STATIC_SUFFIX_LABEL)));
            return staticTextField;
        }
        if (string.equals(CHILD_CHECKBOX_SEND_REMINDER)) {
            Boolean bl = Boolean.valueOf((String)this._fieldsDataMap.get(CHILD_CHECKBOX_SEND_REMINDER));
            CheckBox checkBox = new CheckBox((ContainerView)this, string, (Object)"true", (Object)"false", bl.booleanValue());
            return checkBox;
        }
        if (string.equals(CHILD_TEXT_REMINDER_EMAIL)) {
            TextField textField = new TextField((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_TEXT_REMINDER_EMAIL)));
            return textField;
        }
        if (string.equals(CHILD_TEXT_REMIND_VALUE)) {
            TextField textField = new TextField((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_TEXT_REMIND_VALUE)));
            return textField;
        }
        if (string.equals(CHILD_TEXTAREA_REMIND_MESSAGE)) {
            HtmlDisplayFieldBase htmlDisplayFieldBase = new HtmlDisplayFieldBase((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_TEXTAREA_REMIND_MESSAGE)));
            return htmlDisplayFieldBase;
        }
        if (string.equals(CHILD_COMBO_REMIND_INCR)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_INCR)));
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), REMIND_HOUR_NAMES, "uwc-calclient-");
            OptionList optionList = new OptionList(stringArray, REMIND_HOUR_VALUES);
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_COMBO_REMIND_MONTH)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_MONTH)));
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.monthNames, "uwc-common-");
            OptionList optionList = new OptionList(stringArray, UWCConstants.monthNumValues);
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_COMBO_REMIND_DAY)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_DAY)));
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.dayNames, "uwc-common-");
            OptionList optionList = new OptionList(stringArray, UWCConstants.dayNames);
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_COMBO_REMIND_YEAR)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_YEAR)));
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.yearNames, "uwc-common-");
            OptionList optionList = new OptionList(stringArray, UWCConstants.yearNames);
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_COMBO_REMIND_HOUR)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_HOUR)));
            OptionList optionList = null;
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.hoursIn12HourFormatNames, "uwc-common-");
            if (this._12HrFormat) {
                stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.hoursIn12HourFormatNames, "uwc-common-");
                optionList = new OptionList(stringArray, UWCConstants.hoursIn12HourFormatValues);
            } else {
                stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.hoursIn24HourFormatNames, "uwc-common-");
                optionList = new OptionList(stringArray, UWCConstants.hoursIn24HourFormatNames);
            }
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_COMBO_REMIND_MINS)) {
            ComboBox comboBox = new ComboBox((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_COMBO_REMIND_MINS)));
            OptionList optionList = null;
            String[] stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.minutesIn12HourFormatNames, "uwc-common-");
            if (this._12HrFormat) {
                stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.minutesIn12HourFormatNames, "uwc-common-");
                optionList = new OptionList(stringArray, UWCConstants.minutesIn12HourFormatValues);
            } else {
                stringArray = UWCUserHelper.getLocalizedLabels(this.getRequestContext(), UWCConstants.minutesIn24HourFormatNames, "uwc-common-");
                optionList = new OptionList(stringArray, UWCConstants.minutesIn24HourFormatValues);
            }
            comboBox.setOptions(optionList);
            return comboBox;
        }
        if (string.equals(CHILD_RADIO_REMIND)) {
            RadioButtonGroup radioButtonGroup = new RadioButtonGroup((ContainerView)this, string, (Object)((String)this._fieldsDataMap.get(CHILD_RADIO_REMIND)));
            radioButtonGroup.setOptions(rOptions);
            return radioButtonGroup;
        }
        return null;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        _calLogger.entering(REMINDERS_PANE_CLASS, "beginDisplay");
        if (!this._viewInit) {
            this.initializeView();
        }
        try {
            this.initializeDisplayData();
        }
        catch (UWCException uWCException) {
            _calLogger.severe("[Error:beginDisplay] - " + uWCException.getMessage());
            UWCApplicationHelper.gotoErrorView(this.getRequestContext(), VALARM_FETCH, "uwc-calclient-error-");
        }
        super.beginDisplay(displayEvent);
        _calLogger.exiting(REMINDERS_PANE_CLASS, "beginDisplay");
    }

    private void initializeView() {
        this._userPrefModel = UWCUserHelper.getUserPrefModel(this.getRequestContext());
        String string = this._userPrefModel.getTimeFormat();
        this._12HrFormat = string != null && string.equals(DEFAULT_REMIND_HOUR);
        this._viewInit = true;
    }

    private void initializeDisplayData() throws UWCException {
        _calLogger.entering(REMINDERS_PANE_CLASS, "initializeDisplayData");
        String string = this._userPrefModel.getTimeFormat();
        this.importPageSessionReminder();
        this._fieldsDataMap.put(CHILD_STATIC_SUFFIX_LABEL, this._suffix_label);
        this.exportPageSessionReminder(CHILD_STATIC_SUFFIX_LABEL, this._suffix_label);
        boolean bl = false;
        if (this._reminderObj == null || this._reminderObj != null && !this._reminderObj.getAction().equals("EMAIL")) {
            bl = true;
        }
        if (bl) {
            Object object;
            this._fieldsDataMap.put(CHILD_CHECKBOX_SEND_REMINDER, "false");
            CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this.getRequestContext());
            String string2 = calUserPreferencesModel.getDefaultAlarmEmail();
            String string3 = calUserPreferencesModel.getDefaultAlarmStart();
            String string4 = DEFAULT_REMIND_VALUE;
            String string5 = DEFAULT_REMIND_INCR;
            if (string3 != null) {
                try {
                    object = new Duration(string3);
                    if (object.getDays() > 0) {
                        string4 = String.valueOf(object.getDays());
                        string5 = REMIND_HOUR_VALUES[2];
                    } else if (object.getHours() > 0) {
                        if (object.getHours() % 24 == 0) {
                            string4 = String.valueOf(object.getHours() / 24);
                            string5 = REMIND_HOUR_VALUES[2];
                        } else {
                            string4 = String.valueOf(object.getHours());
                            string5 = REMIND_HOUR_VALUES[1];
                        }
                    } else if (object.getMinutes() > 0) {
                        if (object.getMinutes() % 60 == 0) {
                            string4 = String.valueOf(object.getMinutes() / 60);
                            string5 = REMIND_HOUR_VALUES[2];
                        } else {
                            string4 = String.valueOf(object.getMinutes());
                            string5 = REMIND_HOUR_VALUES[0];
                        }
                    }
                }
                catch (Exception exception) {
                    _calLogger.severe("[Error:initializeDisplayData] - Invalid duration value");
                }
                if (this._isParentModeNew && string2 != null && string2.length() > 0) {
                    this._fieldsDataMap.put(CHILD_CHECKBOX_SEND_REMINDER, "true");
                }
            }
            if (string2 == null) {
                string2 = "";
            }
            this._fieldsDataMap.put(CHILD_TEXT_REMINDER_EMAIL, string2);
            this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, string4);
            this._fieldsDataMap.put(CHILD_TEXTAREA_REMIND_MESSAGE, "");
            this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, string5);
            if (this._defDateTime != null) {
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MONTH, String.valueOf(this._defDateTime.getMonth() + 1));
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_DAY, String.valueOf(this._defDateTime.getDay()));
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_YEAR, String.valueOf(this._defDateTime.getYear()));
                object = UWCUtils.getHoursValue(this._defDateTime, string);
                String string6 = UWCUtils.getMinutesValue(this._defDateTime, string);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_HOUR, object);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MINS, string6);
            } else {
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MONTH, "1");
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_DAY, "1");
                object = Calendar.getInstance();
                String string7 = String.valueOf(((Calendar)object).get(1));
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_YEAR, string7);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_HOUR, DEFAULT_REMIND_HOUR);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MINS, this._12HrFormat ? DEFAULT_REMIND_MINS[0] : DEFAULT_REMIND_MINS[1]);
            }
            this._fieldsDataMap.put(CHILD_RADIO_REMIND, "1");
        } else {
            TimeZone timeZone;
            String string8;
            this._fieldsDataMap.put(CHILD_CHECKBOX_SEND_REMINDER, "true");
            Attendee[] attendeeArray = this._reminderObj.getAttendees();
            String string9 = new String();
            for (int i = 0; i < attendeeArray.length; ++i) {
                string8 = attendeeArray[i].getValue();
                int n = string8.indexOf(ATTENDEE_MAILTO_KEYWORD);
                if (n <= -1) continue;
                string9 = string9 + string8.substring(n + ATTENDEE_MAILTO_KEYWORD.length()) + MAIL_SEPARATOR;
            }
            string9 = string9.substring(0, string9.length() - 1);
            this._fieldsDataMap.put(CHILD_TEXT_REMINDER_EMAIL, string9);
            String string10 = this._reminderObj.getDescription();
            this._fieldsDataMap.put(CHILD_TEXTAREA_REMIND_MESSAGE, string10 != null ? string10 : "");
            string8 = this._reminderObj.getAbsTrigger();
            TimeZone timeZone2 = timeZone = this._defDateTime != null ? this._defDateTime.getTimeZone() : null;
            if (string8 == null) {
                this._fieldsDataMap.put(CHILD_RADIO_REMIND, REMIND_RADIO_SELECT[0]);
                Duration duration = this._reminderObj.getTrigger();
                if (duration == null) {
                    throw new UWCException("Error[ReminderPane]: The reminder object doesn't contain correct information!!");
                }
                if (duration.getDays() > 0) {
                    if (duration.getHours() > 0) {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getDays() * 24 + duration.getHours()));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[1]);
                    } else {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getDays()));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[2]);
                    }
                } else if (duration.getHours() > 0) {
                    if (duration.getHours() % 24 == 0) {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getHours() / 24));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[2]);
                    } else if (duration.getMinutes() > 0) {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getHours() * 60 + duration.getMinutes()));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[0]);
                    } else {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getHours()));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[1]);
                    }
                } else if (duration.getMinutes() > 0) {
                    if (duration.getMinutes() % 60 == 0) {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getMinutes() / 60));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[1]);
                    } else {
                        this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, Integer.toString(duration.getMinutes()));
                        this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, REMIND_HOUR_VALUES[0]);
                    }
                }
                if (this._defDateTime != null) {
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_MONTH, String.valueOf(this._defDateTime.getMonth() + 1));
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_DAY, String.valueOf(this._defDateTime.getDay()));
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_YEAR, String.valueOf(this._defDateTime.getYear()));
                    String string11 = UWCUtils.getHoursValue(this._defDateTime, string);
                    String string12 = UWCUtils.getMinutesValue(this._defDateTime, string);
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_HOUR, string11);
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_MINS, string12);
                } else {
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_MONTH, "1");
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_DAY, "1");
                    Calendar calendar = Calendar.getInstance();
                    String string13 = String.valueOf(calendar.get(1));
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_YEAR, string13);
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_HOUR, DEFAULT_REMIND_HOUR);
                    this._fieldsDataMap.put(CHILD_COMBO_REMIND_MINS, this._12HrFormat ? DEFAULT_REMIND_MINS[0] : DEFAULT_REMIND_MINS[1]);
                }
            } else {
                this._fieldsDataMap.put(CHILD_TEXT_REMIND_VALUE, DEFAULT_REMIND_VALUE);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_INCR, DEFAULT_REMIND_INCR);
                DateTime dateTime = null;
                try {
                    dateTime = timeZone == null ? new DateTime(string8) : new DateTime(string8, timeZone);
                }
                catch (ParseException parseException) {
                    throw new UWCException(parseException.getMessage());
                }
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MONTH, String.valueOf(dateTime.get(2) + 1));
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_DAY, String.valueOf(dateTime.get(5)));
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_YEAR, String.valueOf(dateTime.get(1)));
                String string14 = UWCUtils.getHoursValue(dateTime, string);
                String string15 = UWCUtils.getMinutesValue(dateTime, string);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_HOUR, string14);
                this._fieldsDataMap.put(CHILD_COMBO_REMIND_MINS, string15);
                this._fieldsDataMap.put(CHILD_RADIO_REMIND, REMIND_RADIO_SELECT[1]);
            }
        }
        _calLogger.exiting(REMINDERS_PANE_CLASS, "initializeDisplayData");
    }

    public void setParentType(String string) {
        _calLogger.entering(REMINDERS_PANE_CLASS, "setParentType");
        if (string == null) {
            string = "event";
        }
        if (string.equals("event")) {
            this._suffix_label = UWCUserHelper.getLocalizedStringLabel(this.getRequestContext(), BEFORE_EVENT_SUFFIX, BEFORE_EVENT_SUFFIX_CONST);
        } else if (string.equals("todo")) {
            this._suffix_label = UWCUserHelper.getLocalizedStringLabel(this.getRequestContext(), BEFORE_DUETASK_SUFFIX, BEFORE_DUETASK_SUFFIX_CONST);
        }
        _calLogger.exiting(REMINDERS_PANE_CLASS, "setParentType");
    }

    public void setContextDate(DateTime dateTime) {
        _calLogger.entering(REMINDERS_PANE_CLASS, "setDefaultDateTime");
        this._defDateTime = dateTime;
        _calLogger.exiting(REMINDERS_PANE_CLASS, "setReminderObj");
    }

    public void setReminderObj(VAlarm vAlarm) {
        _calLogger.entering(REMINDERS_PANE_CLASS, "setReminderObj");
        this._reminderObj = vAlarm;
        _calLogger.exiting(REMINDERS_PANE_CLASS, "setReminderObj");
    }

    public void setNewMode(boolean bl) {
        _calLogger.entering(REMINDERS_PANE_CLASS, "setReminderObj");
        this._isParentModeNew = bl;
        _calLogger.exiting(REMINDERS_PANE_CLASS, "setReminderObj");
    }

    public VAlarm getReminderObj(TimeZone timeZone) throws UWCException {
        _calLogger.entering(REMINDERS_PANE_CLASS, "getReminderObj");
        this.assembleChgdReminderObj(timeZone);
        _calLogger.exiting(REMINDERS_PANE_CLASS, "getReminderObj");
        return this._reminderObj;
    }

    private void assembleChgdReminderObj(TimeZone timeZone) throws UWCException {
        _calLogger.entering(REMINDERS_PANE_CLASS, "assembleChgdReminderObj");
        HtmlDisplayFieldBase htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_CHECKBOX_SEND_REMINDER);
        if (((CheckBox)htmlDisplayFieldBase).isChecked()) {
            Object object;
            String string;
            SOCSAlarm sOCSAlarm = new SOCSAlarm();
            htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_TEXT_REMINDER_EMAIL);
            String string2 = htmlDisplayFieldBase.stringValue().trim();
            if (string2.length() == 0) {
                throw new UWCException(71, "Error: Reminder Email Address is missing or invalid.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, MAIL_SEPARATOR);
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken().trim();
                _calLogger.info("Email before isValidAddress - " + string);
                if (!UWCUtils.isValidEmailAddress(string)) {
                    throw new UWCException(71, "Error: Reminder Email Address is missing or invalid.");
                }
                try {
                    _calLogger.info("Email after isValidAddress before new Attendee - " + string);
                    object = new Attendee("ATTENDEE:MAILTO:" + string);
                    sOCSAlarm.addAttendee((Attendee)object);
                    _calLogger.info("Email after new Attendee - " + string);
                }
                catch (PropertiesException propertiesException) {
                    throw new UWCException(71, "Error: Failed to create an attendee for reminder object.");
                }
            }
            htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_RADIO_REMIND);
            string2 = htmlDisplayFieldBase.stringValue();
            if (string2.equals(REMIND_RADIO_SELECT[0])) {
                htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_TEXT_REMIND_VALUE);
                string2 = htmlDisplayFieldBase.stringValue();
                if (string2.length() == 0) {
                    throw new UWCException(76, "Error: Reminder relative value is missing.");
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                    if (n == 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UWCException(76, "Error: Reminder relative value is not valid.");
                }
                htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_INCR);
                object = htmlDisplayFieldBase.stringValue();
                Duration duration = null;
                try {
                    if (((String)object).equals(REMIND_HOUR_VALUES[0])) {
                        int n2 = n / 60;
                        int n3 = n % 60;
                        duration = new Duration(0, n2, n3, 0);
                    } else if (((String)object).equals(REMIND_HOUR_VALUES[1])) {
                        int n4 = n / 24;
                        int n5 = n % 24;
                        duration = new Duration(n4, n5, 0, 0);
                    } else {
                        duration = new Duration(n, 0, 0, 0);
                    }
                }
                catch (PropertiesException propertiesException) {
                    _calLogger.severe("[Error:assembleReminderObj] - " + propertiesException.getMessage());
                    throw new UWCException(76, "Error: Failed to create relative reminder.");
                }
                duration.setSign(-1);
                sOCSAlarm.setTrigger(duration);
            } else {
                string = null;
                string = timeZone != null ? new DateTime(timeZone) : new DateTime();
                string.setLenient(false);
                try {
                    htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_MONTH);
                    string2 = htmlDisplayFieldBase.stringValue();
                    string.setMonth(Integer.parseInt(string2) - 1);
                    htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_DAY);
                    string2 = htmlDisplayFieldBase.stringValue();
                    string.setDay(Integer.parseInt(string2));
                    htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_YEAR);
                    string2 = htmlDisplayFieldBase.stringValue();
                    string.setYear(Integer.parseInt(string2));
                    htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_HOUR);
                    int n = Integer.parseInt(htmlDisplayFieldBase.stringValue());
                    htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_COMBO_REMIND_MINS);
                    int n6 = Integer.parseInt(htmlDisplayFieldBase.stringValue());
                    n += n6 / 60;
                    string.setHours(n);
                    string.setMinutes(n6 %= 60);
                    sOCSAlarm.setAbsTrigger(string.toISO8601());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UWCException(10, "Error: Reminder date information is not valid.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new UWCException(10, "Error: Reminder date information is not valid.");
                }
            }
            htmlDisplayFieldBase = (HtmlDisplayFieldBase)this.getChild(CHILD_TEXTAREA_REMIND_MESSAGE);
            string2 = htmlDisplayFieldBase.stringValue();
            if (string2.length() != 0) {
                sOCSAlarm.setDescription(string2);
            }
            try {
                sOCSAlarm.setAction("EMAIL");
            }
            catch (PropertiesException propertiesException) {
                throw new UWCException(72, "Error:Failed to set the email the reminder");
            }
            this._reminderObj = sOCSAlarm;
        } else {
            this._reminderObj = null;
        }
        _calLogger.exiting(REMINDERS_PANE_CLASS, "assembleChgdReminderObj");
    }

    public void exportPageSessionReminder() {
        if (this._reminderObj != null) {
            this.exportPageSessionReminder(PAGE_ATTR, ((SOCSAlarm)this._reminderObj).toRFC2445());
        }
    }

    public void exportPageSessionReminder(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            this.deletePageSessionReminder(string);
            return;
        }
        ViewBean viewBean = (ViewBean)this.getParent();
        if (null == viewBean) {
            return;
        }
        viewBean.setPageSessionAttribute(string, (Serializable)((Object)string2));
        _calLogger.exiting(REMINDERS_PANE_CLASS, "exportPageSessionReminder");
    }

    public void importPageSessionReminder() throws UWCException {
        _calLogger.entering(REMINDERS_PANE_CLASS, "importPageSessionReminder");
        ViewBean viewBean = (ViewBean)this.getParent();
        if (null == viewBean) {
            return;
        }
        String string = (String)viewBean.getPageSessionAttribute(PAGE_ATTR);
        String string2 = (String)viewBean.getPageSessionAttribute(CHILD_STATIC_SUFFIX_LABEL);
        if (string2 != null && string2.length() > 0) {
            this._suffix_label = string2;
        }
        try {
            if (null != string) {
                this._reminderObj = new SOCSAlarm(null, string);
            } else if (_calLogger.isLoggable(Level.FINE)) {
                _calLogger.fine("nothing to import from the page session");
            }
        }
        catch (PropertiesException propertiesException) {
            if (_calLogger.isLoggable(Level.SEVERE)) {
                _calLogger.severe(propertiesException.getMessage());
            }
            throw new UWCException(propertiesException.getMessage());
        }
        _calLogger.exiting(REMINDERS_PANE_CLASS, "importPageSessionReminder");
    }

    public void deletePageSessionReminder(String string) {
        ViewBean viewBean = (ViewBean)this.getParent();
        if (null == viewBean) {
            return;
        }
        viewBean.removePageSessionAttribute(string);
    }

    public void deletePageSessionReminder() {
        this.deletePageSessionReminder(PAGE_ATTR);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

