/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.util.WrapperRuntimeException;
import com.sun.uwc.calclient.MultipartContent;
import com.sun.uwc.common.util.UWCLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class MultipartFormServletFilter
implements Filter {
    private static Logger _multiPartLogger = null;
    private static final String CLASS_NAME = "MultipartFormServletFilter";
    private static final String DASH = "-";
    private static final String SEMICOLON = ";";
    private static final String TWO_DASHES = "--";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String FILENAME_ATTRIBUTE = "filename";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String BLANK = "";
    private static final String ASSIGNMENT = "=";
    private static final String CONTENT_TYPE_HEADER_PREFIX = "Content-Type:";
    private static final int CONTENT_TYPE_HEADER_PREFIX_LEN;
    private static final String MULTIPART_CONTENT_TYPE_HEADER_PREFIX = "multipart/form-data;";
    private static final int MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN;
    private static final String MULTIPART_CONTENT_TYPE_BOUNDARY_DEF = "boundary=";
    private static final int MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN;
    private static final String MULTIPART_CONTENT_DISPOSITION_PREFIX = "Content-Disposition: form-data;";
    private static final int MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN;
    public static final String TEMP_FILE_PREFIX = "jato";
    public static final String TEMP_FILE_SUFFIX;
    public static final String TEMP_FILE_DIRECTORY_INIT_PARAMETER = "tempFileDirectory";
    public static final String USE_TEMP_FILE_INIT_PARAMETER = "useTempFile";
    public static final String AUTO_DELETE_TEMP_FILE_INIT_PARAMETER = "autoDeleteTempFile";
    public static final String FILE_SIZE_LIMIT_INIT_PARAMETER = "fileSizeLimit";
    public static final String FILE_SIZE_HARD_LIMIT_INIT_PARAMETER = "fileSizeHardLimit";
    public static final String REQUEST_SIZE_LIMIT_INIT_PARAMETER = "requestSizeLimit";
    public static final String FAILURE_REDIRECT_URL_INIT_PARAMETER = "failureRedirectURL";
    public static final int DEFAULT_FILE_SIZE_LIMIT = 0x100000;
    public static final int DEFAULT_FILE_SIZE_HARD_LIMIT = 0x200000;
    public static final int DEFAULT_REQUEST_SIZE_LIMIT = 0x400000;
    private int fileSizeLimit = 0x100000;
    private int fileSizeHardLimit = 0x200000;
    private int requestSizeLimit = 0x400000;
    private boolean useTempFile = true;
    private boolean autoDeleteTempFile;
    private String tempFileDirectory;
    private String failureRedirectURL;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        this.setFilterConfig(filterConfig);
        String string = filterConfig.getInitParameter(AUTO_DELETE_TEMP_FILE_INIT_PARAMETER);
        if (null != string) {
            this.autoDeleteTempFile = Boolean.valueOf(string);
        }
        if (null != (string = filterConfig.getInitParameter(USE_TEMP_FILE_INIT_PARAMETER))) {
            this.useTempFile = Boolean.valueOf(string);
        }
        if (this.useTempFile) {
            this.tempFileDirectory = filterConfig.getInitParameter(TEMP_FILE_DIRECTORY_INIT_PARAMETER);
            try {
                File file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new File(this.tempFileDirectory));
                if (this.autoDeleteTempFile) {
                    file.delete();
                }
            }
            catch (IOException iOException) {
                this.useTempFile = false;
                _multiPartLogger.warning("Failure creating test file in directory \"" + (null == this.tempFileDirectory ? "DEFAULT" : this.tempFileDirectory) + "\"; disabling temp file for uploads");
            }
        }
        if (null != (string = filterConfig.getInitParameter(FILE_SIZE_LIMIT_INIT_PARAMETER))) {
            try {
                this.fileSizeLimit = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                _multiPartLogger.warning("Invalid value for parameter \"fileSizeLimit\"; using default max byte size 1048576");
            }
        }
        if (null != (string = filterConfig.getInitParameter(FILE_SIZE_HARD_LIMIT_INIT_PARAMETER))) {
            try {
                this.fileSizeHardLimit = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                _multiPartLogger.warning("Invalid value for parameter \"fileSizeHardLimit\"; using default max byte size 2097152");
            }
        }
        if (null != (string = filterConfig.getInitParameter(REQUEST_SIZE_LIMIT_INIT_PARAMETER))) {
            try {
                this.requestSizeLimit = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                _multiPartLogger.warning("Invalid value for parameter \"requestSizeLimit\", using default max byte size 4194304");
            }
        }
        this.failureRedirectURL = filterConfig.getInitParameter(FAILURE_REDIRECT_URL_INIT_PARAMETER);
        _multiPartLogger.fine("Filter parameter useTempFile = " + this.useTempFile);
        _multiPartLogger.fine("Filter parameter autoDeleteTempFile = " + this.autoDeleteTempFile);
        _multiPartLogger.fine("Filter parameter tempFileDirectory = " + this.tempFileDirectory);
        _multiPartLogger.fine("Filter parameter fileSizeLimit = " + this.fileSizeLimit);
        _multiPartLogger.fine("Filter parameter fileSizeHardLimit = " + this.fileSizeHardLimit);
        _multiPartLogger.fine("Filter parameter requestSizeLimit = " + this.requestSizeLimit);
        _multiPartLogger.fine("Filter parameter failureRedirectURL = " + this.failureRedirectURL);
    }

    public void destroy() {
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getContentType() != null && servletRequest.getContentType().startsWith(MULTIPART_CONTENT_TYPE_HEADER_PREFIX)) {
            if (servletRequest.getContentLength() >= this.requestSizeLimit) {
                if (null != this.failureRedirectURL) {
                    try {
                        servletRequest.getInputStream().skip(1024L);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        ((HttpServletResponse)servletResponse).sendRedirect(this.failureRedirectURL);
                        return;
                    }
                    catch (IOException iOException) {
                        _multiPartLogger.warning("Failure attempting to redirect: " + iOException.getMessage());
                    }
                }
                throw new IOException("Request cancelled because the Content-length \"" + servletRequest.getContentLength() + "\" is over the configurable limit of " + this.requestSizeLimit + " bytes; see filter init parameter " + REQUEST_SIZE_LIMIT_INIT_PARAMETER);
            }
            String string = servletRequest.getContentType().substring(MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN).trim();
            String string2 = string.substring(MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN);
            try {
                filterChain.doFilter((ServletRequest)new RequestWrapper(string2, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse), servletResponse);
                return;
            }
            catch (CompleteRequestException completeRequestException) {}
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
    }

    static {
        _multiPartLogger = UWCLogger.getLogger("uwc.calclient");
        CONTENT_TYPE_HEADER_PREFIX_LEN = CONTENT_TYPE_HEADER_PREFIX.length();
        MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN = MULTIPART_CONTENT_TYPE_HEADER_PREFIX.length();
        MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN = MULTIPART_CONTENT_TYPE_BOUNDARY_DEF.length();
        MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN = MULTIPART_CONTENT_DISPOSITION_PREFIX.length();
        TEMP_FILE_SUFFIX = null;
    }

    public class RequestWrapper
    extends HttpServletRequestWrapper {
        private String contentDelimiter;
        private byte[] contentDelimiterBytes;
        private String currentLine;
        private String boundary;
        private Map localParameters;
        private HttpServletResponse response;

        public RequestWrapper(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(httpServletRequest);
            this.boundary = string;
            this.response = httpServletResponse;
            this.adaptParameters();
        }

        public String getParameter(String string) {
            Object v = this.localParameters.get(string);
            if (v instanceof String[]) {
                return ((String[])v)[0];
            }
            return (String)v;
        }

        public String[] getParameterValues(String string) {
            Object v = this.localParameters.get(string);
            if (v instanceof String[]) {
                return (String[])v;
            }
            return new String[]{(String)v};
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.localParameters.keySet());
        }

        public Map getParameterMap() {
            return this.localParameters;
        }

        protected void adaptParameters() {
            if (null == this.localParameters) {
                this.localParameters = new HashMap();
                Map map = this.getRequest().getParameterMap();
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    Object v = map.get(k);
                    this.localParameters.put(k, v);
                }
                try {
                    this.transcribeDelimitedContent();
                }
                catch (IOException iOException) {
                    if (null != MultipartFormServletFilter.this.failureRedirectURL) {
                        try {
                            this.response.sendRedirect(MultipartFormServletFilter.this.failureRedirectURL);
                            throw new CompleteRequestException();
                        }
                        catch (IOException iOException2) {
                            _multiPartLogger.warning("Failure attempting to redirect after " + iOException2.getMessage());
                        }
                    }
                    throw new WrapperRuntimeException((Throwable)iOException);
                }
            }
        }

        protected String readLine(DataInputStream dataInputStream) throws IOException {
            byte by;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (-1 != (by = dataInputStream.readByte())) {
                if (by != 13) {
                    byteArrayOutputStream.write(by);
                    continue;
                }
                byte by2 = dataInputStream.readByte();
                if (-1 == by2 || by2 == 10) break;
                byteArrayOutputStream.write(by);
                byteArrayOutputStream.write(by2);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toString();
        }

        protected void transcribeDelimitedContent() throws IOException {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream((InputStream)this.getRequest().getInputStream()));
            this.currentLine = this.readLine(dataInputStream);
            if (!this.currentLine.startsWith(MultipartFormServletFilter.DASH)) {
                _multiPartLogger.warning("First line of input does not start with dash \"" + this.currentLine + MultipartFormServletFilter.DOUBLE_QUOTE);
                return;
            }
            this.contentDelimiter = this.currentLine;
            this.contentDelimiterBytes = this.contentDelimiter.getBytes();
            while (!this.currentLine.endsWith(MultipartFormServletFilter.TWO_DASHES)) {
                this.currentLine = this.readLine(dataInputStream);
                if (!this.currentLine.startsWith(MultipartFormServletFilter.MULTIPART_CONTENT_DISPOSITION_PREFIX)) {
                    _multiPartLogger.warning("Expected line to start with \"Content-Disposition: form-data;\"");
                    return;
                }
                String string = this.currentLine.substring(MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN).trim();
                String[] stringArray = StringTokenizer2.tokenize((String)string, (String)MultipartFormServletFilter.SEMICOLON, (boolean)true);
                String string2 = this.getContentDispositionNameAttribute(stringArray);
                String string3 = this.getContentDispositionFilenameAttribute(stringArray);
                this.currentLine = this.readLine(dataInputStream);
                if (this.currentLine.trim().equals(MultipartFormServletFilter.BLANK)) {
                    this.processFormField(dataInputStream, string2);
                    continue;
                }
                if (this.currentLine.startsWith(MultipartFormServletFilter.CONTENT_TYPE_HEADER_PREFIX)) {
                    this.processFile(dataInputStream, string2, string3, this.currentLine.substring(CONTENT_TYPE_HEADER_PREFIX_LEN).trim());
                    continue;
                }
                _multiPartLogger.warning("Expected either blank line or \"Content-Type:\"");
                return;
            }
        }

        protected void processFile(DataInputStream dataInputStream, String string, String string2, String string3) throws IOException {
            Object object;
            OutputStream outputStream;
            this.readLine(dataInputStream);
            File file = null;
            if (MultipartFormServletFilter.this.useTempFile) {
                file = File.createTempFile(MultipartFormServletFilter.TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new File(MultipartFormServletFilter.this.tempFileDirectory));
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
            } else {
                outputStream = new ByteArrayOutputStream();
            }
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            while (true) {
                int n3;
                if (n2 >= MultipartFormServletFilter.this.fileSizeHardLimit) {
                    throw new IOException("Request cancelled because file input field \"" + string + "\" size is over the configurable limit " + "of " + MultipartFormServletFilter.this.fileSizeHardLimit + " bytes; see filter init parameter " + MultipartFormServletFilter.FILE_SIZE_HARD_LIMIT_INIT_PARAMETER);
                }
                byte by = dataInputStream.readByte();
                if (bl) {
                    if (by == this.contentDelimiterBytes[n]) {
                        if (++n != this.contentDelimiterBytes.length) continue;
                        break;
                    }
                    if (++n2 <= MultipartFormServletFilter.this.fileSizeLimit) {
                        outputStream.write(13);
                    }
                    if (++n2 <= MultipartFormServletFilter.this.fileSizeLimit) {
                        outputStream.write(10);
                    }
                    if (++n2 <= MultipartFormServletFilter.this.fileSizeLimit) {
                        outputStream.write(by);
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        if (++n2 > MultipartFormServletFilter.this.fileSizeLimit) continue;
                        outputStream.write(this.contentDelimiterBytes[n3]);
                    }
                    n = 0;
                    bl = false;
                    continue;
                }
                if (by != 13) {
                    if (++n2 > MultipartFormServletFilter.this.fileSizeLimit) continue;
                    outputStream.write(by);
                    continue;
                }
                n3 = dataInputStream.readByte();
                if (n3 != 10) {
                    if (++n2 <= MultipartFormServletFilter.this.fileSizeLimit) {
                        outputStream.write(by);
                    }
                    if (++n2 > MultipartFormServletFilter.this.fileSizeLimit) continue;
                    outputStream.write(n3);
                    continue;
                }
                bl = true;
            }
            this.currentLine = this.contentDelimiter;
            this.currentLine = this.currentLine + dataInputStream.readByte() + dataInputStream.readByte();
            outputStream.flush();
            MultipartContent multipartContent = new MultipartContent();
            multipartContent.setInputName(string);
            multipartContent.setSubmittedFileName(string2);
            multipartContent.setContentType(string3);
            if (n2 >= MultipartFormServletFilter.this.fileSizeLimit) {
                multipartContent.setDiscarded(true);
                if (file != null) {
                    // empty if block
                }
                if (MultipartFormServletFilter.this.autoDeleteTempFile) {
                    file.delete();
                }
            } else if (MultipartFormServletFilter.this.useTempFile) {
                multipartContent.setFile(file);
                outputStream.close();
                if (MultipartFormServletFilter.this.autoDeleteTempFile) {
                    file.deleteOnExit();
                }
            } else {
                multipartContent.setBlob(((ByteArrayOutputStream)outputStream).toByteArray());
            }
            if (null == (object = this.getRequest().getAttribute(string))) {
                this.getRequest().setAttribute(string, (Object)multipartContent);
            } else if (object instanceof MultipartContent) {
                MultipartContent[] multipartContentArray = new MultipartContent[]{(MultipartContent)object, multipartContent};
                this.getRequest().setAttribute(string, (Object)multipartContentArray);
            } else if (object instanceof MultipartContent[]) {
                MultipartContent[] multipartContentArray = (MultipartContent[])object;
                ArrayList<MultipartContent> arrayList = new ArrayList<MultipartContent>();
                for (int i = 0; i < multipartContentArray.length; ++i) {
                    arrayList.add(multipartContentArray[i]);
                }
                arrayList.add(multipartContent);
                this.getRequest().setAttribute(string, (Object)arrayList.toArray(new MultipartContent[arrayList.size()]));
            }
        }

        protected void processFormField(DataInputStream dataInputStream, String string) throws IOException {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.currentLine = this.readLine(dataInputStream);
            while (!this.currentLine.startsWith(this.contentDelimiter)) {
                arrayList.add(this.currentLine);
                this.currentLine = this.readLine(dataInputStream);
            }
            if (arrayList.size() == 1) {
                this.localParameters.put(string, arrayList.get(0));
            } else {
                this.localParameters.put(string, arrayList.toArray(new String[arrayList.size()]));
            }
        }

        protected String getContentDispositionNameAttribute(String[] stringArray) {
            String[] stringArray2 = StringTokenizer2.tokenize((String)stringArray[0], (String)MultipartFormServletFilter.ASSIGNMENT, (boolean)true);
            return StringTokenizer2.replace((String)stringArray2[1], (String)MultipartFormServletFilter.DOUBLE_QUOTE, (String)MultipartFormServletFilter.BLANK);
        }

        protected String getContentDispositionFilenameAttribute(String[] stringArray) {
            if (stringArray.length == 1) {
                return null;
            }
            String[] stringArray2 = StringTokenizer2.tokenize((String)stringArray[1], (String)MultipartFormServletFilter.ASSIGNMENT, (boolean)true);
            return StringTokenizer2.replace((String)stringArray2[1], (String)MultipartFormServletFilter.DOUBLE_QUOTE, (String)MultipartFormServletFilter.BLANK);
        }

        private void warning(String string) {
        }
    }
}

