/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.abclient;

import com.iplanet.xslui.auth.ABUserSession;
import com.iplanet.xslui.auth.ABUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.auth.Domain;
import com.sun.uwc.common.auth.LDAPConfig;
import com.sun.uwc.common.auth.LDAPDomainMap;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.util.UWCLogger;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class ABInitFilter
extends AuthFilter {
    private static final String _userPrefExtAttribName = "sunAbExtendedUserPrefs";
    private static final String[] _userPrefAttribs = new String[]{"abName", "abDescription", "abEntriesPerPage", "abSearchDisplayColumn1", "abSearchDisplayColumn2", "abSearchDisplayColumn3", "abSearchDisplayColumn4", "abSearchDisplayColumn5", "abSearchDisplayColumn6", "abSearchDisplayColumn7"};
    private static final String AB_INITIALIZED_TRUE = "sunAbInitialized=true";
    private static final String PSROOT_ATTR_NAME = "psRoot";
    private static final String IP_USER_OC = "ipUser";
    private Preferences _preferences;
    private static final String CLASS_NAME = "ABInitFilter";
    private static Logger _abLogger;
    private static LDAPPool _ldPool;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this._preferences = super.getPreferences();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        _abLogger.entering(CLASS_NAME, "doFilter");
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession(false);
        if (httpSession == null) {
            _abLogger.warning("Session is not created, user not authenticated!!");
            servletRequest.setAttribute("integration", (Object)"true");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            _abLogger.warning("Address Book session already set!!");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (userSession == null && httpSession != null) {
            _abLogger.info(" --- Creating ABUserSession --- ");
            object = new ABUserSessionFactory();
            userSession = object.newUserSession(httpSession);
        }
        if (userSession == null) {
            _abLogger.warning("Failed in preparing Address Book!!");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        httpSession.setAttribute("integration", (Object)"true");
        object = (String)httpSession.getAttribute("sunAbInitialized");
        _abLogger.fine(" What is sunAbInitialized: " + (String)object);
        if (object == null || object != null && !((String)object).equals("true")) {
            _abLogger.fine(" About to call initializeABPrefs");
            if (!this.initializeABPrefs(httpSession)) {
                _abLogger.severe("Could not initialize preferences");
            }
        }
        _abLogger.exiting(CLASS_NAME, "doFilter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public boolean initializeABPrefs(HttpSession httpSession) {
        ABUserSession aBUserSession;
        String[] stringArray;
        Object object;
        _abLogger.entering(CLASS_NAME, "initializeABPrefs");
        String string = (String)httpSession.getAttribute("domainname");
        String string2 = (String)httpSession.getAttribute("uid");
        LDAPEntry lDAPEntry = null;
        if (UWCApplicationHelper.isIdentityEnabled()) {
            object = (String)httpSession.getAttribute("userdn");
            if (object == null) {
                _abLogger.severe("initializeABPrefs - Even with IS enabled, couldn't get user's dn. Hence can't get preferences!!");
                return false;
            }
            lDAPEntry = UWCUserHelper.getUserEntry((String)object);
        } else {
            object = new LDAPConfig(this._preferences);
            LDAPDomainMap lDAPDomainMap = LDAPDomainMap.getInstance(this._preferences);
            stringArray = lDAPDomainMap.getDomainObject(string, true);
            lDAPEntry = UWCUserHelper.getUserEntry(string2, (Domain)stringArray, (LDAPConfig)object, true);
        }
        this.addIpUserClassIfReq(lDAPEntry);
        object = this.getUserAttribs(lDAPEntry, _userPrefExtAttribName);
        boolean bl = false;
        if (object == null) {
            _abLogger.severe("initializeABPrefs - Failed to get the user attributes");
        } else {
            block0: for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].equalsIgnoreCase(AB_INITIALIZED_TRUE)) {
                    bl = true;
                    _abLogger.fine("abInited_in_Ldap = true");
                    continue;
                }
                aBUserSession = object[i].split("=");
                String string3 = aBUserSession[0];
                ABUserSession aBUserSession2 = null;
                if (((ABUserSession)aBUserSession).length > 1) {
                    aBUserSession2 = aBUserSession[1];
                }
                for (int j = 0; j < _userPrefAttribs.length; ++j) {
                    if (!string3.equals(_userPrefAttribs[j])) continue;
                    if (aBUserSession2 == null) continue block0;
                    httpSession.setAttribute(_userPrefAttribs[j], (Object)aBUserSession2);
                    continue block0;
                }
            }
            httpSession.setAttribute("sunAbInitialized", (Object)"true");
        }
        if (!bl) {
            _abLogger.fine("AB not inited in LDAP. Will further check if psRoot is present");
            stringArray = this.getUserAttribs(lDAPEntry, PSROOT_ATTR_NAME);
            if (stringArray == null || stringArray.length == 0) {
                _abLogger.fine("ABInitFilter.initializeABPrefs():psRoot value NOT present in Ldap");
                aBUserSession = (ABUserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
                this.setDefaultPsRoot((UserSession)aBUserSession);
            }
        }
        _abLogger.info("Successfully Initialized AB Preferences into session");
        _abLogger.exiting(CLASS_NAME, "initializeABPrefs");
        return true;
    }

    private String[] getUserAttribs(LDAPEntry lDAPEntry, String string) {
        if (lDAPEntry == null || string == null) {
            return null;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private void addIpUserClassIfReq(LDAPEntry lDAPEntry) {
        block4: {
            String[] stringArray = this.getUserAttribs(lDAPEntry, "ObjectClass");
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!IP_USER_OC.equalsIgnoreCase(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                LDAPConnection lDAPConnection = null;
                _abLogger.info("ipUser class not present in: " + lDAPEntry.getDN() + ". Will add it");
                try {
                    this.setLDAPPool();
                    lDAPConnection = _ldPool.getConnection();
                    LDAPAttribute lDAPAttribute = new LDAPAttribute("ObjectClass", IP_USER_OC);
                    LDAPModification lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(lDAPEntry.getDN(), lDAPModification);
                }
                catch (LDAPException lDAPException) {
                    _abLogger.severe("Could not add ipUser object class to the user entry: " + lDAPEntry.getDN());
                    if (null == lDAPConnection) break block4;
                    _ldPool.close(lDAPConnection);
                }
            }
        }
    }

    private void setDefaultPsRoot(UserSession userSession) {
        _abLogger.entering(CLASS_NAME, "setDefaultPsRoot");
        this.setLDAPPool();
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = _ldPool.getConnection();
        }
        catch (LDAPException lDAPException) {
            _abLogger.severe("Could not get ldap connection");
        }
        if (!((ABUserSession)userSession).setDefaultPsRoot(lDAPConnection)) {
            _abLogger.severe("Exception while setting defaultpsroot");
        }
        _ldPool.close(lDAPConnection);
        _abLogger.exiting(CLASS_NAME, "setDefaultPsRoot");
    }

    private void setLDAPPool() {
        if (_ldPool == null) {
            _ldPool = UWCApplicationHelper.getLDAPPool();
        }
    }

    public void destroy() {
    }

    static {
        _ldPool = null;
        _abLogger = UWCLogger.getLogger("uwc.abclient");
    }
}

