/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.xmlplug;

import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.xmlplug.SortUtils;
import com.iplanet.iabs.xmlplug.XMLPagedSearch;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPlugin
implements PS_DBPlugin {
    private Hashtable _dbCache;
    private String _rootPath;
    private boolean _dumpXML;
    private static XMLDOMBuilder _documentBuilder = null;

    public XMLPlugin(String string, int n) throws piDbException {
        File file = new File(string, "db_config.properties");
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file);
        }
        catch (IOException iOException) {
            throw new piDbException(3, string + "\\db_config.properties");
        }
        this._dumpXML = propertyReader.getBooleanProperty("write", "false");
        this._rootPath = string;
        this._dbCache = new Hashtable();
        if (_documentBuilder == null) {
            try {
                _documentBuilder = new XMLDOMBuilder();
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(0, "Failed to initialize _documentBuilder: " + xMLProcessingException.getMessage());
            }
        }
    }

    public int search(UserSession userSession, String string, String string2, Vector vector, Vector vector2, Vector vector3, Element element, int n) throws piDbException {
        ArrayList arrayList = new ArrayList();
        Document document = this.getDBDocument(string);
        if (string == null) {
            throw new piDbException(22, "No search file passed !");
        }
        if (string2 == null || string2.length() == 0) {
            throw new piDbException(0, "No search filter passed !");
        }
        if (element == null) {
            throw new piDbException(28, "searchBook: no resElt");
        }
        Document document2 = element.getOwnerDocument();
        if (document2 == null) {
            throw new piDbException(28, "searchBook: resElt not attached to any doc");
        }
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        arrayList = this.globalSortSearch(userSession, document, string2, vector2, vector3, n);
        XMLPlugin.buildResultDoc(arrayList, 1, arrayList.size(), vector, 0, element);
        return arrayList.size();
    }

    public PagedSearch pagedSearch(UserSession userSession, String string, String string2, Vector vector, Vector vector2, Vector vector3, int n, int n2) throws piDbException {
        ArrayList arrayList = new ArrayList();
        Document document = null;
        if (string == null) {
            throw new piDbException(22, " No file to search in !");
        }
        if (string2 == null || string2.length() == 0) {
            throw new piDbException(0, " No search filter passed !");
        }
        document = this.getDBDocument(string);
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        arrayList = this.globalSortSearch(userSession, document, string2, vector2, vector3, n2);
        return new XMLPagedSearch(arrayList, n, vector);
    }

    public void getEntry(UserSession userSession, String string, String string2, Element element, int n) throws piDbException {
        ArrayList arrayList = new ArrayList();
        Vector<String> vector = new Vector<String>();
        vector.add("*");
        String string3 = "";
        if (string == null) {
            throw new piDbException(28, " No search file passed !");
        }
        if (element == null) {
            throw new piDbException(28, " The result doc hanger is null !");
        }
        if (element == null) {
            throw new piDbException(28, "searchBook: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new piDbException(28, "searchBook: resElt not attached to any doc");
        }
        if (string2 == null || string2.length() == 0) {
            throw new piDbException(17, " No entry searched !");
        }
        string3 = string3.concat("entry/@entryID");
        string3 = string3.concat("=");
        string3 = string3.concat(string2);
        Document document2 = this.getDBDocument(string);
        if (document2 == null) {
            throw new piDbException(77, " Can't find DB for " + string);
        }
        arrayList = this.globalSortSearch(userSession, document2, string3, null, vector, 0);
        if (arrayList.size() == 0) {
            throw new piDbException(17, " No entry found (" + string3 + ") !");
        }
        XMLPlugin.buildResultDoc(arrayList, 1, 1, null, 0, element);
    }

    private Vector parseFilterFormula(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.startsWith("&")) {
            int n = 2;
            int n2 = string.indexOf(")");
            while (n2 > n) {
                vector.add(string.substring(n, n2));
                n = n2 + string.substring(n2).indexOf("(") + 1;
                n2 = n + string.substring(n).indexOf(")");
            }
        } else {
            vector.add(string);
        }
        return vector;
    }

    private String wrapLDAPFilter(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf("=");
        if (n != -1) {
            stringBuffer.insert(n + 1, '\'');
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    private ArrayList globalSortSearch(UserSession userSession, Document document, String string, Vector vector, Vector vector2, int n) throws piDbException {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        String string2 = null;
        Vector vector3 = new Vector();
        vector3 = this.parseFilterFormula(string);
        String string3 = this.wrapLDAPFilter((String)vector3.get(0));
        if (vector2 == null || vector2.size() <= 0) {
            vector2 = new Vector<String>(1);
            vector2.add("*");
        }
        for (int i = 0; i < vector2.size(); ++i) {
            string2 = XMLPlugin.buildSearchXpath(string3, (String)vector2.get(i));
            try {
                XPathTools.getNodesByXPath((Node)document, (String)string2, arrayList);
                continue;
            }
            catch (Exception exception) {
                throw new piDbException(0, " Error while processing path: " + string2 + ": " + exception.getMessage());
            }
        }
        for (int i = 1; i < vector3.size(); ++i) {
            try {
                string2 = this.wrapLDAPFilter((String)vector3.get(i));
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    boolean bl2 = false;
                    boolean bl3 = XPathTools.bracketFormulaMatch((Node)((Node)arrayList.get(n2)), (String)string2);
                    if (!bl3) {
                        bl2 = true;
                        arrayList.remove(n2);
                    }
                    if (bl2) continue;
                    ++n2;
                }
                continue;
            }
            catch (Exception exception) {
                throw new piDbException(0, " Error while processing path: " + string2 + ": " + exception.getMessage());
            }
        }
        if (vector != null && vector.size() != 0) {
            String string4 = vector.elementAt(0).toString();
            bl = string4.charAt(0) == '-';
            string4 = string4.charAt(0) == '+' || string4.charAt(0) == '-' ? string4.substring(1) : string4;
            arrayList = XMLPlugin.sortNodes(arrayList, string4, bl);
        }
        return arrayList;
    }

    public Document getDBDocument(String string) throws piDbException {
        File file;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new piDbException(22, " Error parsing URL : " + malformedURLException.getMessage());
        }
        try {
            file = new File(this._rootPath, uRL.getFile());
        }
        catch (NullPointerException nullPointerException) {
            throw new piDbException(77, " Filename is null: " + nullPointerException.getMessage());
        }
        if (!file.exists()) {
            throw new piDbException(77, " Can not find db file: " + file.getAbsolutePath());
        }
        String string2 = file.getAbsolutePath();
        Document document = (Document)this._dbCache.get(string2 = string2.replace('\\', '/'));
        if (document != null) {
            return document;
        }
        try {
            XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder();
            try {
                document = xMLDOMBuilder.parse(string2);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(77, " Error parsing the xml file: " + xMLProcessingException.getMessage());
            }
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new piDbException(77, " Can not create DOMBuilder: " + xMLProcessingException.getMessage());
        }
        this._dbCache.put(string2, document);
        return document;
    }

    private static String buildSearchXpath(String string, String string2) {
        String string3 = new String("");
        string3 = string3.concat("*/");
        string3 = string3.concat(string2);
        string3 = string3.concat("[");
        string3 = string3.concat(string);
        string3 = string3.concat("]");
        return string3;
    }

    public static int buildResultDoc(ArrayList arrayList, int n, int n2, Vector vector, int n3, Element element) throws piDbException {
        if (n < 1) {
            throw new piDbException(0, " The index of the element to search from must be greater or equal to 1");
        }
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        ArrayList arrayList2 = new ArrayList();
        String string = new String();
        String string2 = null;
        int n4 = arrayList.size();
        if (element == null) {
            throw new piDbException(28, " The result doc hanger is null !");
        }
        if (element == null) {
            throw new piDbException(28, "searchBook: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new piDbException(28, "searchBook: resElt not attached to any doc");
        }
        for (int i = n; i <= n + n2 - 1 && i <= n4; ++i) {
            if (vector != null && !vector.isEmpty()) {
                node = ((Node)arrayList.get(i - 1)).cloneNode(false);
                string = ((Node)arrayList.get(i - 1)).getNodeName();
                for (int j = 0; j < vector.size(); ++j) {
                    try {
                        arrayList2 = XPathTools.getNodesByXPath((Node)((Node)arrayList.get(i - 1)), (String)((String)vector.get(j)));
                    }
                    catch (XSLProcessingException xSLProcessingException) {
                        throw new piDbException(0, " Impossible to retreive a node with filter: " + (String)vector.get(j) + ": " + xSLProcessingException.getMessage());
                    }
                    for (int k = 0; k < arrayList2.size(); ++k) {
                        node2 = (Node)arrayList2.get(k);
                        string2 = XMLPlugin.getXpathFromNode(node2, string);
                        if (string2 == ".") {
                            node5 = node2.cloneNode(true);
                            try {
                                node.appendChild(node5);
                                continue;
                            }
                            catch (DOMException dOMException) {
                                throw new piDbException(0, " Impossible to append node: " + dOMException.getMessage());
                            }
                        }
                        try {
                            node4 = XPathTools.getFirstNodeByXPath((Node)((Node)arrayList.get(i - 1)), (String)string2);
                        }
                        catch (XSLProcessingException xSLProcessingException) {
                            throw new piDbException(0, " Impossible to retreive a node with XPath: " + (String)vector.get(j) + ": " + xSLProcessingException.getMessage());
                        }
                        node5 = node4.cloneNode(false);
                        if (node2 != null && node5 != null) {
                            node3 = node2.cloneNode(true);
                            try {
                                node5.appendChild(node3);
                                node.appendChild(node5);
                                continue;
                            }
                            catch (DOMException dOMException) {
                                throw new piDbException(0, " Impossible to append a node: " + dOMException.getMessage());
                            }
                        }
                        throw new piDbException(0, " Error while modifying entry");
                    }
                }
                try {
                    node = _documentBuilder.copyNode(node, document);
                }
                catch (XMLProcessingException xMLProcessingException) {
                    throw new piDbException(0, " Impossible to copy a node: " + xMLProcessingException.getMessage());
                }
                try {
                    element.appendChild(node);
                    continue;
                }
                catch (DOMException dOMException) {
                    throw new piDbException(0, " Impossible to append a node: " + dOMException.getMessage());
                }
            }
            try {
                node2 = _documentBuilder.copyNode((Node)arrayList.get(i - 1), document);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(0, " Impossible to copy the node in the result tree: " + xMLProcessingException.getMessage());
            }
            try {
                element.appendChild(node2);
                continue;
            }
            catch (DOMException dOMException) {
                throw new piDbException(0, " Impossible to append the node in the result tree: " + dOMException.getMessage());
            }
        }
        int n5 = n4 < n + n2 ? n4 - n + 1 : n2;
        return n5;
    }

    private static ArrayList sortNodes(ArrayList arrayList, String string, boolean bl) throws piDbException {
        int n;
        int n2 = arrayList.size();
        Object var4_4 = null;
        Object var5_5 = null;
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray = new String[n2];
        String string2 = null;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
            try {
                string2 = XPathTools.getValueByXPath((Node)((Node)arrayList.get(n)), (String)string);
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new piDbException(0, " Impossible to retreive a node with filter: " + string + ": " + xSLProcessingException.getMessage());
            }
            stringArray[n] = string2 != null ? string2 : "";
        }
        SortUtils.quickSort(stringArray, nArray, 0, n2 - 1, bl);
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n];
            arrayList2.add(arrayList.get(n3));
        }
        return arrayList2;
    }

    private static int findLastEntryID(Node node, String string, String string2) throws piDbException {
        ArrayList arrayList;
        String string3 = null;
        String string4 = null;
        int n = 0;
        String string5 = null;
        string5 = string;
        string5 = string5.concat("/entry[@entryID='");
        string5 = string5.concat(string2);
        string5 = string5.concat("*']/@entryID");
        try {
            arrayList = XPathTools.getNodesByXPath((Node)node, (String)string5);
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new piDbException(0, " Error while processing path: " + string5 + ": " + xSLProcessingException.getMessage());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string3 = ((Node)arrayList.get(i)).getNodeValue();
            string4 = string3.substring(string3.lastIndexOf(" ") + 1, string3.length());
            int n2 = Integer.parseInt(string4);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public String addEntry(UserSession userSession, String string, Element element, int n) throws piDbException {
        Element element2;
        Element element3 = null;
        Document document = null;
        Node node = null;
        Object var8_8 = null;
        String string2 = this._rootPath;
        String string3 = null;
        if (string == null) {
            throw new piDbException(22, " No XML file passed !");
        }
        if (element == null) {
            throw new piDbException(17, " No entry to add !");
        }
        document = this.getDBDocument(string);
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        element3 = document.getDocumentElement();
        if (element3 == null) {
            throw new piDbException(22, " Couldn't get original document root node!");
        }
        try {
            node = _documentBuilder.copyNode((Node)element, document);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new piDbException(0, " Couldn't copy node: " + xMLProcessingException.getMessage());
        }
        try {
            String string4 = XPathTools.getValueByXPath((Node)node, (String)"memberofbook");
        }
        catch (Exception exception) {
            throw new piDbException(0, " Error while processing XPath: memberofbook: " + exception.getMessage());
        }
        VMID vMID = new VMID();
        string3 = vMID.toString();
        try {
            element2 = (Element)XPathTools.getFirstNodeByXPath((Node)node, (String)"entry");
        }
        catch (Exception exception) {
            throw new piDbException(0, " Error while processing XPath: entry: " + exception.getMessage());
        }
        if (element2 == null) {
            element2 = document.createElement("entry");
            try {
                element2 = (Element)node.appendChild(element2);
            }
            catch (DOMException dOMException) {
                throw new piDbException(0, " Impossible to append the node in the origin tree: " + dOMException.getMessage());
            }
        }
        try {
            element2.setAttribute("entryID", string3);
        }
        catch (DOMException dOMException) {
            throw new piDbException(0, " Couldn't set value: " + dOMException.getMessage());
        }
        try {
            element3.appendChild(node);
        }
        catch (DOMException dOMException) {
            throw new piDbException(0, " Impossible to append the node in the origin tree: " + dOMException.getMessage());
        }
        String string5 = element3.getAttribute("commit");
        if (string5 != null && string5.equals("1") || this._dumpXML) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new piDbException(77, " Error parsing URL: " + malformedURLException.getMessage());
            }
            string2 = string2.concat(uRL.getFile());
            try {
                XMLDOMBuilder.dumpNode((Node)document, (String)string2);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(77, " Couldn't dump: " + xMLProcessingException.getMessage());
            }
        }
        return string3;
    }

    public void deleteEntry(UserSession userSession, String string, String string2, int n) throws piDbException {
        Node node;
        String string3 = this._rootPath;
        String string4 = "";
        String string5 = null;
        if (string == null) {
            throw new piDbException(22, " No search file passed !");
        }
        if (string2 == null || string2.length() == 0) {
            throw new piDbException(17, " No entry to del !");
        }
        Document document = this.getDBDocument(string);
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        string4 = string4.concat("entry/@entryID");
        string4 = string4.concat("='");
        string4 = string4.concat(string2);
        string4 = string4.concat("'");
        string5 = XMLPlugin.buildSearchXpath(string4, "*");
        try {
            node = XPathTools.getFirstNodeByXPath((Node)document, (String)string5);
        }
        catch (Exception exception) {
            throw new piDbException(0, " Error while processing path: " + string5 + ": " + exception.getMessage());
        }
        if (node == null) {
            throw new piDbException(17, " Entry not found");
        }
        Element element = document.getDocumentElement();
        element.removeChild(node);
        String string6 = element.getAttribute("commit");
        if (string6 != null && string6.equals("1") || this._dumpXML) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new piDbException(77, " Error parsing URL: " + malformedURLException.getMessage());
            }
            string3 = string3.concat(uRL.getFile());
            try {
                XMLDOMBuilder.dumpNode((Node)document, (String)string3);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(77, " Couldn't dump: " + xMLProcessingException.getMessage());
            }
        }
    }

    private boolean checkIfNodeIsEmpty(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        Object var4_4 = null;
        String string = null;
        if (n == 0) {
            return true;
        }
        if (n == 1 && nodeList.item(0).getNodeType() == 3) {
            try {
                string = XPathTools.getValueByXPath((Node)node, (String)".");
            }
            catch (XSLProcessingException xSLProcessingException) {
                // empty catch block
            }
            if (string == null) {
                return true;
            }
            if (string.compareTo("") == 0) {
                return true;
            }
        }
        return false;
    }

    private void cleanTreeFromEmptyNodes(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2 = node;
        Object var5_3 = null;
        Node node3 = null;
        if (node.getNodeType() != 3 && this.checkIfNodeIsEmpty(node) && (namedNodeMap = node.getAttributes()).getLength() == 0) {
            Node node4 = node.getParentNode();
            if (node4 != null) {
                node4.removeChild(node2);
            }
            if ((node3 = node4) != null && node3.getNodeType() != 3) {
                this.cleanTreeFromEmptyNodes(node4);
            }
        }
        boolean bl = false;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.cleanTreeFromEmptyNodes(node2);
        }
    }

    private void modifyProcess(Document document, Element element, Element element2) throws piDbException {
        Vector<String> vector = new Vector<String>();
        String string = null;
        try {
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                string = node.getNodeName();
                if (vector.indexOf(string) != -1) continue;
                ArrayList arrayList = XPathTools.getNodesByXPath((Node)element2, (String)string);
                if (arrayList != null) {
                    int n;
                    ArrayList arrayList2 = XPathTools.getNodesByXPath((Node)element, (String)string);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        element.removeChild((Node)arrayList2.get(n));
                    }
                    for (n = 0; n < arrayList.size(); ++n) {
                        Node node2;
                        try {
                            node2 = _documentBuilder.copyNode((Node)arrayList.get(n), document);
                        }
                        catch (XMLProcessingException xMLProcessingException) {
                            throw new piDbException(0, " Couldn't copy node: " + xMLProcessingException.getMessage());
                        }
                        element.appendChild(node2);
                    }
                }
                vector.add(string);
            }
            this.cleanTreeFromEmptyNodes(element);
        }
        catch (Exception exception) {
            throw new piDbException(0, " Error while processing path: " + string + ":" + exception.getMessage());
        }
    }

    public void modifyEntry(UserSession userSession, String string, String string2, Element element, int n) throws piDbException {
        Element element2;
        String string3 = null;
        String string4 = "";
        String string5 = this._rootPath;
        if (string == null) {
            throw new piDbException(0, "No search file passed !");
        }
        if (string2 == null || string2.length() == 0) {
            throw new piDbException(17, " No entry to modify !");
        }
        Document document = this.getDBDocument(string);
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        string4 = string4.concat("entry/@entryID");
        string4 = string4.concat("='");
        string4 = string4.concat(string2);
        string4 = string4.concat("'");
        string3 = XMLPlugin.buildSearchXpath(string4, "*");
        try {
            element2 = (Element)XPathTools.getFirstNodeByXPath((Node)document, (String)string3);
        }
        catch (Exception exception) {
            throw new piDbException(0, " Error while processing path: " + string3 + ": " + exception.getMessage());
        }
        if (element2 == null) {
            throw new piDbException(17, " Entry not found !");
        }
        this.modifyProcess(document, element2, element);
        Element element3 = document.getDocumentElement();
        String string6 = element3.getAttribute("commit");
        if (string6 != null && string6.equals("1") || this._dumpXML) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new piDbException(77, " Error parsing URL: " + malformedURLException.getMessage());
            }
            string5 = string5.concat(uRL.getFile());
            try {
                XMLDOMBuilder.dumpNode((Node)document, (String)string5);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(77, " Couldn't dump: " + xMLProcessingException.getMessage());
            }
        }
    }

    public void openUserStore(UserSession userSession, Element element, String string, int n) throws piDbException {
        URL uRL;
        String string2 = this._rootPath;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new piDbException(77, " Error parsing URL: " + malformedURLException.getMessage());
        }
        string2 = string2.concat(uRL.getFile());
        File file = new File(string2);
        if (!file.exists()) {
            try {
                Document document = _documentBuilder.newDocument();
                Node node = _documentBuilder.copyNode((Node)element, document);
                document.appendChild(node);
                XMLDOMBuilder.dumpNode((Node)document, (String)string2);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new piDbException(77, " Couldn't dump: " + xMLProcessingException.getMessage());
            }
        }
    }

    private static String getXpathFromNode(Node node, String string) {
        String string2 = "/";
        String string3 = "";
        boolean bl = false;
        for (Node node2 = node.getParentNode(); node2 != null && node2.getNodeName() != string; node2 = node2.getParentNode()) {
            string3 = node2.getNodeName();
            string2 = string3 + "/" + string2;
        }
        if (string2.lastIndexOf("/") != -1) {
            string2 = string2.substring(0, string2.lastIndexOf("/"));
        }
        string2 = string2.length() == 0 ? "." : string2.substring(0, string2.length() - 1);
        return string2;
    }

    public int getEntriesCount(String string) throws piDbException {
        Document document = null;
        String string2 = "";
        String string3 = "";
        ArrayList arrayList = new ArrayList();
        string2 = string2.concat("entry/@entryID");
        string2 = string2.concat("='");
        string2 = string2.concat("*");
        string2 = string2.concat("'");
        string3 = XMLPlugin.buildSearchXpath(string2, "*");
        if (string == null) {
            throw new piDbException(0, "No search base !");
        }
        document = this.getDBDocument(string);
        if (document == null) {
            throw new piDbException(22, " Can't find DB for " + string);
        }
        try {
            arrayList = XPathTools.getNodesByXPath((Node)document, (String)string3);
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new piDbException(77, "Error while searching in" + string + " " + xSLProcessingException.getMessage());
        }
        if (arrayList != null) {
            return arrayList.size();
        }
        return 0;
    }

    public int getEntriesLimit() {
        return 1;
    }

    public void syncStore(UserSession userSession, Element element, String string) throws piDbException {
    }
}

