/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.wabpc;

import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.iabs.wabpc.WABPClientPStore;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import java.io.File;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WABPPersonalStore
extends WABPClientPStore
implements PersonalStore {
    private static XMLDOMBuilder _domBuilder = null;
    private WABPClientPStore _wabpClient = null;
    private File _configPath;

    public WABPPersonalStore(String serverURL) throws PStoreException {
        super(serverURL);
    }

    public void init(File configPath) {
        this._configPath = configPath;
    }

    public void searchBook(String bookEntryID, String filter, Vector retFields, Vector entryType, String sortBy, Element resElt) throws PStoreException {
        Element soapSearchElt;
        String[] sRetFields = null;
        if (retFields != null) {
            sRetFields = retFields.toArray(new String[0]);
        }
        String[] sEntryType = null;
        if (entryType != null) {
            sEntryType = entryType.toArray(new String[0]);
        }
        if ((soapSearchElt = super.search(bookEntryID, filter, sRetFields, sEntryType, sortBy)) == null) {
            return;
        }
        Document resultTree = resElt.getOwnerDocument();
        Object tmpElt = null;
        try {
            _domBuilder.copyChildren((Node)soapSearchElt, (Node)resElt);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/searchBook: failed to copy element:" + e.getMessage());
        }
        try {
            _domBuilder.copyAttributes(soapSearchElt, resElt);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/searchBook: failed to copy attributes:" + e.getMessage());
        }
    }

    public String searchBook(String bookEntryID, String filter, Vector retFields, Vector entryType, String sortBy, int entriesPerPage) throws PStoreException {
        String res = null;
        String[] sRetFields = null;
        if (retFields != null) {
            sRetFields = retFields.toArray(new String[0]);
        }
        String[] sEntryType = null;
        if (entryType != null) {
            sEntryType = entryType.toArray(new String[0]);
        }
        res = super.pagedSearch(bookEntryID, filter, sRetFields, sEntryType, sortBy, entriesPerPage);
        return res;
    }

    public void getResult(String searchID, int firstEntry, Element resElt) throws PStoreException {
        Element soapSearchElt = super.getPagedSearchResult(searchID, firstEntry);
        if (soapSearchElt == null) {
            return;
        }
        Document resultTree = resElt.getOwnerDocument();
        try {
            _domBuilder.copyChildren((Node)soapSearchElt, (Node)resElt);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/getResult: failed to copy element:" + e.getMessage());
        }
        try {
            _domBuilder.copyAttributes(soapSearchElt, resElt);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/searchBook: failed to copy attributes:" + e.getMessage());
        }
    }

    public void stopSearch(String searchID) throws PStoreException {
        super.stopPagedSearch(searchID);
    }

    public Entry getEntry(String bookEntryID, String entryID, Element resElt) throws PStoreException {
        Entry soapEntry = super.getEntry(bookEntryID, entryID);
        if (soapEntry == null) {
            return null;
        }
        Element soapEntryElt = soapEntry.getEntryElement();
        if (soapEntryElt == null) {
            return null;
        }
        Document resultTree = resElt.getOwnerDocument();
        Element newEntryElt = null;
        try {
            newEntryElt = (Element)_domBuilder.copyNode((Node)soapEntryElt, resultTree);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/getEntry: failed to create element:" + e.getMessage());
        }
        resElt.appendChild(newEntryElt);
        Entry entry = new Entry(newEntryElt);
        return entry;
    }

    public Entry getEntry(String entryID, Element resElt) throws PStoreException {
        Entry soapEntry = super.getEntry(entryID);
        if (soapEntry == null) {
            return null;
        }
        Element soapEntryElt = soapEntry.getEntryElement();
        if (soapEntryElt == null) {
            return null;
        }
        Document resultTree = resElt.getOwnerDocument();
        Element newEntryElt = null;
        try {
            newEntryElt = (Element)_domBuilder.copyNode((Node)soapEntryElt, resultTree);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/getEntry: failed to create element:" + e.getMessage());
        }
        resElt.appendChild(newEntryElt);
        Entry entry = new Entry(newEntryElt);
        return entry;
    }

    public void expandGroup(String bookEntryID, String entryID, Vector entryType, String sortBy, String noExpandOnXPath, Element resElt) throws PStoreException {
        Element dummyElement = null;
        String[] sEntryType = null;
        if (entryType != null) {
            sEntryType = entryType.toArray(new String[0]);
        }
        if ((dummyElement = super.expandGroup(bookEntryID, entryID, sEntryType, sortBy, noExpandOnXPath)) == null) {
            return;
        }
        Document resultTree = resElt.getOwnerDocument();
        Object tmpElt = null;
        try {
            _domBuilder.copyChildren((Node)dummyElement, (Node)resElt);
        }
        catch (XMLProcessingException e) {
            throw new PStoreException(20, "soap/expandGroup: failed to create element:" + e.getMessage());
        }
    }

    public void expandGroups(Element parentElement, Vector entryType, String sortBy, String noExpandOnXPath) throws PStoreException {
    }

    public void disconnect() throws PStoreException {
        super.disconnect();
    }

    public String addProfile(Element elt) throws PStoreException {
        return null;
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xpe) {
            Logging.error((int)32, (String)("Couldn't create XMLDOMBuilder: " + xpe.getMessage()));
        }
    }
}

