/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.wabp;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WABPEngine {
    private static final String WABPTAG = "wabp";
    private static final String DEFAULT_BOOKTYPE = "abook";
    private static final String BOOKLIST = "booklist";
    private static final int DEBUG = 0;
    private static final String DEFAULT_IMPORTEXPORT_FORMAT = "ldif";
    private static final String LOGOUT_URL = "/base/UWCMain?op=logout&gotoUri=/wabp/logout.wabp";
    private File _configPath;
    private XSLXMLLogHandler _logHandler = null;
    private XMLDOMBuilder _xmlBuilder = null;

    public WABPEngine(File configPath, XSLXMLLogHandler logHandler) throws IOException {
        this._logHandler = logHandler;
        this._configPath = configPath;
        try {
            this._xmlBuilder = new XMLDOMBuilder(this._logHandler);
        }
        catch (XMLProcessingException xpe) {
            throw new IOException("WABPEngine.process: Couldn't create XMLDOMBuilder: " + xpe.getMessage());
        }
    }

    public void process(HttpServletRequest request, HttpServletResponse response, String cmdPage) throws IOException {
        boolean isError = false;
        String errorCode = String.valueOf(0);
        String errorMsg = new String();
        Document wabpDoc = this._xmlBuilder.newDocument();
        Element wabpElt = null;
        try {
            wabpElt = wabpDoc.createElement(WABPTAG);
        }
        catch (DOMException e) {
            Logging.error((int)128, (String)("WABPEngine.process: Could not create WabpRootElt: " + e.getMessage()));
            return;
        }
        if (!cmdPage.endsWith(".wabp")) {
            int separator = cmdPage.lastIndexOf(".");
            cmdPage = separator > 0 ? cmdPage.substring(0, separator) + ".wabp" : cmdPage + ".wabp";
        }
        String validClientIP = (String)request.getAttribute("validClientIP");
        try {
            String entryID;
            String entryid;
            Element resultElt;
            if (validClientIP != null && validClientIP.equals("false")) {
                throw new Exception("Client IP conflict.");
            }
            HttpSession session = request.getSession(false);
            if (cmdPage.equals("login.wabp")) {
                UserSession userSession = null;
                if (session != null) {
                    userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
                }
                if (userSession == null) {
                    errorCode = "1";
                    errorMsg = "Authentication failed!!";
                } else {
                    String encodedURL = response.encodeURL("/").substring(1);
                    if (encodedURL == null || encodedURL.equals("")) {
                        encodedURL = ";jsessionid=" + request.getSession(false).getId();
                    }
                    wabpElt.setAttribute("sessionstring", encodedURL);
                }
            }
            if (cmdPage.equals("logout.wabp") && session != null) {
                RequestDispatcher reqDisp = request.getRequestDispatcher(LOGOUT_URL);
                reqDisp.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (cmdPage.equals("list_books.wabp")) {
                try {
                    resultElt = this.list_books(request);
                    if (resultElt != null) {
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("search_entry.wabp")) {
                try {
                    String entriesPerPage = request.getParameter("entriesperpage");
                    if (entriesPerPage == null || entriesPerPage.length() == 0) {
                        Element resultElt2 = this.search_entry(request);
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt2, wabpDoc));
                    } else {
                        String searchID = this.search_entry(request, entriesPerPage);
                        wabpElt.setAttribute("searchid", searchID);
                    }
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("getresult.wabp")) {
                try {
                    resultElt = this.getresult(request);
                    wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("create_entry.wabp")) {
                try {
                    entryid = new String();
                    entryid = this.create_entry(request);
                    wabpElt.setAttribute("entryID", entryid);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("create_book.wabp")) {
                entryid = new String();
                try {
                    entryid = this.create_book(request);
                    wabpElt.setAttribute("entryID", entryid);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("get_entry.wabp")) {
                try {
                    resultElt = this.get_entry(request);
                    wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("delete_book.wabp")) {
                try {
                    this.delete_book(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("delete_entry.wabp")) {
                try {
                    this.delete_entry(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("modify_entry.wabp")) {
                try {
                    entryID = this.modify_entry(request);
                    wabpElt.setAttribute("entryid", entryID);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("modify_book.wabp")) {
                try {
                    entryID = this.modify_book(request);
                    wabpElt.setAttribute("entryid", entryID);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("add_bookmember.wabp")) {
                try {
                    this.add_bookmember(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("add_groupmember.wabp")) {
                try {
                    this.add_groupmember(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("remove_bookmember.wabp")) {
                try {
                    this.remove_bookmember(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("remove_groupmember.wabp")) {
                try {
                    this.remove_groupmember(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("import.wabp")) {
                try {
                    Logging.trace((int)128, (String)"in import.wabp");
                    resultElt = this.import_entry(request);
                    wabpElt = (Element)this._xmlBuilder.copyNode((Node)resultElt, wabpDoc);
                    wabpDoc.appendChild(wabpElt);
                    Logging.trace((int)128, (String)"in import.wabp after append child");
                    this.writeOutToResponse(request, response, wabpDoc, cmdPage);
                    Logging.trace((int)128, (String)"after writing response");
                    return;
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                    Logging.error((int)128, (String)("WABPEngine: " + errorMsg + " " + errorCode));
                }
            }
            if (cmdPage.equals("export.wabp")) {
                try {
                    this.export_abook(request, response);
                    return;
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("get_book.wabp")) {
                try {
                    resultElt = this.get_book(request);
                    if (resultElt != null) {
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("get_defaultbook.wabp")) {
                try {
                    resultElt = this.get_defaultbook(request);
                    if (resultElt != null) {
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("get_profile.wabp")) {
                try {
                    resultElt = this.get_profile(request);
                    if (resultElt != null) {
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("modify_profile.wabp")) {
                try {
                    this.modify_profile(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
            if (cmdPage.equals("stopsearch.wabp")) {
                try {
                    this.StopSearch(request);
                }
                catch (PStoreException pse) {
                    isError = true;
                    errorCode = Integer.toString(pse.getReason());
                    errorMsg = pse.getMessage();
                }
            }
        }
        catch (Exception e) {
            Logging.error((int)128, (String)("WABPEngine: " + e.getMessage()));
            isError = true;
            if (validClientIP != null && validClientIP.equals("false")) {
                errorCode = "66";
                errorMsg = "Client IP conflict";
            }
            errorCode = "0";
            errorMsg = "Server can't anwser the query. Try Later.";
        }
        wabpDoc.appendChild(wabpElt);
        if (!isError) {
            wabpElt.setAttribute("errorcode", errorCode);
        } else {
            try {
                wabpElt.setAttribute("errorcode", errorCode);
                wabpElt.setAttribute("rawmsg", errorMsg);
            }
            catch (DOMException e) {
                Logging.error((int)128, (String)("WABPEngine.process: Could not create WabpErrorElt: " + e.getMessage()));
                return;
            }
        }
        try {
            this.writeOutToResponse(request, response, wabpDoc, cmdPage);
        }
        catch (IOException e) {
            Logging.error((int)128, (String)"WABPEngine: problem writing to response");
        }
    }

    public Element list_books(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        PersonalStore pStore = this.loadPS(request);
        String booktype = request.getParameter("booktype");
        if (booktype == null) {
            booktype = DEFAULT_BOOKTYPE;
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/list_books: failed to create document");
        }
        Element dummyElement = null;
        try {
            dummyElement = dummyDoc.createElement(BOOKLIST);
            dummyDoc.appendChild(dummyElement);
        }
        catch (DOMException e) {
            throw new PStoreException(20, "wabp/list_books: failed to create element" + e.getMessage());
        }
        Book[] bookArray = pStore.listBooks(booktype);
        if (bookArray == null) {
            return null;
        }
        try {
            Book currentBook = null;
            Node childNode = null;
            for (int i = 0; i < bookArray.length; ++i) {
                currentBook = bookArray[i];
                childNode = this._xmlBuilder.copyNode((Node)currentBook.getEntryElement(), dummyDoc);
                dummyElement.appendChild(childNode);
            }
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(20, "wabp/list_books: failed to add child element" + xpe.getMessage());
        }
        return dummyElement;
    }

    public Element search_entry(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        String sortBy;
        String filter;
        PersonalStore pStore = this.loadPS(request);
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            String bookType = request.getParameter("booktype");
            if (bookType == null || bookType.length() <= 0) {
                bookType = DEFAULT_BOOKTYPE;
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                throw new PStoreException(20, "PagedSearchResultHdler.expand : couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
            }
            if (defaultBook == null) {
                throw new PStoreException(20, "PagedSearchResultHandler.expand: no default book");
            }
            bookId = defaultBook.getEntryID();
        }
        if ((filter = request.getParameter("filter")) == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        if ((sortBy = request.getParameter("sortby")) == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = request.getParameter("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/search_entry: failed to create document");
        }
        Vector<String> returnattrs = null;
        String attrList = request.getParameter("attrlist");
        if (attrList != null && attrList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            returnattrs = new Vector<String>();
            while ((newIndex = attrList.indexOf(",", index)) != -1) {
                returnattrs.add(attrList.substring(index, newIndex));
                index = newIndex + 1;
            }
            returnattrs.add(attrList.substring(index));
        }
        Element searchResult = dummyDoc.createElement("searchresult");
        dummyDoc.appendChild(searchResult);
        searchResult.setAttribute("bookid", bookId);
        searchResult.setAttribute("filter", filter);
        searchResult.setAttribute("sortby", sortBy);
        pStore.searchBook(bookId, filter, returnattrs, entryType, sortBy, searchResult);
        return searchResult;
    }

    public Element get_defaultbook(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String bookType = request.getParameter("booktype");
        Book result = null;
        result = pStore.getDefaultBook(bookType);
        if (result == null) {
            return null;
        }
        return result.getEntryElement();
    }

    public Element get_book(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        Book result = null;
        result = pStore.getBook(Bookid);
        if (result == null) {
            this._logHandler.error("WABPEngine.get_book: Couldn't retreive Book.");
            return null;
        }
        return result.getEntryElement();
    }

    public Element get_profile(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_profile: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_profile: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String profilename = null;
        profilename = request.getParameter("name");
        Element result = null;
        result = pStore.getProfile(profilename);
        return result;
    }

    public void modify_profile(HttpServletRequest request) throws PStoreException {
        String profilename = request.getParameter("name");
        if (profilename == null) {
            throw new PStoreException(20, "wabp/modify_profile: profilename is missing");
        }
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        InputStream in = multiRequest.getFileParameter("file");
        if (in == null) {
            this._logHandler.error("WABPEngine.modify_profile: null file");
            throw new PStoreException(6, "WABPEngine.modify_profile: no xml data");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.modify_profile: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.modify_profile: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            Document EntryDoc = this._xmlBuilder.parse(in, true);
            Element Entryroot = EntryDoc.getDocumentElement();
            pStore.modifyProfile(profilename, Entryroot);
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(20, "wabp/modify_profile: failed to add child element" + xpe.getMessage());
        }
    }

    public Element import_entry(HttpServletRequest request) throws PStoreException {
        String importFormat;
        try {
            Logging.error((int)128, (String)("Encoding:" + request.getCharacterEncoding()));
            request.setCharacterEncoding("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            Logging.error((int)128, (String)("In import_entry: " + e.getMessage()));
        }
        String bookID = request.getParameter("bookid");
        PersonalStore pStore = this.loadPS(request);
        if (bookID == null || bookID.length() == 0) {
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(DEFAULT_BOOKTYPE);
            }
            catch (PStoreException pse) {
                throw new PStoreException(pse.getReason(), "wabp/import_entry : " + pse.getDetails());
            }
            if (defaultBook == null) {
                throw new PStoreException(2, "wabp/import_entry: no default book");
            }
            bookID = defaultBook.getEntryID();
        }
        if ((importFormat = request.getParameter("format")) == null || importFormat.length() == 0) {
            importFormat = DEFAULT_IMPORTEXPORT_FORMAT;
        }
        String data = request.getParameter("file");
        InputStream inStream = null;
        try {
            if (data != null) {
                inStream = new ByteArrayInputStream(data.getBytes());
            } else {
                MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
                inStream = mRequest.getFileParameter("file");
            }
        }
        catch (Exception e) {
            throw new PStoreException(3, "wabp/import_entry: error in getting XML file");
        }
        if (inStream == null) {
            throw new PStoreException(3, "wabp/import_entry: empty input");
        }
        Document dummyDoc = this._xmlBuilder.newDocument();
        if (dummyDoc == null) {
            throw new PStoreException(9, "wabp/getresult: failed to create document");
        }
        Element importElt = dummyDoc.createElement(WABPTAG);
        try {
            pStore.importEntry(bookID, importFormat, inStream, importElt);
        }
        catch (PStoreException pse) {
            throw new PStoreException(pse.getReason(), "wabp/import_entry: " + pse.getMessage());
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/import_entry: " + e.getMessage());
        }
        return importElt;
    }

    public void export_abook(HttpServletRequest request, HttpServletResponse response) throws PStoreException {
        String language;
        String format;
        HttpSession session = request.getSession(false);
        ServletOutputStream out = null;
        if (session == null) {
            this._logHandler.error("WABPEngine.create_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.create_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            throw new PStoreException(20, "bookid is null");
        }
        String filter = request.getParameter("filter");
        if (filter == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        if ((format = request.getParameter("format")) == null || format.length() == 0) {
            format = new String(DEFAULT_IMPORTEXPORT_FORMAT);
        }
        if ((language = request.getParameter("lang")) == null) {
            language = "us";
        }
        String extension = format.startsWith("csv") ? ".csv" : (format.startsWith("vcard") ? ".vcf" : ".ldif");
        String filename = "export" + extension;
        String contentType = new String("application/") + format;
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", "inline;filename=\"" + filename + "\"");
        try {
            out = response.getOutputStream();
            pStore.exportEntry(bookId, filter, format, language, (OutputStream)out);
            out.close();
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "io exception");
        }
    }

    public String search_entry(HttpServletRequest request, String entriesperpage) throws PStoreException {
        String sortBy;
        String filter;
        PersonalStore pStore = this.loadPS(request);
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            String bookType = request.getParameter("booktype");
            if (bookType == null || bookType.length() <= 0) {
                bookType = DEFAULT_BOOKTYPE;
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                throw new PStoreException(20, "wabp/search_entry(entriesperpage) : couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
            }
            if (defaultBook == null) {
                throw new PStoreException(20, "wabp/search_entry(entriesperpage): no default book");
            }
            bookId = defaultBook.getEntryID();
        }
        if ((filter = request.getParameter("filter")) == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        if ((sortBy = request.getParameter("sortby")) == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = request.getParameter("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        Vector<String> returnattrs = null;
        String attrList = request.getParameter("attrlist");
        if (attrList != null && attrList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            returnattrs = new Vector<String>();
            while ((newIndex = attrList.indexOf(",", index)) != -1) {
                returnattrs.add(attrList.substring(index, newIndex));
                index = newIndex + 1;
            }
            returnattrs.add(attrList.substring(index));
        }
        String searchID = null;
        int intEntriesPerPage = Integer.parseInt(entriesperpage);
        searchID = pStore.searchBook(bookId, filter, returnattrs, entryType, sortBy, intEntriesPerPage);
        return searchID;
    }

    public Element getresult(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        String searchID = request.getParameter("searchid");
        if (searchID == null || searchID.length() == 0) {
            throw new PStoreException(20, "wabp/getresult: No searchID");
        }
        PersonalStore pStore = this.loadPS(request);
        String firstEntry = request.getParameter("firstentry");
        if (firstEntry == null || firstEntry.length() == 0) {
            firstEntry = "1";
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/getresult: failed to create document");
        }
        Element searchResult = dummyDoc.createElement("searchresult");
        dummyDoc.appendChild(searchResult);
        pStore.getResult(searchID, Integer.parseInt(firstEntry), searchResult);
        String stopSearch = request.getParameter("stopsearch");
        if (stopSearch != null && stopSearch.equals("1")) {
            pStore.stopSearch(searchID);
        }
        return searchResult;
    }

    public void StopSearch(HttpServletRequest request) throws PStoreException {
        String searchID = request.getParameter("searchid");
        if (searchID == null || searchID.length() == 0) {
            throw new PStoreException(20, "wabp/getresult: No searchID");
        }
        PersonalStore pStore = this.loadPS(request);
        pStore.stopSearch(searchID);
    }

    public String create_entry(HttpServletRequest request) throws PStoreException {
        Element Entryroot;
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        InputStream in = multiRequest.getFileParameter("file");
        if (in == null) {
            this._logHandler.error("WABPEngine.create_entry: null file");
            throw new PStoreException(6, "WABPEngine.create_entry: no xml data");
        }
        String bookIDString = request.getParameter("bookid");
        String[] bookIDs = StringUtils.stringToStringArray((String)bookIDString);
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.create_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.create_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            Document EntryDoc = this._xmlBuilder.parse(in, true);
            Entryroot = EntryDoc.getDocumentElement();
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(20, "wabp/create_entry: failed to add child element" + xpe.getMessage());
        }
        String entryId = pStore.addEntry(bookIDs, Entryroot);
        return entryId;
    }

    public String create_book(HttpServletRequest request) throws PStoreException {
        Element Entryroot;
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        InputStream in = multiRequest.getFileParameter("file");
        if (in == null) {
            this._logHandler.error("WABPEngine.create_book: null file");
            throw new PStoreException(6, "WABPEngine.create_book: no xml data");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.create_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.create_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            Document EntryDoc = this._xmlBuilder.parse(in, true);
            Entryroot = EntryDoc.getDocumentElement();
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(20, "wabp/create_book: failed to add child element" + xpe.getMessage());
        }
        String EntryId = pStore.addBook(Entryroot);
        return EntryId;
    }

    public void delete_book(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_book: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_book: no bookEntryID");
        }
        pStore.deleteBook(Bookid);
    }

    public void delete_entry(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_entry: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_entry: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_entry: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_entry: no EntryID");
        }
        pStore.deleteEntry(Bookid, Entryid);
    }

    public Element get_entry(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        String Entryid = request.getParameter("entryid");
        Entry result = null;
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.get_entry: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.get_entry: no EntryID");
        }
        result = Bookid == null ? pStore.getEntry(Entryid) : pStore.getEntry(Bookid, Entryid);
        if (result == null) {
            this._logHandler.error("WABPEngine.get_entry: Couldn't retreive Entry.");
            throw new PStoreException(6, "WABPEngine.get_entry: Couldn't retreive Entry");
        }
        return result.getEntryElement();
    }

    public void add_bookmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.add_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_bookmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_member: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_bookmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_bookmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_bookmember: no EntryID");
        }
        if (session == null) {
            this._logHandler.error("WABPEngine.add_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_bookmember: Couldn't retreive session");
        }
        pStore.addBookMember(Bookid, Entryid);
    }

    public void add_groupmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.add_groupmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_groupmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no EntryID");
        }
        String Groupid = request.getParameter("groupid");
        if (Groupid == null || Groupid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Groupid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no groupID");
        }
        pStore.addGroupMember(Bookid, Groupid, Entryid);
    }

    public void remove_bookmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.remove_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.remove_bookmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_bookmember: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_bookmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_bookmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_bookmember: no EntryID");
        }
        pStore.removeBookMember(Bookid, Entryid);
    }

    public void remove_groupmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.remove_groupmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.remove_member: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no EntryID");
        }
        String Groupid = request.getParameter("groupid");
        if (Groupid == null || Groupid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Groupid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no GroupID");
        }
        pStore.removeGroupMember(Bookid, Groupid, Entryid);
    }

    public String modify_entry(HttpServletRequest request) throws PStoreException {
        String bookID = request.getParameter("bookid");
        String entryID = request.getParameter("entryid");
        if (entryID == null) {
            throw new PStoreException(20, "wabp/modify_entry: entryID is missing");
        }
        String data = request.getParameter("file");
        InputStream inStream = null;
        if (data != null) {
            inStream = new ByteArrayInputStream(data.getBytes());
        } else {
            try {
                MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
                inStream = mRequest.getFileParameter("file");
            }
            catch (Exception e) {
                throw new PStoreException(20, "wabp/modify_entry: error in getting XML file");
            }
        }
        if (inStream == null) {
            throw new PStoreException(20, "wabp/modify_entry: empty XML input");
        }
        PersonalStore pStore = this.loadPS(request);
        Document dummyDoc = null;
        try {
            dummyDoc = this._xmlBuilder.parse(inStream, true);
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_entry: " + e.getMessage());
        }
        Element modifyElt = dummyDoc.getDocumentElement();
        if (bookID == null) {
            pStore.modifyEntry(entryID, modifyElt);
        } else {
            pStore.modifyEntry(bookID, entryID, modifyElt);
        }
        return entryID;
    }

    public String modify_book(HttpServletRequest request) throws PStoreException {
        String entryID = request.getParameter("entryid");
        if (entryID == null) {
            throw new PStoreException(20, "wabp/modify_entry: entryID is missing");
        }
        String data = request.getParameter("file");
        InputStream inStream = null;
        if (data != null) {
            inStream = new ByteArrayInputStream(data.getBytes());
        } else {
            try {
                MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
                inStream = mRequest.getFileParameter("file");
            }
            catch (Exception e) {
                throw new PStoreException(20, "wabp/modify_entry: error in getting XML file");
            }
        }
        if (inStream == null) {
            throw new PStoreException(20, "wabp/modify_entry: empty XML input");
        }
        PersonalStore pStore = this.loadPS(request);
        Document dummyDoc = null;
        try {
            dummyDoc = this._xmlBuilder.parse(inStream, true);
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_entry: " + e.getMessage());
        }
        Element modifyElt = dummyDoc.getDocumentElement();
        pStore.modifyBook(entryID, modifyElt);
        return entryID;
    }

    private PersonalStore loadPS(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession == null) {
            throw new PStoreException(20, "wabp: Null UserSesion - login failed");
        }
        return (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
    }

    private void writeOutToResponse(HttpServletRequest request, HttpServletResponse response, Document wabpDoc, String cmdPage) throws IOException {
        String fmtOut = request.getParameter("fmt-out");
        String contentType = "text/xml";
        if (fmtOut != null && fmtOut.length() > 0) {
            contentType = fmtOut;
        }
        if (!contentType.equalsIgnoreCase("js")) {
            String contentTypeString = contentType + ";" + "charset" + "=UTF-8";
            response.setContentType(contentTypeString);
            ServletOutputStream out = response.getOutputStream();
            try {
                XMLDOMBuilder.dumpNode((Node)wabpDoc, (OutputStream)out);
            }
            catch (Exception e) {
                throw new IOException("WABPEngine.process: Error outputing XML: " + e.getMessage());
            }
            finally {
                out.close();
            }
        } else {
            this.setJSOutput(request, response, wabpDoc, cmdPage);
        }
    }

    private void setJSOutput(HttpServletRequest request, HttpServletResponse response, Document wabpDoc, String cmdPage) throws IOException {
        String contentType = "text/html;charset=UTF-8";
        Logging.trace((int)128, (String)"In setJSOutput");
        response.setContentType(contentType);
        ServletOutputStream out = response.getOutputStream();
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return;
        }
        out.println("<html> <body> <script>");
        if (userAgent.indexOf("MSIE") == -1) {
            out.println("document.domain = document.domain");
        }
        Element wabpElt = wabpDoc.getDocumentElement();
        out.println("var errno='" + wabpElt.getAttribute("errorcode") + "'");
        out.println("var errmsg='" + wabpElt.getAttribute("rawmsg") + "'");
        NamedNodeMap attrList = wabpElt.getAttributes();
        int len = attrList.getLength();
        for (int i = 0; i < len; ++i) {
            Node attr = attrList.item(i);
            out.println("var " + attr.getNodeName() + "='" + attr.getNodeValue() + "'");
        }
        out.println("parent." + cmdPage.substring(0, cmdPage.indexOf(46)) + "CB();");
        out.println("</script> </body> </html>");
        Logging.trace((int)128, (String)"SetJSOutput done");
    }
}

