/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateMembershipFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("UpdateMembershipFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("UpdateMembershipFormHandler.Process: null Error Doc");
            return false;
        }
        String[] sPrefix = request.getParameterValues("prefix");
        String sSelectedBookID = request.getParameter("selectedbookid");
        String[] sEntryID = request.getParameterValues("entryid");
        if (sPrefix == null || sPrefix.length == 0) {
            this._logHandler.error("UpdateMembership.Process : sPrefix is invalid: " + sPrefix);
            return false;
        }
        if (sSelectedBookID == null || sSelectedBookID.length() == 0) {
            this._logHandler.error("UpdateMembershipFormHandler.Process : No Selected BookID's");
            return false;
        }
        if (sEntryID == null || sEntryID.length == 0) {
            this._logHandler.error("UpdateMembershipFormHandler.Process : sEntryID is invalid: " + sEntryID);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("UpdateMembershipFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("UpdateMembershipFormHandler.process: null pStore");
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(sSelectedBookID, ",");
        ArrayList<String> sSelectedBookArray = new ArrayList<String>();
        int j = 0;
        while (tokens.hasMoreTokens()) {
            sSelectedBookArray.add(tokens.nextToken());
            ++j;
        }
        for (int i = 0; i < sPrefix.length; ++i) {
            if (sPrefix[i] != null && !sPrefix[i].equals("")) {
                try {
                    int sInd;
                    String bookIDParam = sPrefix[i] + "bookid";
                    String[] sBookID = request.getParameterValues(bookIDParam);
                    if (sBookID == null || sBookID.length == 0) {
                        this._logHandler.error("UpdateMembership:Process: Current BookID list is null");
                        return false;
                    }
                    for (sInd = 0; sInd < sSelectedBookArray.size(); ++sInd) {
                        String tBookID = (String)sSelectedBookArray.get(sInd);
                        for (int jInd = 0; jInd < sBookID.length; ++jInd) {
                            if (tBookID.equals(sBookID[jInd])) continue;
                            pStore.addBookMember(tBookID, sEntryID[i]);
                        }
                    }
                    for (sInd = 0; sInd < sBookID.length; ++sInd) {
                        for (int jInd = 0; jInd < sSelectedBookArray.size(); ++jInd) {
                            String tBookID = (String)sSelectedBookArray.get(jInd);
                            if (sBookID[sInd].equals(tBookID)) continue;
                            pStore.removeBookMember(sBookID[sInd], sEntryID[i]);
                        }
                    }
                    continue;
                }
                catch (PStoreException pse) {
                    this._logHandler.error("UpdateMembershipFormHandler.Process : Can not update entry : " + pse.getMessage());
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "265");
                    errorElt.setAttribute("rawmsg", "UpdateMembershipFormHandler.Process: Can not update group: " + pse.getMessage());
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
            }
            this._logHandler.error("UpdateMembershipFormHandler.Process: Incorrect value for prefix : " + sPrefix);
            return false;
        }
        return true;
    }
}

