/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String sortBy;
        String filter;
        String currentBookID;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ExportHandler.expand: null session");
            xmlElt.setAttribute("error", "null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("ExportHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("ExportHandler.expand: null XML Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("SearchHandler.expand: null pStore");
            xmlElt.setAttribute("error", "null pStore");
            return;
        }
        String bookType = request.getParameter("booktype");
        if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
            bookType = "abook";
        }
        if ((currentBookID = request.getParameter("bookid")) == null || currentBookID.length() == 0) {
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("SearchHandler.expand: couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
                xmlElt.setAttribute("error", "Error " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("SearchHandler.expand: no default book");
                xmlElt.setAttribute("error", "no default book");
                return;
            }
            currentBookID = defaultBook.getEntryID();
        }
        if (!((filter = request.getParameter("filter")) != null && filter.length() != 0 || (filter = xmlElt.getAttribute("filter")) != null && filter.length() != 0)) {
            filter = "entry/displayname=*";
        }
        if (!((sortBy = request.getParameter("sortby")) != null && sortBy.length() != 0 || (sortBy = xmlElt.getAttribute("sortby")) != null && sortBy.length() != 0)) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = xmlElt.getAttribute("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        Element searchResult = null;
        try {
            searchResult = xmlDoc.createElement("searchresult");
            xmlElt.appendChild(searchResult);
        }
        catch (DOMException de) {
            this._logHandler.error("ExportHandler.expand: searchresult creation returned : " + de.getMessage());
            xmlElt.setAttribute("error", "Error : " + de.getMessage());
            return;
        }
        if (searchResult == null) {
            this._logHandler.error("ExportHandler.expand: searchResult is null after creation");
            xmlElt.setAttribute("error", "Error: searchResult is null after creation");
            return;
        }
        try {
            pStore.searchBook(currentBookID, filter, null, entryType, sortBy, searchResult);
        }
        catch (PStoreException pe) {
            this._logHandler.error("SearchHandler.expand: searchBook returned: " + pe.getReason() + " : " + pe.getMessage());
            xmlElt.setAttribute("error", "Error " + pe.getReason() + ": " + pe.getMessage());
            return;
        }
    }
}

