/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.coresrv.CorePersonalStore;
import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PagedSearchHandler
extends ElementHandler {
    private static final transient String ENTRIES_PER_PAGE_XPATH = "xmlprofile/layoutinfo/@entriesperpage";

    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String filter;
        String currentBookID;
        String bookType;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("PagedSearchResultHandler.expand : null session");
            xmlElt.setAttribute("error", "null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("PagedSearchResultHandler.expand: null XML Element");
            return;
        }
        if (errorRootElt == null) {
            this._logHandler.error("PagedSearchResultHandler.expand: null Error Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("PagedSearchResultHandler.expand: null XML Doc");
            return;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("PagedSearchResultHandler.expand: null Error Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("PagedSearchResultHandler.expand : null pStore");
            xmlElt.setAttribute("error", "null pStore");
            return;
        }
        int quotawarn = 0;
        String freshLogin = (String)session.getAttribute("com.iplanet.xslui.ui.freshlogin");
        if (freshLogin != null && freshLogin.equals("true")) {
            quotawarn = ((CorePersonalStore)pStore).getQuotaWarning();
        }
        String searchID = request.getParameter("searchid");
        String stopSearch = request.getParameter("stopsearch");
        if (searchID == null) {
            searchID = (String)session.getAttribute("searchid");
        }
        if (stopSearch != null && stopSearch.equals("1")) {
            try {
                pStore.stopSearch(searchID);
            }
            catch (PStoreException pe) {
                this._logHandler.error("PagedSearchResultHdler.expand: couldn't stop search: " + pe.getReason() + " : " + pe.getMessage());
            }
            searchID = null;
            session.removeAttribute("searchid");
        }
        if (!((bookType = request.getParameter("booktype")) != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
            bookType = "abook";
        }
        if ((currentBookID = request.getParameter("bookid")) == null || currentBookID.length() == 0) {
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("PagedSearchResultHdler.expand : couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
                xmlElt.setAttribute("error", "Error " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("PagedSearchResultHandler.expand: no default book");
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "258");
                errorRootElt.appendChild(errorElt);
                return;
            }
            currentBookID = defaultBook.getEntryID();
        }
        if (!((filter = request.getParameter("filter")) != null && filter.length() != 0 || (filter = xmlElt.getAttribute("filter")) != null && filter.length() != 0)) {
            filter = "entry/displayname=*";
        }
        String decodedFilter = filter;
        try {
            decodedFilter = URLDecoder.decode(filter, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            // empty catch block
        }
        String sortBy = request.getParameter("sortby");
        if (!(sortBy != null && sortBy.length() != 0 || (sortBy = xmlElt.getAttribute("sortby")) != null && sortBy.length() != 0)) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = request.getParameter("type");
        if (typeList == null) {
            typeList = xmlElt.getAttribute("type");
        }
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        int entriesPerPage = 0;
        String field = request.getParameter("entriesperpage");
        if (field == null || field != null && field.length() == 0) {
            field = xmlElt.getAttribute("entriesperpage");
        }
        if (field == null || field != null && field.trim().length() == 0) {
            try {
                Element profileEntryElement = pStore.getUserProfile("iPlanet Applications", false);
                if (profileEntryElement != null) {
                    field = XPathTools.getValueByXPath((Node)profileEntryElement, (String)ENTRIES_PER_PAGE_XPATH);
                } else {
                    this._logHandler.debug("Couldn't get the profileElement");
                }
            }
            catch (XSLProcessingException pe) {
                this._logHandler.error("Error(getUserProfile) - " + pe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("rawmsg", "Error: " + pe.getMessage());
                errorRootElt.appendChild(errorElt);
                return;
            }
        }
        try {
            entriesPerPage = Integer.parseInt(field);
        }
        catch (NumberFormatException nfe) {
            this._logHandler.error("PagedSearchResultHdler.expand : wrong XML entriesperpage:" + field);
            entriesPerPage = 25;
        }
        if (entriesPerPage == 0) {
            entriesPerPage = 25;
        }
        int firstEntry = 1;
        field = request.getParameter("firstentry");
        if (field != null && field.length() > 0) {
            try {
                firstEntry = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                this._logHandler.error("PagedSearchResultHdler.expand: wrong firstentry: " + field);
                xmlElt.setAttribute("error", "Error: wrong firstentry: " + field);
                return;
            }
        }
        if (firstEntry == 0) {
            firstEntry = 1;
        }
        Element searchResult = null;
        try {
            searchResult = xmlDoc.createElement("searchresult");
            xmlElt.appendChild(searchResult);
        }
        catch (DOMException de) {
            this._logHandler.error("PagedSearchResultHandler.expand: searchresult creation returned: " + de.getMessage());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "512");
            errorElt.setAttribute("rawmsg", "Can't create xmlElt searchresult: " + de.getMessage());
            errorRootElt.appendChild(errorElt);
            return;
        }
        if (searchResult == null) {
            this._logHandler.error("PagedSearchResultHandler.expand : searchResult is null after creation");
            xmlElt.setAttribute("error", "Error : searchResult is null after creation");
            return;
        }
        boolean expand = true;
        String expandString = xmlElt.getAttribute("expand");
        if (expandString != null && expandString.equals("0")) {
            expand = false;
        }
        if (quotawarn > 0) {
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "1");
            errorElt.setAttribute("errnum", "67");
            errorElt.setAttribute("rawmsg", "  used : " + quotawarn + "%");
            errorRootElt.appendChild(errorElt);
        }
        if (!expand) {
            searchResult.setAttribute("searchid", searchID == null ? "" : searchID);
            searchResult.setAttribute("filter", decodedFilter);
            searchResult.setAttribute("sortby", sortBy);
            searchResult.setAttribute("firstentry", String.valueOf(firstEntry));
            searchResult.setAttribute("entriesperpage", String.valueOf(entriesPerPage));
            searchResult.setAttribute("bookid", currentBookID == null ? "" : currentBookID);
        } else {
            if (searchID == null || searchID.length() == 0) {
                try {
                    searchID = pStore.searchBook(currentBookID, filter, null, entryType, sortBy, entriesPerPage);
                    searchResult.setAttribute("type", typeList);
                    session.setAttribute("searchid", (Object)searchID);
                }
                catch (PStoreException pe) {
                    this._logHandler.error("PagedSearchResultHandler.expand: searchBook returned: " + pe.getReason() + " : " + pe.getMessage());
                    searchResult.setAttribute("filter", decodedFilter);
                    searchResult.setAttribute("sortby", sortBy);
                    searchResult.setAttribute("firstentry", String.valueOf(firstEntry));
                    searchResult.setAttribute("entriesperpage", String.valueOf(entriesPerPage));
                    searchResult.setAttribute("bookid", currentBookID == null ? "" : currentBookID);
                    Element errorElt = errorDoc.createElement("error");
                    if (pe.getReason() == 14) {
                        errorElt.setAttribute("errtype", "0");
                        errorElt.setAttribute("errnum", "7");
                        errorElt.setAttribute("bookid", currentBookID);
                    } else if (pe.getReason() == 21) {
                        this._logHandler.error("PagedSearchResultHdler.expand: searchBook : client timeout :" + pe.getReason() + " : " + pe.getMessage());
                        errorElt.setAttribute("errtype", "2");
                        errorElt.setAttribute("errnum", "286");
                    } else {
                        errorElt.setAttribute("errtype", "2");
                        errorElt.setAttribute("errnum", "512");
                        errorElt.setAttribute("rawmsg", "Error (" + pe.getReason() + "), pStore.searchBook threw: " + pe.getMessage());
                    }
                    errorRootElt.appendChild(errorElt);
                    return;
                }
            }
            try {
                pStore.getResult(searchID, firstEntry, searchResult);
                searchResult.setAttribute("type", typeList);
            }
            catch (PStoreException pe) {
                this._logHandler.error("PagedSearchResultHandler.expand: getResult returned: " + pe.getReason() + " : " + pe.getMessage());
                searchResult.setAttribute("filter", decodedFilter);
                searchResult.setAttribute("sortby", sortBy);
                searchResult.setAttribute("firstentry", String.valueOf(firstEntry));
                searchResult.setAttribute("entriesperpage", String.valueOf(entriesPerPage));
                searchResult.setAttribute("bookid", currentBookID == null ? "" : currentBookID);
                Element errorElt = errorDoc.createElement("error");
                if (pe.getReason() == 21) {
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "286");
                } else {
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "512");
                    errorElt.setAttribute("rawmsg", "Error (" + pe.getReason() + "), pStore.getResult threw: " + pe.getMessage());
                }
                errorRootElt.appendChild(errorElt);
                return;
            }
        }
        Element expandedGroupsElement = null;
        try {
            expandedGroupsElement = xmlDoc.createElement("expandedgroups");
            xmlElt.appendChild(expandedGroupsElement);
        }
        catch (DOMException de) {
            this._logHandler.error("PagedSearchResultHandler.expand: expandedGroupsElement creation returned: " + de.getMessage());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "512");
            errorElt.setAttribute("rawmsg", "Can't create element expandedgroups: " + de.getMessage());
            errorRootElt.appendChild(errorElt);
            return;
        }
        if (expandedGroupsElement == null) {
            this._logHandler.error("PagedSearchResultHandler.expand: expandedGroupsElement is null after creation");
            xmlElt.setAttribute("error", "Error : expandedGroups is null after creation");
            return;
        }
        String[] expandedGroups = request.getParameterValues("expandedgroup");
        int nbExpanded = 0;
        if (expandedGroups != null) {
            nbExpanded = expandedGroups.length;
        }
        String expandGroup = request.getParameter("expandgroup");
        int i = 0;
        String entryID = null;
        if (expandGroup != null) {
            entryID = expandGroup;
        } else if (nbExpanded != 0) {
            entryID = expandedGroups[i++];
        }
        HashMap<String, Element> expandedGroupsAccordingToHTML = new HashMap<String, Element>();
        while (entryID != null) {
            if (entryID.length() > 0) {
                this._logHandler.debug("ExpandedGroups.expand: expanding entryID=" + entryID);
                Element expandedGroupElement = xmlDoc.createElement("expandedgroup");
                expandedGroupElement.setAttribute("entryID", entryID);
                expandedGroupsElement.appendChild(expandedGroupElement);
                expandedGroupsAccordingToHTML.put(entryID, expandedGroupElement);
            }
            if (nbExpanded <= 0 || i >= nbExpanded) break;
            entryID = expandedGroups[i++];
        }
        if ((field = request.getParameter("groupentrytypes")) == null) {
            field = xmlElt.getAttribute("groupentrytype");
        }
        if (field != null && field.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector();
            while ((newIndex = field.indexOf(",", index)) != -1) {
                entryType.add(field.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(field.substring(index));
        }
        if (expand) {
            this.getGroupsInPage(searchResult, expandedGroupsAccordingToHTML, 1, pStore, null, entryType, currentBookID, sortBy, xmlDoc);
        }
    }

    private int getGroupsInPage(Element rootElement, HashMap expandedGroupsAccordingToHTML, int i, PersonalStore pStore, Vector retFields, Vector entryType, String currentBookID, String sortBy, Document xmlDoc) {
        this._logHandler.debug("ExpandedGroups.expand: expanding EntryID=" + rootElement.getAttribute("entryID"));
        Element expandedGroupElement = null;
        String entryID = null;
        for (Element curElement = (Element)rootElement.getFirstChild(); curElement != null; curElement = (Element)curElement.getNextSibling()) {
            curElement.setAttribute("entrynumber", String.valueOf(i++));
            if (!curElement.getNodeName().equals("group")) continue;
            try {
                entryID = XPathTools.getValueByXPath((Node)curElement, (String)"entry/@entryID");
            }
            catch (XSLProcessingException xe) {
                this._logHandler.error("ExpandedGroupHandler.getGroupsInPage: " + xe.getMessage());
                expandedGroupElement.setAttribute("error", "Error : " + xe.getMessage());
                return -1;
            }
            if (entryID == null) {
                this._logHandler.error("ExpandedGroupHandler.getGroupsInPage: No entryID node found.");
                expandedGroupElement.setAttribute("error", "Error : No entryID node found.");
                return -1;
            }
            String baseURL = null;
            Book curBook = null;
            try {
                curBook = pStore.getBook(currentBookID);
            }
            catch (PStoreException pe) {
                this._logHandler.error("ExpandedGroupHandler.getGroupsInPage: getBook returned: " + pe.getReason() + " : " + pe.getMessage());
                return -1;
            }
            baseURL = curBook.getBookRemoteURL();
            expandedGroupElement = (Element)expandedGroupsAccordingToHTML.get(entryID);
            if (expandedGroupElement == null) continue;
            try {
                if (baseURL != null) {
                    pStore.searchBook(currentBookID, "memberofgroup=" + entryID, retFields, entryType, sortBy, expandedGroupElement);
                } else {
                    pStore.searchBook("*", "memberofgroup=" + entryID, retFields, entryType, sortBy, expandedGroupElement);
                }
            }
            catch (PStoreException pe) {
                this._logHandler.error("ExpandedGroupHandler.getGroupsInPage: " + pe.getReason() + ":" + pe.getMessage());
                expandedGroupElement.setAttribute("error", "Error " + pe.getReason() + " : " + pe.getMessage());
                return -1;
            }
            expandedGroupsAccordingToHTML.remove(entryID);
            i = this.getGroupsInPage(expandedGroupElement, expandedGroupsAccordingToHTML, i, pStore, retFields, entryType, currentBookID, sortBy, xmlDoc);
        }
        return i;
    }
}

