/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModifyGroupFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("ModifyGroupFormHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("ModifyGroupFormHandler.process: null Error Doc");
            return false;
        }
        FormTranslatableEntry fte = null;
        String sPrefix = request.getParameter("prefix");
        String sBookID = request.getParameter("bookid");
        String sEntryID = request.getParameter("entryid");
        String sIdsToAdd = request.getParameter("idstoadd");
        String sIdsToRmv = request.getParameter("idstormv");
        if (sEntryID == null || sEntryID.length() == 0 || sPrefix == null || sPrefix.length() == 0 || sBookID == null || sBookID.length() == 0 || sIdsToAdd == null) {
            Element paramElt;
            Element errorElt = null;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
            if (sEntryID == null || sEntryID.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field entryid is missing or invalid: " + sEntryID);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "entryid");
                errorElt.appendChild(paramElt);
            }
            if (sPrefix == null || sPrefix.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field prefix is missing or invalid: " + sPrefix);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "prefix");
                errorElt.appendChild(paramElt);
            }
            if (sBookID == null || sBookID.length() == 0) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field bookid is missing or invalid: " + sBookID);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "bookid");
                errorElt.appendChild(paramElt);
            }
            if (sIdsToAdd == null) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field idstoadd is missing: " + sIdsToAdd);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "idstoadd");
                errorElt.appendChild(paramElt);
            }
            if (sIdsToRmv == null) {
                this._logHandler.error("AddGroupFormHandler.Process: HTML field idstormv is missing: " + sIdsToAdd);
                paramElt = errorDoc.createElement("parameter");
                paramElt.setAttribute("paramname", "idstormv");
                errorElt.appendChild(paramElt);
            }
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ModifyGroupFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("ModifyGroupFormHandler.process: null pStore");
            return false;
        }
        String dn = null;
        if (sPrefix != null && !sPrefix.equals("")) {
            try {
                fte = new FormTranslatableEntry((ServletRequest)request, sPrefix);
                if (fte == null) {
                    this._logHandler.error("ModifyGroupFormHandler.Process: Can not create the FormTranslatableEntry");
                    return false;
                }
                Element elt = this._dbTranslation.translate((DbTranslatable)fte);
                if (elt == null) {
                    this._logHandler.error("ModifyGroupFormHandler.Process : Element is null");
                    return false;
                }
                dn = XPathTools.getValueByXPath((Node)elt, (String)"entry/displayname");
                if (dn == null || dn.length() == 0) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "129");
                    Element fieldElt = errorDoc.createElement("field");
                    fieldElt.setAttribute("elementname", "displayname");
                    errorElt.appendChild(fieldElt);
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
                pStore.modifyEntry(sBookID, sEntryID, elt);
            }
            catch (PStoreException pse) {
                this._logHandler.error("ModifyGroupFormHandler.Process: Can not update entry: " + pse.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "264");
                errorElt.setAttribute("rawmsg", "ModifyGroupFormHandler.Process: Can not update group: " + pse.getMessage());
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (XSLProcessingException xpe) {
                this._logHandler.error("ModifyGroupFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "ModifyGroupFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (DbTransException dbe) {
                this._logHandler.error("ModifyGroupFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "ModifyGroupFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
        } else {
            this._logHandler.error("ModifyGroupFormHandler.Process: Incorrect value for prefix : " + sPrefix);
            return false;
        }
        String delim = request.getParameter("valueseparator");
        String sCurID = null;
        if (delim == null || delim.length() == 0) {
            delim = ";";
        }
        StringTokenizer idsToAdd = new StringTokenizer(sIdsToAdd, delim);
        StringTokenizer idsToRmv = new StringTokenizer(sIdsToRmv, delim);
        while (idsToAdd.hasMoreTokens()) {
            sCurID = idsToAdd.nextToken();
            try {
                this._logHandler.debug("ModifyGroupFormHandler.Process : Calling addGroupMember('" + sBookID + "','" + sEntryID + "','" + sCurID + "')");
                pStore.addGroupMember(sBookID, sEntryID, sCurID);
            }
            catch (PStoreException pse) {
                this._logHandler.error("ModifyGroupFormHandler.Process: Add member to group failed: " + pse.getMessage() + " (" + pse.getReason() + "). Last entry processed: " + sEntryID);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                switch (pse.getReason()) {
                    case 11: {
                        errorElt.setAttribute("errnum", "268");
                        try {
                            errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                        }
                        catch (PStoreException e) {}
                        break;
                    }
                    case 13: {
                        errorElt.setAttribute("errnum", "269");
                        try {
                            errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                        }
                        catch (PStoreException e) {}
                        break;
                    }
                    default: {
                        errorElt.setAttribute("errnum", "266");
                    }
                }
                errorElt.setAttribute("rawmsg", "ModifyGroupFormHandler.Process: Add member to group failed: " + pse.getMessage() + " (" + pse.getReason() + "). Last entry processed: " + sEntryID);
                errorRootElt.appendChild(errorElt);
                return false;
            }
        }
        while (idsToRmv.hasMoreTokens()) {
            sCurID = idsToRmv.nextToken();
            try {
                this._logHandler.debug("ModifyGroupFormHandler.Process : Calling removeGroupMember('" + sBookID + "','" + sEntryID + "','" + sCurID + "')");
                pStore.removeGroupMember(sBookID, sEntryID, sCurID);
            }
            catch (PStoreException pse) {
                this._logHandler.error("ModifyGroupFormHandler.Process: Remove member from group failed: " + pse.getMessage() + " (" + pse.getReason() + "). Last entry processed: " + sEntryID);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "267");
                try {
                    errorElt.setAttribute("displayname", pStore.getEntry(sBookID, sEntryID).getDisplayName());
                }
                catch (PStoreException e) {
                    // empty catch block
                }
                errorElt.setAttribute("rawmsg", "ModifyGroupFormHandler.Process: Remove member from group failed: " + pse.getMessage() + " (" + pse.getReason() + "). Last entry processed: " + sEntryID);
                errorRootElt.appendChild(errorElt);
                return false;
            }
        }
        Element errorElt = errorDoc.createElement("error");
        errorElt.setAttribute("errtype", "0");
        errorElt.setAttribute("errnum", "11");
        errorRootElt.appendChild(errorElt);
        return true;
    }
}

