/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModifyEntryFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("ModifyEntryFormHandler.Process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("ModifyEntryFormHandler.Process: null Error Doc");
            return false;
        }
        FormTranslatableEntry fte = null;
        String sPrefix = request.getParameter("prefix");
        String sBookID = request.getParameter("bookid");
        String sEntryID = request.getParameter("entryid");
        if (sPrefix == null || sPrefix.length() == 0) {
            this._logHandler.error("ModifyEntryFormHandler.Process : sPrefix is invalid: " + sPrefix);
            return false;
        }
        if (sBookID == null || sBookID.length() == 0) {
            this._logHandler.error("ModifyEntryFormHandler.Process : sBookID is invalid: " + sBookID);
            return false;
        }
        if (sEntryID == null || sEntryID.length() == 0) {
            this._logHandler.error("ModifyEntryFormHandler.Process : sEntryID is invalid: " + sEntryID);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ModifyEntryFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("ModifyEntryFormHandler.process: null pStore");
            return false;
        }
        String dn = null;
        if (sPrefix != null && !sPrefix.equals("")) {
            try {
                fte = new FormTranslatableEntry((ServletRequest)request, sPrefix);
                if (fte == null) {
                    this._logHandler.error("ModifyEntryFormHandler.Process: Can not create the FormTranslatableEntry");
                    return false;
                }
                Element elt = this._dbTranslation.translate((DbTranslatable)fte);
                if (elt == null) {
                    this._logHandler.error("ModifyEntryFormHandler.Process : Element is null");
                    return false;
                }
                dn = XPathTools.getValueByXPath((Node)elt, (String)"entry/displayname");
                if (dn == null || dn.length() == 0) {
                    Element errorElt = errorDoc.createElement("error");
                    errorElt.setAttribute("errtype", "2");
                    errorElt.setAttribute("errnum", "129");
                    Element fieldElt = errorDoc.createElement("field");
                    fieldElt.setAttribute("elementname", "displayname");
                    errorElt.appendChild(fieldElt);
                    errorRootElt.appendChild(errorElt);
                    return false;
                }
                pStore.modifyEntry(sBookID, sEntryID, elt);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "0");
                errorElt.setAttribute("errnum", "12");
                errorElt.setAttribute("elementname", elt.getTagName());
                errorElt.setAttribute("displayname", dn);
                errorRootElt.appendChild(errorElt);
                return true;
            }
            catch (PStoreException pse) {
                this._logHandler.error("ModifyEntryFormHandler.Process : Can not update entry : " + pse.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                if (pse.getReason() == 19) {
                    errorElt.setAttribute("errnum", "287");
                    errorElt.setAttribute("rawmsg", pse.getMessage());
                } else {
                    errorElt.setAttribute("errnum", "265");
                    errorElt.setAttribute("rawmsg", "ModifyEntryFormHandler.Process: Can not update group: " + pse.getMessage());
                }
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (XSLProcessingException xpe) {
                this._logHandler.error("ModifyEntryFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "ModifyEntryFormHandler.Process: Error while checking data consistency: " + xpe.getMessage());
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
            catch (DbTransException dbe) {
                this._logHandler.error("ModifyEntryFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorElt.setAttribute("rawmsg", "ModifyEntryFormHandler.Process: Error while translating form elements into XML tree: " + dbe.getMessage());
                if (dn != null) {
                    errorElt.setAttribute("displayname", dn);
                }
                errorRootElt.appendChild(errorElt);
                return false;
            }
        }
        this._logHandler.error("ModifyEntryFormHandler.Process: Incorrect value for prefix : " + sPrefix);
        return false;
    }
}

