/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.xslui.ui.ElementHandler;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeptEntriesHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        if (xmlElt == null) {
            this._logHandler.error("KeptEntriesHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("KeptEntriesHandler.expand: null XML Doc");
            return;
        }
        String fieldName = xmlElt.getAttribute("idfieldname");
        if (fieldName == null || fieldName.length() <= 0) {
            this._logHandler.error("KeptEntries.expand: required attribute fieldname not found");
            xmlElt.setAttribute("error", "Required attribute fieldname not found");
            return;
        }
        String[] selectedIds = request.getParameterValues(fieldName);
        if (selectedIds == null || selectedIds.length == 0) {
            return;
        }
        for (int i = 0; i < selectedIds.length; ++i) {
            if (selectedIds[i] == null || selectedIds[i].length() <= 0) continue;
            try {
                Element entryElt = xmlDoc.createElement("entry");
                entryElt.setAttribute("entryID", selectedIds[i]);
                xmlElt.appendChild(entryElt);
                continue;
            }
            catch (DOMException dome) {
                this._logHandler.error("KeptEntries.expand: Error creating children");
                xmlElt.setAttribute("error", "Error creating children");
                return;
            }
        }
    }
}

