/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupMembershipHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null XML Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("GroupMembershipHandler.expand: null pStore");
            return;
        }
        String sEntryID = request.getParameter("entryid");
        if (sEntryID == null || sEntryID.length() == 0) {
            this._logHandler.error("GroupMembershipHandler.expand: no entryID");
            return;
        }
        String sBookID = request.getParameter("bookid");
        if (sBookID == null || sBookID.length() == 0) {
            String bookType = request.getParameter("booktype");
            if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
                bookType = "abook";
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("GroupMembershipHandler.expand: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("GroupMembershipHandler.expand: null defaultBook");
                return;
            }
            sBookID = defaultBook.getEntryID();
        }
        Book curBook = null;
        try {
            curBook = pStore.getBook(sBookID);
        }
        catch (PStoreException pe) {
            this._logHandler.error("GroupMembershipHandler.expand: getBook returned: " + pe.getReason() + " : " + pe.getMessage());
            return;
        }
        if (curBook == null) {
            this._logHandler.error("GroupMembershipHandler.expand: curBook is null!");
            return;
        }
        Entry curEntry = null;
        if (curBook.getBookRemoteURL() != null && !curBook.getBookRemoteURL().equals("")) {
            try {
                curEntry = pStore.getEntry(curBook.getEntryID(), sEntryID);
            }
            catch (PStoreException pe) {
                this._logHandler.error("GroupMembershipHandler.expand: getEntry returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
        }
        try {
            curEntry = pStore.getEntry(sEntryID);
        }
        catch (PStoreException pe) {
            this._logHandler.error("GroupMembershipHandler.expand: getEntry returned: " + pe.getReason() + " : " + pe.getMessage());
            return;
        }
        String[] groupIDs = null;
        groupIDs = curEntry.getGroupMembership();
        if (groupIDs == null || groupIDs.length <= 0) {
            return;
        }
        this._logHandler.debug("GroupMembershipHandler.expand: nb memberofgroup : " + groupIDs.length);
        Object memberOfGroupElement = null;
        Entry groupEntry = null;
        Element groupElement = null;
        for (int i = 0; i < groupIDs.length; ++i) {
            if (groupIDs[i] == null || groupIDs[i].length() <= 0) continue;
            groupEntry = null;
            groupElement = null;
            try {
                groupEntry = pStore.getEntry(groupIDs[i], xmlElt);
            }
            catch (PStoreException pe) {
                this._logHandler.error("GroupMembershipHandler.expand: getEntry returned: " + pe.getReason() + " : " + pe.getMessage());
                continue;
            }
            groupElement = groupEntry.getEntryElement();
            if (groupElement == null) {
                this._logHandler.error("GroupMembershipHandler.expand: groupElement is null!");
                return;
            }
            try {
                xmlElt.appendChild(groupElement);
                continue;
            }
            catch (DOMException de) {
                this._logHandler.error("GroupMembershipHandler.expand: groupMembership child creation returned: " + de.getMessage());
                xmlElt.setAttribute("error", "Error : " + de.getMessage());
                return;
            }
        }
    }
}

