/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ProcessingHandler;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportProcessingHandler
extends ProcessingHandler {
    public void process(HttpServletRequest request, Document xmlDoc, OutputStream output) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ExportProcessingHandler.process: Couldn't retreive session.");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("pStore object found null");
            return;
        }
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            this._logHandler.error("bookid is null");
            return;
        }
        NodeList listofnodes = xmlDoc.getElementsByTagName("export");
        if (listofnodes == null) {
            this._logHandler.error("export element not found");
            return;
        }
        Node exportnode = listofnodes.item(0);
        NamedNodeMap attrlist = exportnode.getAttributes();
        String filter = null;
        Node filternode = attrlist.getNamedItem("filter");
        if (filternode != null) {
            filter = filternode.getNodeValue();
        }
        if (filter == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        String format = null;
        Node formatnode = attrlist.getNamedItem("format");
        if (formatnode != null) {
            format = formatnode.getNodeValue();
        }
        if (format == null || format.length() == 0) {
            format = "ldif";
        }
        String language = null;
        Node langnode = attrlist.getNamedItem("lang");
        if (langnode != null) {
            language = langnode.getNodeValue();
        }
        if (language == null) {
            language = "us";
        }
        try {
            pStore.exportEntry(bookId, filter, format, language, output);
        }
        catch (PStoreException pse) {
            this._logHandler.error("PStoreExection in ExportProcessingHandler:process " + pse.getMessage());
            return;
        }
    }
}

