/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpandedGroupMembersHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String sEntryID;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null XML Element");
            return;
        }
        if (errorRootElt == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null Error Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null XML Doc");
            return;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null Error Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: null pStore");
            return;
        }
        boolean expandSelectedGroup = false;
        String field = request.getParameter("expandgroupforaction");
        if (field == null || !field.equals("1")) {
            return;
        }
        expandSelectedGroup = true;
        String sBookID = request.getParameter("bookid");
        if (sBookID == null || sBookID.length() == 0) {
            String bookType = request.getParameter("booktype");
            if (!(bookType != null && bookType.length() > 0 || (bookType = xmlElt.getAttribute("booktype")) != null && bookType.length() > 0)) {
                bookType = "abook";
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                this._logHandler.error("ExpandedGroupMembersHandler: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
            if (defaultBook == null) {
                this._logHandler.error("ExpandedGroupMembersHandler: null defaultBook");
                return;
            }
            sBookID = defaultBook.getEntryID();
        }
        if ((sEntryID = request.getParameter("entryid")) == null || sEntryID.length() == 0) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: no entryID");
            return;
        }
        String sortBy = xmlElt.getAttribute("sortby");
        if (sortBy == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = xmlElt.getAttribute("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        try {
            if (expandSelectedGroup) {
                pStore.expandGroup(sBookID, sEntryID, entryType, sortBy, null, xmlElt);
            }
        }
        catch (PStoreException pe) {
            this._logHandler.error("ExpandedGroupMembersHandler.expand: getEntry returned: " + pe.getReason() + ": " + pe.getMessage());
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "270");
            errorElt.setAttribute("rawmsg", "ExpandedGroupMembersHandler: getEntry returned: " + pe.getReason() + ": " + pe.getMessage());
            errorElt.setAttribute("entryid", sEntryID);
            errorElt.setAttribute("bookid", sBookID);
            errorRootElt.appendChild(errorElt);
            return;
        }
    }
}

