/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyEntriesFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        Element paramElt;
        int index;
        if (errorRootElt == null) {
            this._logHandler.error("CopyEntriesFormHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("CopyEntriesFormHandler.process: null Error Doc");
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("CopyEntriesFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("CopyEntriesiFormHandler.expand: null pStore");
            return false;
        }
        Object fte = null;
        String dstBookID = null;
        String bookType = "abook";
        String[] sEntryID = request.getParameterValues("selectedentry");
        String[] alreadySEntryID = request.getParameterValues("alreadyselectedentry");
        int length = 0;
        if (sEntryID != null) {
            length = sEntryID.length;
        }
        if (alreadySEntryID != null) {
            length += alreadySEntryID.length;
        }
        if (length == 0) {
            return false;
        }
        String[] srcEntryID = new String[length];
        int jindex = 0;
        if (sEntryID != null) {
            for (index = 0; index < sEntryID.length; ++index) {
                srcEntryID[jindex++] = sEntryID[index];
            }
        }
        if (alreadySEntryID != null) {
            for (index = 0; index < alreadySEntryID.length; ++index) {
                srcEntryID[jindex++] = alreadySEntryID[index];
            }
        }
        Book defaultBook = null;
        try {
            defaultBook = pStore.getDefaultBook(bookType);
        }
        catch (PStoreException pe) {
            this._logHandler.error("BookEntriesHandler: listBooks returned: " + pe.getReason() + " : " + pe.getMessage());
            return false;
        }
        if (defaultBook == null) {
            this._logHandler.error("BookEntryHandler: null defaultBook");
            return false;
        }
        dstBookID = defaultBook.getEntryID();
        Element errorElt = null;
        boolean paramIsMissing = false;
        if (dstBookID == null || dstBookID.length() == 0 || srcEntryID == null || srcEntryID.length == 0) {
            paramIsMissing = true;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
        }
        if (dstBookID == null || dstBookID.length() == 0) {
            this._logHandler.error("CopyEntriesFormHandler.process: HTML Parameter dstbookid is missing");
            paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "dstbookid");
            errorElt.appendChild(paramElt);
        }
        if (srcEntryID == null || srcEntryID.length == 0) {
            this._logHandler.error("CopyEntriesFormHandler.process: HTML Parameter entryid is missing");
            paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "dstbookid");
            errorElt.appendChild(paramElt);
        }
        if (paramIsMissing) {
            errorRootElt.appendChild(errorElt);
            return false;
        }
        this._logHandler.error("No of Selected Entries is " + length);
        String dstEntryID = null;
        Entry dstEntry = null;
        Element entryElt = null;
        boolean errorOccured = false;
        for (int i = 0; i < srcEntryID.length; ++i) {
            try {
                Node parentNode;
                this._logHandler.error("EntryId is " + srcEntryID[i]);
                String srcBookID = request.getParameter("id_" + srcEntryID[i] + "_bookid");
                this._logHandler.error("BookId is" + srcBookID);
                Entry srcEntry = pStore.getEntry(srcBookID, srcEntryID[i]);
                entryElt = srcEntry.getEntryElement();
                Node childNode = XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry/creationdate");
                Node node = parentNode = childNode != null ? childNode.getParentNode() : null;
                if (parentNode != null) {
                    parentNode.removeChild(childNode);
                }
                Node node2 = parentNode = (childNode = XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry/lastmodifieddate")) != null ? childNode.getParentNode() : null;
                if (parentNode != null) {
                    parentNode.removeChild(childNode);
                }
                ((Element)XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry")).removeAttribute("entryID");
                String[] bookIDs = new String[]{dstBookID};
                dstEntryID = pStore.addEntry(bookIDs, entryElt);
                dstEntry = pStore.getEntry(dstBookID, dstEntryID);
                continue;
            }
            catch (PStoreException pse) {
                this._logHandler.error("CopyEntriesFormHandler.process: Can't copy entry: " + pse.getMessage());
                errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "273");
                errorOccured = true;
                continue;
            }
            catch (XSLProcessingException xse) {
                this._logHandler.error("CopyEntriesFormHandler.process: Error while accessing entry element: " + xse.getMessage());
                errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "2");
                errorElt.setAttribute("errnum", "256");
                errorOccured = true;
            }
        }
        if (!errorOccured) {
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "0");
            errorElt.setAttribute("errnum", "9");
        }
        errorRootElt.appendChild(errorElt);
        return true;
    }
}

