/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AlreadySelectedHandler
extends ElementHandler {
    private static final String COMA = ",";

    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        String noExpandOnXPath;
        if (xmlElt == null) {
            this._logHandler.error("AlreadySelectedHandler.expand: null XML Element");
            return;
        }
        if (errorRootElt == null) {
            this._logHandler.error("AlreadySelectedHandler.expand: null Error Element");
            return;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("AlreadySelectedHandler.expand: null Error Doc");
            return;
        }
        Element entryElement = null;
        String sStopAlreadySelected = request.getParameter("stopalreadyselected");
        if (sStopAlreadySelected != null && sStopAlreadySelected.equals("1")) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("AlreadySelected.expand: null session");
            xmlElt.setAttribute("error", "null session");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("AlreadySelected.expand: null pStore");
            xmlElt.setAttribute("error", "null pStore");
            return;
        }
        String fieldName = xmlElt.getAttribute("fieldname");
        fieldName = fieldName != null && fieldName.length() > 0 ? fieldName : "selectedentry";
        String[] fieldsToRetain = fieldName.split(COMA);
        String sMaxEntries = xmlElt.getAttribute("maxentries");
        int iMaxEntries = 0;
        try {
            iMaxEntries = sMaxEntries != null && sMaxEntries.length() > 0 ? Integer.parseInt(sMaxEntries) : 100;
        }
        catch (NumberFormatException nfe) {
            iMaxEntries = 100;
        }
        ArrayList<String> selectedList = new ArrayList<String>();
        for (int index = 0; index < fieldsToRetain.length; ++index) {
            String[] selectedValues = request.getParameterValues(fieldsToRetain[index]);
            this._logHandler.error("Checking values for  " + fieldsToRetain[index]);
            if (selectedValues == null) continue;
            for (int jindex = 0; jindex < selectedValues.length; ++jindex) {
                selectedList.add(selectedValues[jindex]);
            }
        }
        if (selectedList == null || selectedList != null && selectedList.isEmpty()) {
            return;
        }
        String sortBy = xmlElt.getAttribute("sortby");
        if (sortBy == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = xmlElt.getAttribute("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(COMA, index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        boolean expandSelectedGroup = false;
        String field = request.getParameter("expandselectedgroup");
        if (field != null && field.equals("1")) {
            expandSelectedGroup = true;
        }
        if ((noExpandOnXPath = request.getParameter("expandonmissing")) != null && noExpandOnXPath.length() <= 0) {
            noExpandOnXPath = null;
        }
        int nbEntriesToKeep = 0;
        if (selectedList.size() > iMaxEntries) {
            nbEntriesToKeep = iMaxEntries;
            Element errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "1");
            errorElt.setAttribute("errnum", "65");
            errorElt.setAttribute("number", String.valueOf(iMaxEntries));
            errorRootElt.appendChild(errorElt);
        } else {
            nbEntriesToKeep = selectedList.size();
        }
        for (int i = 0; i < nbEntriesToKeep; ++i) {
            String un = (String)selectedList.get(i);
            FormTranslatableEntry formEntry = new FormTranslatableEntry((ServletRequest)request, "id_" + un + "_");
            try {
                entryElement = this._dbTranslation.translate((DbTranslatable)formEntry, xmlElt);
                this._logHandler.error("Gotten entry for - " + un);
                continue;
            }
            catch (DbTransException dte) {
                this._logHandler.error("AlreadySelectedHandler: failed translate: " + (Object)((Object)dte) + " : " + dte.getMessage());
            }
        }
        if (expandSelectedGroup) {
            try {
                pStore.expandGroups(xmlElt, entryType, sortBy, noExpandOnXPath);
            }
            catch (PStoreException pe) {
                this._logHandler.error("AlreadySelected: expandGroups returned: " + pe.getReason() + " : " + pe.getMessage());
                return;
            }
        }
    }
}

