/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.soaps;

import com.iplanet.iabs.coresrv.CorePersonalStore;
import com.iplanet.iabs.coresrv.CorePersonalStoreFactory;
import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPPStore {
    public static final String BOOKLIST = "booklist";
    public static final String SEARCHRESULT = "searchresult";
    public static final String RESULT = "result";
    private UserSession _userSession = null;
    private CorePersonalStore _ps = null;
    private static CorePersonalStoreFactory _psFactory = new CorePersonalStoreFactory();
    private static boolean _psFactoryInit = false;
    private static XMLDOMBuilder _domBuilder = null;

    public Element listBooks(SOAPContext sOAPContext, String string) throws PStoreException {
        Document document;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((document = _domBuilder.newDocument()) == null) {
            throw new PStoreException(20, "soap/listBooks: failed to create document");
        }
        Element element = null;
        try {
            element = document.createElement(BOOKLIST);
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(20, "soap/listBooks: failed to create element" + dOMException.getMessage());
        }
        Book[] bookArray = null;
        bookArray = this._ps.listBooks(string);
        if (bookArray == null) {
            return null;
        }
        try {
            Book book = null;
            Node node = null;
            for (int i = 0; i < bookArray.length; ++i) {
                book = bookArray[i];
                node = _domBuilder.copyNode((Node)book.getEntryElement(), document);
                element.appendChild(node);
            }
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(20, "soap/listBooks: failed to add child element" + xMLProcessingException.getMessage());
        }
        return element;
    }

    public Element getBook(SOAPContext sOAPContext, String string) throws PStoreException {
        Book book;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((book = this._ps.getBook(string)) == null) {
            return null;
        }
        return book.getEntryElement();
    }

    public String addBook(SOAPContext sOAPContext, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        return this._ps.addBook(element);
    }

    public void modifyBook(SOAPContext sOAPContext, String string, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.modifyBook(string, element);
    }

    public void deleteBook(SOAPContext sOAPContext, String string) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.deleteBook(string);
    }

    public Element getDefaultBook(SOAPContext sOAPContext, String string) throws PStoreException {
        Book book;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((book = this._ps.getDefaultBook(string)) == null) {
            return null;
        }
        return book.getEntryElement();
    }

    public Element search(SOAPContext sOAPContext, String string, String string2, String[] stringArray, String[] stringArray2, String string3) throws PStoreException {
        Document document;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((document = _domBuilder.newDocument()) == null) {
            throw new PStoreException(20, "soap/searchBook: failed to create document");
        }
        Element element = null;
        try {
            element = document.createElement(SEARCHRESULT);
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(20, "soap/searchBook: failed to create element:" + dOMException.getMessage());
        }
        Vector<String> vector = null;
        if (stringArray != null) {
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        Vector<String> vector2 = null;
        if (stringArray2 != null) {
            vector2 = new Vector<String>(Arrays.asList(stringArray2));
        }
        this._ps.searchBook(string, string2, vector, vector2, string3, element);
        return element;
    }

    public String pagedSearch(SOAPContext sOAPContext, String string, String string2, String[] stringArray, String[] stringArray2, String string3, int n) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        String string4 = null;
        Vector<String> vector = null;
        if (stringArray != null) {
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        Vector<String> vector2 = null;
        if (stringArray2 != null) {
            vector2 = new Vector<String>(Arrays.asList(stringArray2));
        }
        string4 = this._ps.searchBook(string, string2, vector, vector2, string3, n);
        return string4;
    }

    public Element getPagedSearchResult(SOAPContext sOAPContext, String string, int n) throws PStoreException {
        Document document;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((document = _domBuilder.newDocument()) == null) {
            throw new PStoreException(20, "soap/searchBook: failed to create document");
        }
        Element element = null;
        try {
            element = document.createElement(SEARCHRESULT);
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(20, "soap/searchBook: failed to create element:" + dOMException.getMessage());
        }
        this._ps.getResult(string, n, element);
        return element;
    }

    public void stopPagedSearch(SOAPContext sOAPContext, String string) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.stopSearch(string);
    }

    public Element getEntry(SOAPContext sOAPContext, String string, String string2) throws PStoreException {
        Entry entry;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((entry = this._ps.getEntry(string, string2)) == null) {
            return null;
        }
        return entry.getEntryElement();
    }

    public Element getEntry(SOAPContext sOAPContext, String string) throws PStoreException {
        Entry entry;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((entry = this._ps.getEntry(string)) == null) {
            return null;
        }
        return entry.getEntryElement();
    }

    public String addEntry(SOAPContext sOAPContext, String[] stringArray, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        String string = null;
        string = this._ps.addEntry(stringArray, element);
        return string;
    }

    public void modifyEntry(SOAPContext sOAPContext, String string, String string2, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.modifyEntry(string, string2, element);
    }

    public void modifyEntry(SOAPContext sOAPContext, String string, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.modifyEntry(string, element);
    }

    public void deleteEntry(SOAPContext sOAPContext, String string, String string2) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.deleteEntry(string, string2);
    }

    public Element getProfile(SOAPContext sOAPContext, String string) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        Element element = this._ps.getProfile(string);
        return element;
    }

    public void modifyProfile(SOAPContext sOAPContext, String string, Element element) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.modifyProfile(string, element);
    }

    public void addBookMember(SOAPContext sOAPContext, String string, String string2) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.addBookMember(string, string2);
    }

    public void removeBookMember(SOAPContext sOAPContext, String string, String string2) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.removeBookMember(string, string2);
    }

    public void addGroupMember(SOAPContext sOAPContext, String string, String string2, String string3) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.addGroupMember(string, string2, string3);
    }

    public void removeGroupMember(SOAPContext sOAPContext, String string, String string2, String string3) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        this._ps.removeGroupMember(string, string2, string3);
    }

    public Element expandGroup(SOAPContext sOAPContext, String string, String string2, String[] stringArray, String string3, String string4) throws PStoreException {
        Document document;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((document = _domBuilder.newDocument()) == null) {
            throw new PStoreException(20, "soap/searchBook: failed to create document");
        }
        Element element = null;
        try {
            element = document.createElement(RESULT);
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(20, "soap/searchBook: failed to create element:" + dOMException.getMessage());
        }
        Vector<String> vector = null;
        if (stringArray != null) {
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        this._ps.expandGroup(string, string2, vector, string3, string4, element);
        return element;
    }

    public Element importEntry(SOAPContext sOAPContext, String string, String string2, DataHandler dataHandler) throws PStoreException {
        Document document;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        if ((document = _domBuilder.newDocument()) == null) {
            throw new PStoreException(20, "soap/importEntry: failed to create document");
        }
        Element element = null;
        try {
            element = document.createElement("SOAPRESULT");
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(20, "soap/importEntry: failed to create element:" + dOMException.getMessage());
        }
        InputStream inputStream = null;
        try {
            inputStream = dataHandler.getInputStream();
        }
        catch (IOException iOException) {
            throw new PStoreException(20, "soap/importEntry: failed to get InputStream:" + iOException.getMessage());
        }
        this._ps.importEntry(string, string2, inputStream, element);
        return element;
    }

    public byte[] exportEntry(SOAPContext sOAPContext, String string, String string2, String string3, String string4) throws PStoreException {
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._ps.exportEntry(string, string2, string3, string4, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public String ping(SOAPContext sOAPContext, String string) throws PStoreException {
        return string;
    }

    private void loadPS(SOAPContext sOAPContext) throws PStoreException {
        if (!_psFactoryInit) {
            this.initFactory(sOAPContext);
        }
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        this._userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (this._userSession == null) {
            throw new PStoreException(20, "soap/loadPS: login failed");
        }
        this._ps = (CorePersonalStore)_psFactory.newSessionObject(this._userSession, this._userSession.getDomain());
        if (this._ps == null) {
            throw new PStoreException(20, "soap/loadPS: failed to load PersonalStore");
        }
    }

    private synchronized void initFactory(SOAPContext sOAPContext) throws PStoreException {
        if (!_psFactoryInit) {
            HttpServlet httpServlet = (HttpServlet)sOAPContext.getProperty(Constants.BAG_HTTPSERVLET);
            ServletContext servletContext = httpServlet.getServletContext();
            File file = new File(servletContext.getRealPath("/"), "WEB-INF/config");
            Logging logging = new Logging(servletContext);
            _psFactoryInit = _psFactory.init(file);
            if (!_psFactoryInit) {
                throw new PStoreException(20, "soap/initFactory: Can't initialize PS Factory");
            }
        }
    }

    public Integer getEntriesCount(SOAPContext sOAPContext) throws PStoreException {
        Integer n = null;
        if (this._ps == null) {
            this.loadPS(sOAPContext);
        }
        n = new Integer(this._ps.getEntriesCount());
        return n;
    }

    public void logout(SOAPContext sOAPContext) throws PStoreException {
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        httpSession.invalidate();
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xMLProcessingException) {
            Logging.error((int)32, (String)("Couldn't create XMLDOMBuilder: " + xMLProcessingException.getMessage()));
        }
    }
}

