/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ldapplug;

import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.ldapplug.LDAP2XMLTranslatable;
import com.iplanet.iabs.ldapplug.iLdapDb;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.TwoWayDbTranslation;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.ArrayList;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class iLdapSearch
implements PagedSearch {
    private int _max_count;
    private String _search_base;
    private String _filter;
    private String[] _ret_attribs;
    private boolean _have_fields;
    private String _main_sort_xml;
    private iLdapDb _caller;
    private int _entryCount;
    private LDAPVirtualListControl _vcon;
    private boolean _this_search_vlv;
    private TwoWayDbTranslation _dbTrans;
    private String _main_sort;
    private boolean _main_rev_sort;
    private LDAPControl[] _controls;
    private int _max_page = 0;
    private Vector _last_fields;
    private Vector _last_dups_list;

    iLdapSearch(int max_count, String search_base, String filter, String[] ret_attribs, boolean have_fields, LDAPSortKey[] sort_keys, UserSession user_session, int entryCount, String main_sort_xml, LDAPVirtualListControl vcon, boolean this_search_vlv, TwoWayDbTranslation dbTrans, iLdapDb caller) {
        this._max_count = max_count;
        this._search_base = search_base;
        this._filter = filter;
        this._ret_attribs = ret_attribs;
        this._have_fields = have_fields;
        this._dbTrans = dbTrans;
        this._caller = caller;
        this._main_sort_xml = main_sort_xml.startsWith("-") || main_sort_xml.startsWith("+") ? main_sort_xml.substring(1) : main_sort_xml;
        this._entryCount = entryCount;
        this._vcon = vcon;
        this._this_search_vlv = this_search_vlv;
        LDAPSortKey skey = sort_keys[0];
        String key = skey.getKey();
        boolean rev = !skey.getReverse();
        this._main_sort = key;
        this._main_rev_sort = !rev;
        LDAPSortControl sortcon = new LDAPSortControl(sort_keys, true);
        LDAPProxiedAuthControl pcntrl = null;
        if (this._caller._login_type == "PROXY") {
            pcntrl = new LDAPProxiedAuthControl(user_session.getDN(), true);
        }
        int ccount = 1;
        if (pcntrl != null) {
            ++ccount;
        }
        if (this._vcon != null) {
            ++ccount;
        }
        this._controls = new LDAPControl[ccount];
        this._controls[0] = sortcon;
        if (pcntrl != null) {
            this._controls[1] = pcntrl;
        } else if (ccount == 2) {
            this._controls[1] = null;
        }
        this._last_fields = new Vector(16);
        this._last_dups_list = new Vector(16);
        this._last_fields.addElement(null);
        Integer blech = new Integer(0);
        this._last_dups_list.addElement(blech);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getResult(int first, int flags, Element resElt) throws piDbException {
        int nbEntries;
        block31: {
            String last_field;
            int last_dups;
            block34: {
                int dup_count;
                Node last_node;
                String current_last_field;
                int sortNodesSize;
                ArrayList sort_nodes;
                block36: {
                    block32: {
                        block35: {
                            block33: {
                                int max_count = this._max_count;
                                int page = 0;
                                String filter = new String(this._filter);
                                last_dups = 0;
                                last_field = null;
                                boolean control_count = true;
                                if (resElt == null) {
                                    throw new piDbException(28, "searchBook: no resElt");
                                }
                                Document resultTree = resElt.getOwnerDocument();
                                if (resultTree == null) {
                                    throw new piDbException(28, "searchBook: resElt not attached to any doc");
                                }
                                if (!this._this_search_vlv) {
                                    if (first > this._entryCount) {
                                        throw new piDbException(30, "Bad First = " + first + " : Max is " + this._entryCount);
                                    }
                                    if (this._max_page == 0) {
                                        if (first != 1) {
                                            throw new piDbException(30, "Bad First = " + first);
                                        }
                                        page = 0;
                                    } else {
                                        if (this._max_count > 1) {
                                            if (first % this._max_count != 1) {
                                                throw new piDbException(30, "Bad First = " + first + "Entries per page = " + this._max_count);
                                            }
                                            page = first / this._max_count;
                                        } else {
                                            page = first - 1;
                                        }
                                        if (page > this._max_page) {
                                            throw new piDbException(30, "Bad First = " + first);
                                        }
                                    }
                                    last_field = (String)this._last_fields.get(page);
                                    Integer blech = (Integer)this._last_dups_list.get(page);
                                    last_dups = blech;
                                    if (last_field != null) {
                                        String above = null;
                                        above = this._main_rev_sort ? "<=" : ">=";
                                        filter = last_field.length() > 0 ? "&(" + filter + ")(|(" + this._main_sort + above + last_field + ")(!(" + this._main_sort + "=*)))" : "&(" + filter + ")(!(" + this._main_sort + "=*))";
                                    }
                                    max_count = this._max_count + last_dups;
                                    Logging.trace((int)1, (String)("Next page, filter = " + filter + "; count = " + max_count));
                                }
                                if (this._vcon != null) {
                                    this._vcon.setRange(first, 0, this._max_count);
                                    if (this._controls[1] != null) {
                                        this._controls[2] = this._vcon;
                                    } else {
                                        this._controls[1] = this._vcon;
                                    }
                                }
                                LDAPConnection ldapConn = this._caller.getLDAPConn();
                                LDAPSearchConstraints cons = (LDAPSearchConstraints)ldapConn.getSearchConstraints().clone();
                                cons.setMaxResults(max_count);
                                cons.setServerControls(this._controls);
                                Logging.trace((int)1, (String)"getResult: after setting controls");
                                Logging.trace((int)1, (String)cons.toString());
                                LDAPSearchResults res = null;
                                try {
                                    res = ldapConn.search(this._search_base, 2, filter, this._ret_attribs, false, cons);
                                }
                                catch (LDAPException ex) {
                                    this._caller.closeLdapConn(ldapConn);
                                    if (ex.getLDAPResultCode() == 85) {
                                        throw new piDbException(29, "TIMOUT MF" + ex.toString());
                                    }
                                    throw new piDbException(15, "RW MF" + ex.toString() + ":::" + ex.getLDAPResultCode());
                                }
                                nbEntries = 0;
                                LDAPEntry entry = null;
                                int dup_cnt = last_dups;
                                try {
                                    while (res.hasMoreElements() && nbEntries < max_count) {
                                        entry = res.next();
                                        if (dup_cnt-- > 0) {
                                            --max_count;
                                            continue;
                                        }
                                        ++nbEntries;
                                        LDAP2XMLTranslatable dbEntry = new LDAP2XMLTranslatable(entry);
                                        try {
                                            this._dbTrans.translate((DbTranslatable)dbEntry, resElt);
                                        }
                                        catch (DbTransException de) {
                                            this._caller.closeLdapConn(ldapConn);
                                            throw new piDbException(22, "Translate failed:" + de.toString());
                                        }
                                    }
                                }
                                catch (LDAPException ex) {
                                    this._caller.closeLdapConn(ldapConn);
                                    throw new piDbException(15, ex.toString());
                                }
                                this._caller.closeLdapConn(ldapConn);
                                if (this._this_search_vlv) {
                                    return nbEntries;
                                }
                                if (nbEntries == 0) {
                                    return 0;
                                }
                                if (nbEntries < this._max_count) {
                                    return nbEntries;
                                }
                                if (page != this._max_page) break block31;
                                sort_nodes = null;
                                sortNodesSize = 0;
                                try {
                                    sort_nodes = XPathTools.getNodesByXPath((Node)resElt, (String)("*/" + this._main_sort_xml));
                                }
                                catch (XSLProcessingException xse) {
                                    throw new piDbException(20, xse.toString());
                                }
                                if (sort_nodes != null) {
                                    sortNodesSize = sort_nodes.size();
                                }
                                current_last_field = "";
                                last_node = null;
                                if (sortNodesSize != this._max_count) break block32;
                                last_node = (Node)sort_nodes.get(sortNodesSize - 1);
                                current_last_field = this.getNodeValue(last_node);
                                if (!current_last_field.equals(last_field)) break block33;
                                last_dups += this._max_count;
                                break block34;
                            }
                            last_field = current_last_field;
                            if (this._max_count <= 1) break block35;
                            break block36;
                        }
                        last_dups = 1;
                        break block34;
                    }
                    last_dups = sortNodesSize > 0 ? this._max_count - sortNodesSize : (last_field.length() > 0 ? this._max_count : (last_dups += this._max_count));
                    last_field = "";
                    break block34;
                }
                for (dup_count = sortNodesSize - 2; dup_count >= 0; --dup_count) {
                    last_node = (Node)sort_nodes.get(dup_count);
                    current_last_field = this.getNodeValue(last_node);
                    if (last_field.equals(current_last_field)) continue;
                    ++dup_count;
                    break;
                }
                last_dups = sortNodesSize - 1 - dup_count + 1;
            }
            ++this._max_page;
            this._last_fields.addElement(last_field);
            Integer blech = new Integer(last_dups);
            this._last_dups_list.addElement(blech);
        }
        return nbEntries;
    }

    public int getTotalEntryCount() {
        return this._entryCount;
    }

    public void stopPagedSearch() {
    }

    private String getNodeValue(Node node) {
        String value = null;
        if (node instanceof Attr) {
            value = node.getNodeValue();
        } else if (node instanceof Element) {
            Node curNode;
            for (curNode = node.getFirstChild(); curNode != null && curNode.getNodeType() != 3; curNode = curNode.getNextSibling()) {
            }
            value = curNode != null ? curNode.getNodeValue() : null;
        }
        return value;
    }
}

