/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ldapplug;

import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.ldapplug.LDAP2XMLTranslatable;
import com.iplanet.iabs.ldapplug.XML2LDAPTranslatable;
import com.iplanet.iabs.ldapplug.iLdapSearch;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.TwoWayDbTranslation;
import com.iplanet.xslui.dbtrans.XML2DbTranslatable;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class iLdapDb
implements DBPlugin,
PS_DBPlugin {
    private static final int EXIST_OR_BAIL = 1;
    private String _db_name;
    protected boolean _vlv_paging;
    protected String _vlv_index;
    protected String _login_type;
    protected String _base_DN;
    protected String _entry_id_type;
    protected int _lookthru_limit;
    private boolean _allow_unpaged_search;
    private boolean _ret_db_attribs;
    private LDAPPool _ldapConnPool = null;
    private ArrayList _allXMLEntryTypes = null;
    private int _idCount = 0;
    protected HashMap _shared_vars = null;
    private HashSet _skipAttrs = null;
    private TwoWayDbTranslation _dbTrans = null;
    private static XMLDOMBuilder _domBuilder = null;

    public iLdapDb(File db_config_dir, int flags, String dbKey) throws piDbException {
        this._db_name = new String(db_config_dir.getName());
        File db_config_file = new File(db_config_dir, "db_config.properties");
        PropertyReader config = null;
        try {
            config = new PropertyReader(db_config_file);
        }
        catch (IOException io) {
            throw new piDbException(3, db_config_dir + "db_config.properties");
        }
        this._vlv_paging = config.getBooleanProperty("vlv_paging", "false");
        this._vlv_index = config.getStringProperty("vlv_index", "entry/displayname");
        this._base_DN = config.getStringProperty("search_dn", "");
        this._entry_id_type = config.getStringProperty("entry_id", "piEntryID");
        this._skipAttrs = new HashSet();
        this._skipAttrs.add(this._entry_id_type.toLowerCase());
        this._ret_db_attribs = config.getBooleanProperty("retrieve_db_attribs", "false");
        this._lookthru_limit = config.getIntProperty("lookthru_limit", 1000);
        this._allow_unpaged_search = config.getBooleanProperty("allow_unpaged_search", "true");
        this._login_type = config.getStringProperty("login_type", "anon");
        Logging.trace((int)1, (String)("iLdapDb: will get a connPool for " + dbKey));
        try {
            this._ldapConnPool = LDAPConfigReader.getLDAPPool((PropertyReader)config, (String)(dbKey + "."));
        }
        catch (LDAPException l) {
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(4, this._db_name + " : " + l.getMessage());
        }
        try {
            this._dbTrans = new TwoWayDbTranslation(db_config_dir);
        }
        catch (DbTransException dbx) {
            throw new piDbException(5, dbx.toString());
        }
        String[] allEntryTypes = this._dbTrans.getXMLTypes();
        this._allXMLEntryTypes = new ArrayList<String>(Arrays.asList(allEntryTypes));
    }

    /*
     * Exception decompiling
     */
    public int search(UserSession user_session, String search_base_url, String search_filter, Vector ret_fields, Vector sortby_fields, Vector entry_types, Element resElt, int flags) throws piDbException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PagedSearch pagedSearch(UserSession user_session, String search_base_url, String search_filter, Vector ret_fields, Vector sortby_fields, Vector entry_types, int entries_per_page, int flags) throws piDbException {
        int entrycount;
        LDAPVirtualListControl vcon;
        LDAPConnection ldapConn;
        boolean have_fields;
        String[] ret_attribs;
        String main_sort_xml;
        LDAPSortKey[] sort_keys;
        String search_base;
        String filter;
        boolean this_search_vlv;
        block33: {
            LDAPVirtualListResponse vrcon;
            LDAPControl[] c;
            block32: {
                int eqindex;
                ArrayList etypes = null;
                if (entry_types == null) {
                    etypes = this._allXMLEntryTypes;
                } else {
                    etypes = new ArrayList(entry_types);
                    this.removeUselessEntryTypes(etypes);
                }
                this_search_vlv = false;
                if (this._vlv_paging && (eqindex = search_filter.indexOf(61)) > 0) {
                    String param_str;
                    int param_index = search_filter.lastIndexOf(43, eqindex);
                    if (param_index < 0 && (param_index = search_filter.lastIndexOf(40, eqindex)) < 0) {
                        param_index = 0;
                    }
                    if ((param_str = search_filter.substring(param_index, eqindex)).equals(this._vlv_index) && search_filter.charAt(eqindex + 1) == '*') {
                        this_search_vlv = true;
                    }
                }
                Logging.trace((int)1, (String)("iLdapDb.pagedSearch(): Using VLV control = " + this_search_vlv));
                filter = this.xlateSearchFilter(search_filter, etypes, this_search_vlv);
                LDAPUrl ldapurl = null;
                try {
                    ldapurl = new LDAPUrl(search_base_url);
                }
                catch (MalformedURLException ex) {
                    throw new piDbException(16, search_base_url + " " + ex.getMessage());
                }
                search_base = ldapurl.getDN();
                if ((search_base == null || search_base != null && search_base.length() == 0) && (search_base = user_session.getDN()) == null) {
                    throw new piDbException(16, search_base_url);
                }
                String filter_base = ldapurl.getFilter();
                if (filter_base != null && filter_base.length() > 0) {
                    if (!filter_base.startsWith("(")) {
                        filter_base = "(" + filter_base + ")";
                    }
                    filter = "&(" + filter + ")" + filter_base;
                }
                LDAPSortControl sorter = null;
                sort_keys = null;
                main_sort_xml = (String)sortby_fields.get(0);
                String mainSortLDAP = null;
                int sortby_count = sortby_fields.size();
                if (sortby_count > 0) {
                    sort_keys = new LDAPSortKey[sortby_count];
                    sorter = this.xlateSortbyFields(sortby_fields, sort_keys, etypes);
                    if (sort_keys[0] != null) {
                        mainSortLDAP = sort_keys[0].getKey();
                    }
                }
                ret_attribs = this.xlateRetFields(ret_fields, etypes, mainSortLDAP);
                have_fields = false;
                if (ret_fields != null && ret_fields.size() > 0) {
                    have_fields = true;
                } else if (this._ret_db_attribs) {
                    ret_attribs = this._dbTrans.getDbAttributeList(etypes);
                    if (ret_attribs != null) {
                        Vector<String> tmp_ret_attribs = new Vector<String>(Arrays.asList(ret_attribs));
                        tmp_ret_attribs.add("objectclass");
                        ret_attribs = tmp_ret_attribs.toArray(new String[0]);
                    } else {
                        Logging.trace((int)1, (String)"attribs null");
                    }
                }
                ldapConn = this.getLDAPConn();
                LDAPSearchConstraints cons = (LDAPSearchConstraints)ldapConn.getSearchConstraints().clone();
                LDAPProxiedAuthControl pcntrl = null;
                if (this._login_type.equalsIgnoreCase("PROXY")) {
                    pcntrl = new LDAPProxiedAuthControl(user_session.getDN(), true);
                }
                vcon = null;
                if (this_search_vlv) {
                    vcon = new LDAPVirtualListControl("A", 0, 2);
                } else {
                    cons.setMaxResults(this._lookthru_limit);
                }
                LDAPControl[] controls = null;
                if (vcon != null && pcntrl != null) {
                    controls = new LDAPControl[3];
                    controls[1] = pcntrl;
                    controls[2] = vcon;
                } else if (vcon != null || pcntrl != null) {
                    controls = new LDAPControl[2];
                    controls[1] = vcon != null ? vcon : pcntrl;
                } else {
                    controls = new LDAPControl[]{sorter};
                }
                cons.setServerControls(controls);
                String[] this_rets = new String[]{new String("objectclass")};
                entrycount = 0;
                try {
                    LDAPSearchResults sres = ldapConn.search(search_base, 2, filter, this_rets, false, cons);
                    if (this_search_vlv) {
                        c = ldapConn.getResponseControls();
                        if (c == null) {
                            throw new piDbException(24);
                        }
                        vrcon = null;
                        break block32;
                    }
                    while (sres.hasMoreElements()) {
                        LDAPEntry entry = sres.next();
                        ++entrycount;
                    }
                    break block33;
                }
                catch (LDAPException ex) {
                    this.closeLdapConn(ldapConn);
                    if (ex.getLDAPResultCode() == 85) {
                        throw new piDbException(29, ex.toString());
                    }
                    throw new piDbException(15, ex.toString());
                }
            }
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof LDAPVirtualListResponse)) continue;
                vrcon = (LDAPVirtualListResponse)c[i];
                break;
            }
            if (vrcon == null) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(24);
            }
            entrycount = vrcon.getContentCount();
        }
        this.closeLdapConn(ldapConn);
        return new iLdapSearch(entries_per_page, search_base, filter, ret_attribs, have_fields, sort_keys, user_session, entrycount, main_sort_xml, vcon, this_search_vlv, this._dbTrans, this);
    }

    public void getEntry(UserSession user_session, String search_base_url, String entry_id, Element resElt, int flags) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + " " + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        if ((search_base == null || search_base != null && search_base.length() == 0) && (search_base = user_session.getDN()) == null) {
            throw new piDbException(16, search_base_url);
        }
        if (resElt == null) {
            throw new piDbException(28, "searchBook: no resElt");
        }
        Document resultTree = resElt.getOwnerDocument();
        if (resultTree == null) {
            throw new piDbException(28, "searchBook: resElt not attached to any doc");
        }
        String[] ret_attribs = null;
        if (this._ret_db_attribs) {
            ret_attribs = this._dbTrans.getAllDbAttributeList();
            Vector<String> tmp_ret_attribs = new Vector<String>(Arrays.asList(ret_attribs));
            tmp_ret_attribs.add("objectclass");
            ret_attribs = tmp_ret_attribs.toArray(new String[0]);
        }
        LDAPConnection ldapConn = this.getLDAPConn();
        LDAPSearchConstraints cons = (LDAPSearchConstraints)ldapConn.getSearchConstraints().clone();
        cons.setMaxResults(this._lookthru_limit);
        if (this._login_type.equalsIgnoreCase("PROXY")) {
            LDAPProxiedAuthControl cntrl = new LDAPProxiedAuthControl(user_session.getDN(), true);
            cons.setServerControls((LDAPControl)cntrl);
        }
        String entry_str = new String(this._entry_id_type + '=' + entry_id);
        try {
            LDAPSearchResults res = ldapConn.search(search_base, 2, entry_str, ret_attribs, false, cons);
            if (res.getCount() == 0) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(17, "invalid EntryID = " + entry_id);
            }
            if (res.getCount() > 1) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(18, entry_id);
            }
            LDAPEntry entry = res.next();
            LDAP2XMLTranslatable dbEntry = new LDAP2XMLTranslatable(entry);
            try {
                this._dbTrans.translate((DbTranslatable)dbEntry, resElt);
            }
            catch (DbTransException de) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(22, "Translate failed:" + de.toString());
            }
        }
        catch (LDAPException ex) {
            this.closeLdapConn(ldapConn);
            if (ex.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entry_id);
            }
            if (ex.getLDAPResultCode() == 85) {
                throw new piDbException(29, ex.toString());
            }
            throw new piDbException(15, ex.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    public void openUserStore(UserSession user_session, Element ps_base, String psRootURL, int flags) throws piDbException {
        boolean nostore = false;
        if (psRootURL == null) {
            throw new piDbException(16);
        }
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(psRootURL);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, psRootURL);
        }
        String entry_dn = ldapurl.getDN();
        LDAPConnection ldapConn = this.getLDAPConn();
        LDAPEntry base_entry = null;
        try {
            base_entry = ldapConn.read(entry_dn);
        }
        catch (LDAPException ex) {
            this.closeLdapConn(ldapConn);
            if (ex.getLDAPResultCode() == 32) {
                nostore = true;
            }
            if (ex.getLDAPResultCode() == 85) {
                throw new piDbException(29, ex.toString());
            }
            throw new piDbException(15, ex.toString());
        }
        this.closeLdapConn(ldapConn);
        if (nostore) {
            if (flags == 1 && ps_base == null) {
                throw new piDbException(40);
            }
            DN dn = new DN(entry_dn);
            String[] exploded_dn = dn.explodeDN(false);
            if (exploded_dn == null) {
                throw new piDbException(16, entry_dn);
            }
            String partial_dn = exploded_dn[exploded_dn.length - 1];
            ldapConn = this.getLDAPConn();
            for (int i = exploded_dn.length - 1; i > 0; --i) {
                Logging.trace((int)1, (String)("trying patial dn: " + partial_dn));
                boolean add = false;
                String[] attrs = new String[]{new String("objectclass")};
                try {
                    ldapConn.read(partial_dn, attrs);
                }
                catch (LDAPException ex) {
                    this.closeLdapConn(ldapConn);
                    if (ex.getLDAPResultCode() == 32) {
                        add = true;
                    }
                    if (ex.getLDAPResultCode() == 85) {
                        throw new piDbException(29, ex.toString());
                    }
                    throw new piDbException(15, ex.toString());
                }
                if (add) {
                    String componentName;
                    int indx = exploded_dn[i].indexOf(61);
                    if (indx <= 0) {
                        this.closeLdapConn(ldapConn);
                        throw new piDbException(16, "no = sign in dn:" + entry_dn);
                    }
                    String objName = componentName = exploded_dn[i].substring(0, indx);
                    if (componentName.equalsIgnoreCase("o")) {
                        objName = "organization";
                    } else if (componentName.equalsIgnoreCase("ou")) {
                        objName = "organizationalunit";
                    }
                    LDAPAttribute[] ldap_attrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", objName), new LDAPAttribute(componentName, exploded_dn[i].substring(indx + 1))};
                    LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
                    LDAPEntry entry = new LDAPEntry(partial_dn, attr_set);
                    try {
                        ldapConn.add(entry);
                    }
                    catch (LDAPException l) {
                        this.closeLdapConn(ldapConn);
                        if (l.getLDAPResultCode() == 85) {
                            throw new piDbException(29, l.toString());
                        }
                        throw new piDbException(15, " Unable to add dn: " + partial_dn + ". " + l.toString());
                    }
                }
                partial_dn = exploded_dn[i - 1] + ',' + partial_dn;
            }
            LDAPAttribute[] ldap_attrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", "piPStoreRoot"), new LDAPAttribute("piPStoreOwner", user_session.getUserId())};
            LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
            LDAPEntry entry = new LDAPEntry(entry_dn, attr_set);
            try {
                ldapConn.add(entry);
            }
            catch (LDAPException l) {
                this.closeLdapConn(ldapConn);
                if (l.getLDAPResultCode() == 85) {
                    throw new piDbException(29, l.toString());
                }
                throw new piDbException(15, l.toString());
            }
            this.closeLdapConn(ldapConn);
            this.syncStore(user_session, ps_base, psRootURL);
        } else {
            boolean is_abs = false;
            LDAPAttribute base_ocs = base_entry.getAttribute("objectclass");
            Enumeration oc_vals = base_ocs.getStringValues();
            while (oc_vals.hasMoreElements()) {
                String oc_val = (String)oc_vals.nextElement();
                if (!oc_val.equalsIgnoreCase("piPStoreRoot")) continue;
                is_abs = true;
            }
            if (!is_abs) {
                throw new piDbException(43);
            }
        }
    }

    public void syncStore(UserSession user_session, Element ps_base, String psRootURL) throws piDbException {
        HashMap<String, String> member_ids = new HashMap<String, String>();
        Node ps_entry = null;
        if (ps_base != null) {
            try {
                Document tmpDoc = _domBuilder.newDocument();
                Node tmpElt = _domBuilder.copyNode((Node)ps_base, tmpDoc);
                ps_entry = (Element)tmpElt.getFirstChild();
            }
            catch (XMLProcessingException xpe) {
                throw new piDbException(20, "openUserSt: cant create xml:" + xpe.getMessage());
            }
        }
        while (ps_entry != null) {
            if (!ps_entry.getNodeName().equals("book")) {
                ArrayList found_nodes = new ArrayList(4);
                try {
                    XPathTools.getNodesByXPath((Node)ps_entry, (String)"memberofbook", found_nodes);
                    XPathTools.getNodesByXPath((Node)ps_entry, (String)"memberofgroup", found_nodes);
                }
                catch (XSLProcessingException xpe) {
                    throw new piDbException(20, xpe.toString());
                }
                for (int i = 0; i < found_nodes.size(); ++i) {
                    Node value_node;
                    Node found_node = (Node)found_nodes.get(i);
                    String member_val = null;
                    for (value_node = found_node.getFirstChild(); value_node != null && value_node.getNodeType() != 3; value_node = value_node.getNextSibling()) {
                    }
                    if (value_node == null) {
                        throw new piDbException(41, "empty memberofbook");
                    }
                    member_val = value_node.getNodeValue();
                    if (member_ids.isEmpty()) {
                        throw new piDbException(41, "No book defined before");
                    }
                    String replacement = (String)member_ids.get(member_val);
                    if (replacement == null) {
                        throw new piDbException(41, "memberofbook not matching any book");
                    }
                    value_node.setNodeValue(replacement);
                }
                Node membook = null;
                try {
                    membook = XPathTools.getFirstNodeByXPath((Node)ps_entry, (String)"memberofbook");
                }
                catch (XSLProcessingException x) {
                    throw new piDbException(20, x.toString());
                }
                if (membook == null) {
                    throw new piDbException(42);
                }
            }
            String entryid = this.addEntry(user_session, psRootURL, (Element)ps_entry, 0);
            String entry_type = ps_entry.getNodeName();
            if (entry_type.equals("book") || entry_type.equals("group")) {
                String fake_id = null;
                try {
                    fake_id = XPathTools.getValueByXPath((Node)ps_entry, (String)"entry/displayname");
                }
                catch (XSLProcessingException x) {
                    throw new piDbException(20, x.toString());
                }
                if (fake_id != null) {
                    member_ids.put(fake_id, entryid);
                }
            }
            ps_entry = (Element)ps_entry.getNextSibling();
        }
    }

    public int getEntriesCount(String search_base) throws piDbException {
        String aVal = "1";
        int intvalue = 0;
        LDAPConnection ld = null;
        LDAPEntry findEntry = null;
        LDAPSearchResults res = null;
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base + " " + ex.getMessage());
        }
        String entrydn = ldapurl.getDN();
        try {
            ld = this.getLDAPConn();
            String[] attrNames = new String[]{"numSubordinates"};
            res = ld.search(entrydn, 0, "(objectclass=*)", attrNames, false);
            int count = res.getCount();
            if (count != 1) {
                this.closeLdapConn(ld);
                if (count == 0) {
                    throw new piDbException(17, "getEntriesCount: invalid base = " + entrydn);
                }
                throw new piDbException(18, "getEntriesCount: invalid base = " + entrydn);
            }
            findEntry = res.next();
            LDAPAttribute anAttr = findEntry.getAttribute("numSubordinates");
            Enumeration enumVals = anAttr.getStringValues();
            aVal = (String)enumVals.nextElement();
            intvalue = Integer.valueOf(aVal);
        }
        catch (LDAPException e) {
            this.closeLdapConn(ld);
            if (e.getLDAPResultCode() == 85) {
                throw new piDbException(29, e.toString());
            }
            throw new piDbException(15, e.toString());
        }
        this.closeLdapConn(ld);
        return intvalue;
    }

    public String addEntry(UserSession user_session, String search_base_url, Element abEntry, int flags) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + " " + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        String entry_id = this.getEntryID();
        String entry_dn = new String(this._entry_id_type + "=" + entry_id + ',' + search_base);
        ArrayList<LDAPAttribute> ldapAttrs = new ArrayList<LDAPAttribute>();
        XML2LDAPTranslatable dbEntry = new XML2LDAPTranslatable(ldapAttrs, this._skipAttrs);
        try {
            this._dbTrans.reverseTranslate(abEntry, (XML2DbTranslatable)dbEntry);
        }
        catch (DbTransException dte) {
            throw new piDbException(5, dte.getMessage());
        }
        if (ldapAttrs.size() == 0) {
            throw new piDbException(25);
        }
        LDAPAttribute eid_attr = new LDAPAttribute(this._entry_id_type, entry_id);
        ldapAttrs.add(eid_attr);
        LDAPAttribute[] ldap_attrs = ldapAttrs.toArray(new LDAPAttribute[ldapAttrs.size()]);
        LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
        LDAPEntry entry = new LDAPEntry(entry_dn, attr_set);
        LDAPConnection ldapConn = this.getLDAPConn();
        try {
            ldapConn.add(entry);
        }
        catch (LDAPException l) {
            this.closeLdapConn(ldapConn);
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(15, l.toString());
        }
        this.closeLdapConn(ldapConn);
        return entry_id;
    }

    public void modifyEntry(UserSession user_session, String search_base_url, String entryID, Element abEntry, int flags) throws piDbException {
        LDAPAttribute old_attr;
        LDAPAttribute e_attr;
        int i;
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + " " + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        String entry_dn = new String(this._entry_id_type + "=" + entryID + ',' + search_base);
        LDAPConnection ldapConn = this.getLDAPConn();
        LDAPEntry old_entry = null;
        try {
            old_entry = ldapConn.read(entry_dn);
        }
        catch (LDAPException x) {
            this.closeLdapConn(ldapConn);
            if (x.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (x.getLDAPResultCode() == 85) {
                throw new piDbException(29, x.toString());
            }
            throw new piDbException(15, x.toString());
        }
        ArrayList ldapModAttrs = new ArrayList();
        ArrayList ldapRemoveAttrs = new ArrayList();
        XML2LDAPTranslatable dbEntry = new XML2LDAPTranslatable(ldapModAttrs, ldapRemoveAttrs, this._skipAttrs);
        try {
            this._dbTrans.reverseTranslate(abEntry, (XML2DbTranslatable)dbEntry);
        }
        catch (DbTransException dte) {
            this.closeLdapConn(ldapConn);
            throw new piDbException(5, "Modify entry: reverseTranslate failed: " + dte.getMessage());
        }
        if (ldapModAttrs.size() == 0 && ldapRemoveAttrs.size() == 0) {
            this.closeLdapConn(ldapConn);
            throw new piDbException(25, "modifyEntry: no data to modify");
        }
        LDAPModificationSet mod_set = new LDAPModificationSet();
        for (i = ldapModAttrs.size() - 1; i >= 0; --i) {
            e_attr = (LDAPAttribute)ldapModAttrs.get(i);
            if (e_attr.size() == 0) {
                old_attr = old_entry.getAttribute(e_attr.getName());
                if (old_attr == null) continue;
                mod_set.add(1, old_attr);
                continue;
            }
            old_attr = old_entry.getAttribute(e_attr.getName());
            if (old_attr != null) {
                mod_set.add(2, e_attr);
                continue;
            }
            mod_set.add(0, e_attr);
        }
        for (i = ldapRemoveAttrs.size() - 1; i >= 0; --i) {
            e_attr = (LDAPAttribute)ldapRemoveAttrs.get(i);
            old_attr = old_entry.getAttribute(e_attr.getName());
            if (old_attr == null) continue;
            mod_set.add(1, old_attr);
        }
        try {
            ldapConn.modify(entry_dn, mod_set);
        }
        catch (LDAPException l) {
            this.closeLdapConn(ldapConn);
            if (l.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(15, l.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    public void deleteEntry(UserSession user_session, String search_base_url, String entryID, int flags) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + " " + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        Logging.trace((int)1, (String)("Deleting LDAP entry: " + entryID));
        String entry_dn = new String(this._entry_id_type + "=" + entryID + ',' + search_base);
        LDAPConnection ldapConn = this.getLDAPConn();
        try {
            ldapConn.delete(entry_dn);
        }
        catch (LDAPException x) {
            this.closeLdapConn(ldapConn);
            if (x.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (x.getLDAPResultCode() == 85) {
                throw new piDbException(29, x.toString());
            }
            throw new piDbException(15, x.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    private void removeUselessEntryTypes(ArrayList entry_types) throws piDbException {
        int i = 0;
        while (i < entry_types.size()) {
            if (this._dbTrans.getDbTypeForXMLType((String)entry_types.get(i)) == null) {
                entry_types.remove(i);
                continue;
            }
            ++i;
        }
        if (entry_types.size() <= 0) {
            throw new piDbException(26);
        }
    }

    protected LDAPConnection getLDAPConn() throws piDbException {
        LDAPConnection ldapConn = null;
        try {
            ldapConn = this._ldapConnPool.getConnection();
        }
        catch (LDAPException ex) {
            throw new piDbException(12, ex.getMessage());
        }
        if (ldapConn == null) {
            throw new piDbException(12, "request for a connection from pool time out");
        }
        return ldapConn;
    }

    protected void closeLdapConn(LDAPConnection ldapConn) {
        this._ldapConnPool.close(ldapConn);
    }

    private String xlateSearchFilter(String search_filter, ArrayList entry_types, boolean is_vlv) throws piDbException {
        String ret_str;
        block31: {
            int level = 0;
            boolean[] action_and = new boolean[10];
            action_and[0] = false;
            int end_index = 0;
            ret_str = new String(search_filter);
            String parse_str = new String(search_filter);
            while (true) {
                char char_at;
                if ((char_at = parse_str.charAt(0)) == '(') {
                    ++level;
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == '&') {
                    action_and[level] = true;
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == '|' || char_at == '!') {
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == ')') {
                    if (action_and[level]) {
                        // empty if block
                    }
                    parse_str = parse_str.substring(1);
                    if (--level < 0) {
                        throw new piDbException(11, search_filter);
                    }
                    if (level != 0 || parse_str.length() != 0) continue;
                    break block31;
                }
                String field = null;
                boolean breakout = false;
                String rest_of_expr = null;
                end_index = parse_str.indexOf("=");
                int alt_end = -1;
                int tempCount = 0;
                for (tempCount = 0; tempCount < parse_str.length(); ++tempCount) {
                    if (parse_str.charAt(tempCount) != ')' || parse_str.charAt(tempCount - 1) == '\\') continue;
                    alt_end = tempCount;
                    break;
                }
                if (parse_str.charAt(0) == '[') {
                    int xend = parse_str.indexOf("]");
                    String tmp_str = parse_str.substring(xend);
                    end_index = tmp_str.indexOf("=");
                }
                if (end_index > 0) {
                    if (parse_str.charAt(end_index - 1) == '>' || parse_str.charAt(end_index - 1) == '<' || parse_str.charAt(end_index - 1) == '~') {
                        --end_index;
                    }
                    field = parse_str.substring(0, end_index);
                    rest_of_expr = alt_end < 0 ? parse_str.substring(end_index, parse_str.length()) : parse_str.substring(end_index, alt_end);
                }
                if (alt_end < 0) {
                    breakout = true;
                    if (end_index < 0) {
                        end_index = parse_str.length();
                        field = parse_str.substring(0, end_index);
                    }
                } else if (alt_end < end_index || end_index < 0) {
                    rest_of_expr = null;
                    end_index = alt_end;
                    field = parse_str.substring(0, end_index);
                }
                if (alt_end > 0) {
                    parse_str = parse_str.substring(alt_end);
                }
                if (field != null && field.length() > 0) {
                    ArrayList rep_fields = null;
                    try {
                        rep_fields = this._dbTrans.xlateXPathField(field, false, entry_types);
                    }
                    catch (DbTransException dtx) {
                        throw new piDbException(19, "error while prcessing field: " + field + ":" + dtx.toString());
                    }
                    if (rep_fields == null || rep_fields.size() == 0) {
                        throw new piDbException(19, "error while prcessing field: " + field + "(no translation)");
                    }
                    if (rep_fields.size() == 1) {
                        ret_str = ret_str.substring(0, ret_str.indexOf(field)) + rep_fields.get(0) + ret_str.substring(ret_str.indexOf(field) + field.length());
                    } else {
                        int tmpint = ret_str.indexOf(field);
                        String tmp_str = ret_str.substring(0, tmpint) + '|';
                        ArrayList<String> old_str = new ArrayList<String>();
                        int nbFilters = 0;
                        for (int i = 0; i < rep_fields.size(); ++i) {
                            if (old_str.indexOf((String)rep_fields.get(i)) == -1) {
                                tmp_str = tmp_str + '(' + rep_fields.get(i) + rest_of_expr + ')';
                                ++nbFilters;
                            }
                            old_str.add((String)rep_fields.get(i));
                        }
                        if (nbFilters <= 1) {
                            tmp_str = tmp_str.substring(0, tmpint) + tmp_str.substring(tmpint + 2, tmp_str.length() - 1);
                        }
                        ret_str = tmp_str + ret_str.substring(ret_str.indexOf(field) + field.length() + rest_of_expr.length());
                    }
                }
                if (breakout) break;
            }
            if (level != 0) {
                throw new piDbException(11, search_filter);
            }
            if (!action_and[0]) {
                // empty if block
            }
        }
        if (is_vlv) {
            return ret_str;
        }
        String tmp_str = null;
        if (entry_types.size() == 1) {
            tmp_str = "objectclass=" + this._dbTrans.getDbTypeForXMLType((String)entry_types.get(0));
        } else {
            tmp_str = "|";
            for (int i = 0; i < entry_types.size(); ++i) {
                tmp_str = tmp_str + '(' + "objectclass=" + this._dbTrans.getDbTypeForXMLType((String)entry_types.get(i)) + ')';
            }
        }
        ret_str = ret_str == null ? tmp_str : "&(" + ret_str + ")(" + tmp_str + ')';
        return ret_str;
    }

    LDAPSortControl xlateSortbyFields(Vector sortby_fields, LDAPSortKey[] sort_keys, ArrayList entryTypes) throws piDbException {
        int sortby_count = sortby_fields.size();
        for (int s = 0; s < sortby_count; ++s) {
            boolean reverse = false;
            String sortby = (String)sortby_fields.get(s);
            if (sortby.charAt(0) == '-') {
                sortby = sortby.substring(1);
                reverse = true;
            } else if (sortby.charAt(0) == '+') {
                sortby = sortby.substring(1);
            }
            ArrayList sortByAttrs = null;
            try {
                sortByAttrs = this._dbTrans.xlateXPathField(sortby, false, entryTypes);
            }
            catch (DbTransException dtx) {
                throw new piDbException(19, "error while prcessing field: " + sortby + ":" + dtx.toString());
            }
            if (sortByAttrs == null || sortByAttrs.size() == 0) {
                throw new piDbException(19, "error while prcessing field: " + sortby + "(no translation)");
            }
            sort_keys[s] = new LDAPSortKey((String)sortByAttrs.get(0), reverse);
        }
        LDAPSortControl ret = new LDAPSortControl(sort_keys, true);
        return ret;
    }

    private String[] xlateRetFields(Vector ret_fields, ArrayList entryTypes, String sortAttr) throws piDbException {
        String[] ret_attribs = null;
        ArrayList<String> ret_LDAP_attrs = null;
        if (ret_fields != null && ret_fields.size() != 0) {
            int ret_count = ret_fields.size();
            ret_LDAP_attrs = new ArrayList<String>(10);
            if (sortAttr != null) {
                ret_LDAP_attrs.add(sortAttr);
            }
            for (int rc = 0; rc < ret_count; ++rc) {
                try {
                    this._dbTrans.xlateXPathField((String)ret_fields.get(rc), true, entryTypes, ret_LDAP_attrs);
                    continue;
                }
                catch (DbTransException dx) {
                    throw new piDbException(20, dx.toString());
                }
            }
            ret_LDAP_attrs.add("objectclass");
            int size = ret_LDAP_attrs.size();
            ret_attribs = new String[size];
            ret_LDAP_attrs.toArray(ret_attribs);
        }
        return ret_attribs;
    }

    private synchronized String getEntryID() {
        Date date = new Date();
        return "e" + Long.toHexString(date.getTime()) + Integer.toHexString(this._idCount++);
    }

    public static void dump(Node node, int depth) {
        if (2 == node.getNodeType()) {
            String value = node.getNodeValue();
            Logging.trace((int)32, (String)("node:(" + depth + ")Attr> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ") [" + value + "]"));
        } else {
            Node n;
            int i;
            Logging.trace((int)32, (String)("node:(" + depth + ")Name> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ")"));
            Logging.trace((int)32, (String)("node:(" + depth + ")Class> " + node.getClass().getName() + " Type > " + node.getNodeType()));
            String value = node.getNodeValue();
            if (null != value) {
                Logging.trace((int)32, (String)("node:(" + depth + ")Value> " + value));
            }
            if (node.hasAttributes()) {
                NamedNodeMap map = node.getAttributes();
                for (i = 0; i < map.getLength(); ++i) {
                    n = map.item(i);
                    iLdapDb.dump(n, depth + 2);
                }
            }
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                for (i = 0; i < nl.getLength(); ++i) {
                    n = nl.item(i);
                    iLdapDb.dump(n, depth + 1);
                }
            }
        }
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xpe) {
            Logging.error((int)1, (String)("Cant create XMLDOMBuilder: " + xpe.getMessage()));
        }
    }
}

