/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.importexport.ImportedABParser;
import com.iplanet.xslui.tools.PropertyReader;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImportProperties {
    private Hashtable _importTable;

    public ImportProperties(File file) throws Exception {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file, "import.properties");
        }
        catch (Exception exception) {
            throw new Exception("ImportProperties.constructor: can't open configuration file at " + file.toString() + " : " + exception.getMessage());
        }
        if (propertyReader == null) {
            throw new Exception("ImportHandler.init: could'nt create a property reader with path :" + file.toString());
        }
        this._importTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty("import.", ".class");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.loadParser(propertyReader, string)) continue;
            throw new Exception("ImportHandler.init: can't load parser " + string);
        }
    }

    public ImportedABParser getParser(String string) {
        Hashtable hashtable = (Hashtable)this._importTable.get(string);
        if (hashtable == null) {
            return null;
        }
        ImportedABParser importedABParser = (ImportedABParser)hashtable.get(".class");
        return importedABParser;
    }

    public String getXlate(String string) {
        Hashtable hashtable = (Hashtable)this._importTable.get(string);
        if (hashtable == null) {
            return null;
        }
        String string2 = (String)hashtable.get(".xlatePath");
        return string2;
    }

    public String getEncoding(String string) {
        Hashtable hashtable = (Hashtable)this._importTable.get(string);
        if (hashtable == null) {
            return null;
        }
        String string2 = (String)hashtable.get(".encoding");
        return string2;
    }

    private boolean loadParser(PropertyReader propertyReader, String string) throws Exception {
        ImportedABParser importedABParser = null;
        Hashtable<String, Object> hashtable = null;
        String string2 = null;
        String string3 = null;
        hashtable = (Hashtable<String, Object>)this._importTable.get(string);
        if (hashtable != null) {
            importedABParser = (ImportedABParser)hashtable.get(".class");
            string2 = (String)hashtable.get(".xlatePath");
            if (importedABParser != null || string2 != null) {
                return true;
            }
        } else {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            importedABParser = (ImportedABParser)propertyReader.getObjectProperty("import." + string, true);
            string2 = propertyReader.getStringProperty("import." + string + ".xlatePath", null);
            string3 = propertyReader.getStringProperty("import." + string + ".encoding", null);
        }
        catch (Exception exception) {
            return false;
        }
        hashtable.put(".class", importedABParser);
        hashtable.put(".xlatePath", string2);
        hashtable.put(".encoding", string3);
        this._importTable.put(string, hashtable);
        return true;
    }
}

