/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.iabs.importexport.ImportProperties;
import com.iplanet.iabs.importexport.ImportTranslatableEntry;
import com.iplanet.iabs.importexport.ImportedABParser;
import com.iplanet.iabs.ldapplug.XML2LDAPTranslatable;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.dbtrans.TwoWayDbTranslation;
import com.iplanet.xslui.dbtrans.XML2DbTranslatable;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.LDIFWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportExport {
    private static ImportExport instance;
    private ImportProperties _importProperties;
    private DbTranslation _dbTranslator;
    private XSLXMLLogHandler _logHandler;
    TwoWayDbTranslation _exportdbTranslator = null;
    private XSLXMLCache _xslxmlCache = null;
    private String xslconfigpath;
    private File _configRoot;

    public static synchronized ImportExport getInstance(File file, XSLXMLLogHandler xSLXMLLogHandler) throws IOException {
        if (instance == null) {
            instance = new ImportExport(file, xSLXMLLogHandler);
        }
        return instance;
    }

    public ImportExport(File file, XSLXMLLogHandler xSLXMLLogHandler) throws IOException {
        this._configRoot = file;
        this._logHandler = xSLXMLLogHandler;
        try {
            File file2;
            File file3 = new File(file, "import");
            if (file3 == null) {
                this._logHandler.error("importexport: Config path null");
                return;
            }
            this._importProperties = new ImportProperties(file3);
            String string = new String(file.getName());
            string = string + "/import";
            File file4 = new File(file, "import");
            if (file4 != null) {
                this._dbTranslator = new DbTranslation(file4);
            }
            if ((file2 = new File(file, "export")) != null) {
                this._exportdbTranslator = new TwoWayDbTranslation(file2);
                this.xslconfigpath = file2.getPath() + "/";
            }
            this._xslxmlCache = new XSLXMLCache(false, this._logHandler);
        }
        catch (Exception exception) {
            this._logHandler.error("ImportExport: " + exception.getMessage());
            if (exception instanceof FileNotFoundException) {
                throw new IOException("importexport: import.properties not found in " + file.getPath());
            }
            if (exception instanceof IOException || exception instanceof DbTransException) {
                throw new IOException("importexport: " + exception.getMessage());
            }
            if (exception instanceof XMLProcessingException) {
                throw new IOException("importExport: Couldn't create XMLDOMBuilder: " + exception.getMessage());
            }
            throw new IOException("importExport: " + exception.getMessage());
        }
    }

    public void importEntry(PersonalStore personalStore, String string, String string2, InputStream inputStream, Element element) throws PStoreException, IOException {
        int n;
        boolean bl;
        int n2;
        int n3;
        block35: {
            n3 = 0;
            n2 = 0;
            bl = false;
            String[] stringArray = new String[]{string};
            Element element2 = null;
            String string3 = null;
            ImportTranslatableEntry importTranslatableEntry = null;
            Hashtable hashtable = new Hashtable();
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            n = 0;
            if (inputStream == null) {
                throw new PStoreException(2, "import: Import file input is invalid");
            }
            inputStream.mark(10000000);
            if (personalStore == null) {
                throw new PStoreException(1, "import: Unable to access personal store");
            }
            ImportedABParser importedABParser = this._importProperties.getParser(string2);
            if (importedABParser == null) {
                throw new PStoreException(20, "import: No parser corresponding to " + string2);
            }
            String string4 = this._importProperties.getXlate(string2);
            if (string4 == null || string4.length() == 0) {
                throw new PStoreException(20, "import: No translation file loaded for :" + string2);
            }
            String string5 = this._importProperties.getEncoding(string2);
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                importedABParser.loadFile(inputStream, string4, string5, hashtable);
                block11: while (true) {
                    try {
                        while ((importTranslatableEntry = importedABParser.getNextEntry()) != null) {
                            try {
                                element2 = this._dbTranslator.translate((DbTranslatable)importTranslatableEntry);
                                if (element2 != null) {
                                    string3 = XPathTools.getValueByXPath((Node)element2, (String)"entry/displayname");
                                }
                            }
                            catch (DbTransException dbTransException) {
                                this._logHandler.error("import: corrupted entry - " + dbTransException.getMessage());
                            }
                            catch (XSLProcessingException xSLProcessingException) {
                                this._logHandler.error("import: Last entry had no displayname " + xSLProcessingException.getMessage());
                            }
                            object4 = null;
                            if (string3 != null && string3.length() > 0) {
                                block34: {
                                    try {
                                        object4 = personalStore.addEntry(stringArray, element2);
                                        ++n3;
                                    }
                                    catch (PStoreException pStoreException) {
                                        this._logHandler.error("import: Can not add entry into personal store: " + pStoreException.getMessage());
                                        ++n;
                                        if (pStoreException.getReason() != 17) break block34;
                                        bl = true;
                                        break block11;
                                    }
                                }
                                if (!importTranslatableEntry.getGroupStatus() || object4 == null) continue;
                                object3 = importTranslatableEntry.getGroupMembers();
                                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                                    object2 = (String)((ArrayList)object3).get(i);
                                    int n4 = ((String)object2).indexOf(",mail=");
                                    if (n4 > -1) {
                                        object2 = ((String)object2).substring(0, n4);
                                    }
                                    object2 = ((String)object2).substring(((String)object2).indexOf("=") + 1);
                                    object = new ArrayList();
                                    if (!hashtable2.isEmpty() && hashtable2.containsKey(object2)) {
                                        object = (ArrayList)hashtable2.get(object2);
                                    }
                                    if (((ArrayList)object).contains(object4)) continue;
                                    ((ArrayList)object).add(object4);
                                    hashtable2.put(object2, object);
                                }
                                continue block11;
                            }
                            this._logHandler.error("import: corrupted entry - no displayname can be obtained");
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        this._logHandler.error("import: corrupted entry - " + iOException.getMessage());
                        ++n2;
                        continue;
                    }
                    break;
                }
                Object object5 = object4 = hashtable2 != null ? hashtable2.keys() : null;
                if (!object4.hasMoreElements()) break block35;
                try {
                    XMLDOMBuilder xMLDOMBuilder = null;
                    xMLDOMBuilder = new XMLDOMBuilder();
                    object2 = xMLDOMBuilder.newDocument();
                    if (object2 == null) {
                        throw new PStoreException(20, "import: failed to create document");
                    }
                    object3 = object2.createElement("searchresult");
                    object2.appendChild((Node)object3);
                    Vector<String> vector = null;
                    vector = new Vector<String>(1);
                    vector.add("abperson");
                    object = new String[hashtable2.size()];
                    int n5 = 0;
                    String string6 = "|";
                    while (object4.hasMoreElements()) {
                        object[n5] = (String)object4.nextElement();
                        string6 = string6 + "(entry/displayname=" + object[n5++] + ")";
                    }
                    personalStore.searchBook(string, string6, null, vector, null, (Element)object3);
                    Document document = object3.getOwnerDocument();
                    NodeList nodeList = document.getElementsByTagName("abperson");
                    if (nodeList == null || nodeList != null && nodeList.getLength() == 0) {
                        this._logHandler.error("import - group membership updation failed: unable to fetch the entries");
                    }
                    for (n5 = 0; n5 < nodeList.getLength(); ++n5) {
                        Node node = nodeList.item(n5);
                        String string7 = XPathTools.getValueByXPath((Node)node, (String)"entry/@entryID");
                        String string8 = XPathTools.getValueByXPath((Node)node, (String)"entry/displayname");
                        ArrayList arrayList = (ArrayList)hashtable2.get(string8);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            personalStore.addGroupMember(string, (String)arrayList.get(i), string7);
                        }
                    }
                }
                catch (XMLProcessingException xMLProcessingException) {
                    throw new PStoreException(20, "import - group membership updation failed: " + xMLProcessingException.getMessage());
                }
            }
            catch (Exception exception) {
                element.setAttribute("errtype", "2");
                element.setAttribute("errnum", "271");
                element.setAttribute("nbimported", Integer.toString(n3));
                this._logHandler.error("import : problem reading an entry : " + exception.getMessage());
                return;
            }
        }
        if (n3 == 0 && n2 == 0 && n == 0) {
            element.setAttribute("errtype", "1");
            element.setAttribute("errnum", "272");
            element.setAttribute("nbimported", Integer.toString(n3));
            return;
        }
        if (n2 != 0) {
            element.setAttribute("errtype", "1");
            element.setAttribute("errnum", "64");
            element.setAttribute("nbbadentries", Integer.toString(n2));
        } else if (n > 0 || bl) {
            element.setAttribute("errtype", "1");
            element.setAttribute("errnum", "64");
            if (bl) {
                element.setAttribute("quotaexceedwhileimport", Integer.toString(n3 + n));
            }
            if (n > 0) {
                element.setAttribute("nbbadentries", Integer.toString(n));
            }
        } else {
            element.setAttribute("errtype", "0");
            element.setAttribute("errnum", "8");
        }
        element.setAttribute("nbimported", Integer.toString(n3));
    }

    public void exportEntry(PersonalStore personalStore, String string, String string2, String string3, String string4, OutputStream outputStream) throws PStoreException, IOException {
        Object object;
        Object object2;
        Element element;
        if (personalStore == null) {
            throw new PStoreException(1, "export: Unable to access personal store");
        }
        XMLDOMBuilder xMLDOMBuilder = null;
        Hashtable<LDAPEntry, ArrayList> hashtable = new Hashtable<LDAPEntry, ArrayList>();
        try {
            xMLDOMBuilder = new XMLDOMBuilder();
            Document document = xMLDOMBuilder.newDocument();
            if (document == null) {
                throw new PStoreException(20, "wabp/search_entry: failed to create document");
            }
            element = document.createElement("searchresult");
            document.appendChild(element);
            object2 = "+entry/displayname";
            object = null;
            if (object2 != null) {
                object = new Vector<String>();
                ((Vector)object).add("abperson");
                ((Vector)object).add("group");
            }
            personalStore.searchBook(string, string2, null, (Vector)object, (String)object2, element);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(20, "wabpc failed :" + xMLProcessingException.getMessage());
        }
        object2 = element.getOwnerDocument();
        if (!string3.equals("ldif")) {
            this.transformXMLdoc((Document)object2, outputStream, string3, string4);
        } else {
            Object object3;
            ArrayList arrayList;
            Object object4;
            Object object5;
            Node node;
            int n;
            object = object2.getElementsByTagName("abperson");
            if (object == null) {
                return;
            }
            if (object.getLength() == 0) {
                return;
            }
            for (n = 0; n < object.getLength(); ++n) {
                String string5;
                node = object.item(n);
                try {
                    object5 = XPathTools.getValuesByXPath((Node)node, (String)"memberofgroup");
                    object4 = XPathTools.getValueByXPath((Node)node, (String)"entry/displayname");
                    string5 = XPathTools.getValueByXPath((Node)node, (String)"email");
                    for (int i = 0; object5 != null && i < ((LDAPEntry)object5).length; ++i) {
                        arrayList = new ArrayList();
                        if (hashtable != null && hashtable.size() > 0 && hashtable.containsKey(object5[i])) {
                            arrayList = (ArrayList)hashtable.get(object5[i]);
                        }
                        object3 = "cn=" + (String)object4;
                        object3 = (String)object3 + (string5 == null ? "" : ",mail=" + string5);
                        arrayList.add(object3);
                        hashtable.put(object5[i], arrayList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object5 = this.doXML2LDAPtranslation((Element)object.item(n), null);
                object4 = new PrintWriter(outputStream, true);
                string5 = new LDIFWriter((PrintWriter)object4, false, ":", false, false);
                string5.printEntry(object5);
            }
            object = object2.getElementsByTagName("group");
            if (object == null || object != null && object.getLength() == 0) {
                return;
            }
            for (n = 0; n < object.getLength(); ++n) {
                node = object.item(n);
                object5 = new String();
                try {
                    object5 = XPathTools.getValueByXPath((Node)node, (String)"entry/@entryID");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object4 = (ArrayList)hashtable.get(object5);
                int n2 = 1;
                if (object4 != null && ((ArrayList)object4).size() > 0) {
                    n2 = 2;
                }
                LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[n2];
                lDAPAttributeArray[0] = new LDAPAttribute("objectclass", "groupOfNames");
                if (object4 != null && ((ArrayList)object4).size() > 0) {
                    lDAPAttributeArray[1] = new LDAPAttribute("member", ((ArrayList)object4).toArray(new String[((ArrayList)object4).size()]));
                }
                arrayList = this.doXML2LDAPtranslation((Element)node, lDAPAttributeArray);
                object3 = new PrintWriter(outputStream, true);
                LDIFWriter lDIFWriter = new LDIFWriter((PrintWriter)object3, false, ":", false, false);
                lDIFWriter.printEntry((LDAPEntry)arrayList);
            }
        }
    }

    private void transformXMLdoc(Document document, OutputStream outputStream, String string, String string2) throws PStoreException {
        String string3 = new String("export-") + string;
        if (string.equals("csv")) {
            string3 = string2 != null ? string3 + "-" + string2 : string3 + "-" + "us";
        }
        string3 = string3 + ".xsl";
        XSLProcessorPool xSLProcessorPool = null;
        String[] stringArray = new String[]{this.xslconfigpath};
        try {
            xSLProcessorPool = this._xslxmlCache.getXSLProcessorPool(string3, null, stringArray);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(20, "Couldn't get XSLProcessorPool : " + xMLProcessingException.getMessage());
        }
        if (xSLProcessorPool == null) {
            throw new PStoreException(20, "Couldn't get XSLProcessorPool");
        }
        try {
            xSLProcessorPool.process(document, outputStream, false);
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(20, "Couldn't parse xslfile : " + xSLProcessingException.getMessage());
        }
    }

    private LDAPEntry doXML2LDAPtranslation(Element element, LDAPAttribute[] lDAPAttributeArray) throws PStoreException {
        Object object;
        Object object2;
        Object object3;
        String string = new String("piEntryID=");
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName("entry");
        if (nodeList != null && nodeList.getLength() != 0) {
            object3 = nodeList.item(0);
            object2 = object3.getAttributes();
            object = object2.getNamedItem("entryID");
            string2 = object.getNodeValue();
        }
        string = string + string2;
        object3 = new ArrayList();
        object2 = null;
        object2 = new HashSet();
        ((HashSet)object2).add("piEntryID");
        ((HashSet)object2).add("memberOfPIBook");
        ((HashSet)object2).add("memberOfPIGroup");
        object = new XML2LDAPTranslatable((ArrayList)object3, (HashSet)object2);
        try {
            this._exportdbTranslator.reverseTranslate(element, (XML2DbTranslatable)object);
        }
        catch (DbTransException dbTransException) {
            throw new PStoreException(20, dbTransException.getMessage());
        }
        if (((ArrayList)object3).size() == 0) {
            throw new PStoreException(20);
        }
        int n = ((ArrayList)object3).size();
        LDAPAttribute[] lDAPAttributeArray2 = ((ArrayList)object3).toArray(new LDAPAttribute[n += lDAPAttributeArray == null ? 0 : lDAPAttributeArray.length]);
        for (int i = 0; lDAPAttributeArray != null && i < lDAPAttributeArray.length; ++i) {
            lDAPAttributeArray2[lDAPAttributeArray2.length - i - 1] = lDAPAttributeArray[i];
        }
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet(lDAPAttributeArray2);
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        return lDAPEntry;
    }
}

