/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.coresrv.DBPluginMap;
import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.importexport.ImportExport;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;

public class DBHandler {
    public static final String CONFIG_FILENAME = "personalstore.properties";
    public static final String CONFIG_DB_PREFIX = "db.";
    public static final String CONFIG_DB_PSROOT = "psrootattribute";
    public static final String CONFIG_DB_PSROOTPATTERN = "defaultpsrootpattern";
    public static final String CONFIG_DB_USEPSROOT = "useUserPsRoot";
    public static final String CONFIG_DB_PSURLPREFIX = "psurlprefix";
    public static final String CONFIG_DB_DEFAULTPSPATH = "defaultpspath";
    public static final String DEFAULT_PSTORE_FILENAME = "defaultps.xml";
    public static final String DEFAULT_PSTORE_DIC_PREFIX = "dictionary-";
    public static final String CONFIG_DB_MAXPAGEDSEARCH = "maxpagedsearch";
    private Hashtable _dbTable = null;
    private String _psRoot = null;
    private String _psRootPattern = null;
    private String _psURLPrefix = null;
    private XSLXMLCache _defaultPSXMLCache = null;
    private String _defaultPSPath = null;
    private int _maxPagedSearch = 10;
    private String _entryCache = "1";
    private int _quotaLimit = -1;
    private int _quotaWarnLimit = 100;
    private boolean _useUserPsRoot = false;

    public DBHandler(File file) throws PStoreException {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file, CONFIG_FILENAME);
        }
        catch (IOException iOException) {
            throw new PStoreException(1, "DBHandler: couldn't open configuration file at " + file.toString() + " : " + iOException.getMessage());
        }
        this._dbTable = new Hashtable();
        this._psRoot = propertyReader.getStringProperty("db.psrootattribute", "psRoot");
        this._useUserPsRoot = propertyReader.getBooleanProperty("db.useUserPsRoot", "false");
        this._psRootPattern = propertyReader.getStringProperty("db.defaultpsrootpattern", "");
        this._psURLPrefix = propertyReader.getStringProperty("db.psurlprefix", "ps");
        File file2 = propertyReader.getFileProperty("db.defaultpspath", "defaultps");
        this._defaultPSPath = file2.getAbsolutePath();
        this._defaultPSXMLCache = new XSLXMLCache(true, Logging.getLogHandler());
        this._maxPagedSearch = propertyReader.getIntProperty("db.maxpagedsearch", 10);
        this._entryCache = propertyReader.getStringProperty("store.cache.entrycount", "1");
        this._quotaLimit = propertyReader.getIntProperty("store.entries.limit", -1);
        this._quotaWarnLimit = propertyReader.getIntProperty("store.quotawarn", 100);
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_DB_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Logging.trace((int)32, (String)("Creating DBPluginMap for key:" + string));
            DBPluginMap dBPluginMap = null;
            try {
                dBPluginMap = new DBPluginMap(propertyReader, CONFIG_DB_PREFIX + string + ".");
            }
            catch (PStoreException pStoreException) {
                Logging.error((int)2, (String)("DBHandler:failed to load db plugin (config prefix = db." + string + ".) : " + pStoreException.getMessage()));
                continue;
            }
            catch (piDbException piDbException2) {
                Logging.error((int)2, (String)("DBHandler:failed to load db plugin (config prefix = db." + string + ".) : " + piDbException2.getMessage()));
                continue;
            }
            if (this._dbTable.get(dBPluginMap.getURLMatch()) != null) {
                Logging.error((int)32, (String)("DBHandler: duplicate urlMatch (ignoring): " + dBPluginMap.getURLMatch()));
                continue;
            }
            this._dbTable.put(dBPluginMap.getURLMatch(), dBPluginMap);
        }
    }

    public DBPlugin getDBFromURL(String string) throws PStoreException {
        DBPluginMap dBPluginMap = this.getDBPluginMapFromURL(string);
        if (dBPluginMap != null) {
            Logging.trace((int)32, (String)"dbPluginMap NOT null");
            return dBPluginMap.getDBPlugin(string);
        }
        Logging.trace((int)32, (String)"dbPluginMap null");
        return null;
    }

    public ImportExport getImportExportObj(File file) throws IOException {
        try {
            return ImportExport.getInstance(file, Logging.getLogHandler());
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public PS_DBPlugin getPSDBFromURL(String string) throws PStoreException {
        DBPluginMap dBPluginMap = this.getDBPluginMapFromURL(string);
        if (dBPluginMap != null) {
            return dBPluginMap.getPSDBPlugin(string);
        }
        return null;
    }

    public String getPsRootAttributeName() {
        return this._psRoot;
    }

    public String getDefaultPsRootPattern(UserSession userSession) {
        if (this._psRootPattern == null || this._psRootPattern.length() <= 0) {
            return null;
        }
        String string = userSession.getDomain();
        String string2 = StringUtils.replaceSubstring((String)this._psRootPattern, (String)"%U", (String)userSession.getUserId());
        if (this._psRootPattern.indexOf("%D") != -1) {
            string2 = StringUtils.replaceSubstring((String)string2, (String)"%D", (String)string);
        }
        if (this._psRootPattern.indexOf("%O") != -1) {
            String string3 = null;
            int n = string.lastIndexOf(".");
            string3 = n == -1 || n == 0 ? string : string.substring(0, n);
            string2 = StringUtils.replaceSubstring((String)string2, (String)"%O", (String)string3);
        }
        return string2;
    }

    public void setDefaultPsRootPattern(String string) {
        this._psRootPattern = string;
    }

    public String getDefaultPsRootPattern() {
        return this._psRootPattern;
    }

    public String getPsURLPrefix() {
        return this._psURLPrefix;
    }

    public Document getDefaultPS(UserSession userSession) {
        File file;
        String string = userSession.getDomain();
        String string2 = userSession.getPreferredLanguage();
        if (string2 == null || string2.length() <= 0) {
            string2 = "en";
        }
        if (!(file = new File(this._defaultPSPath)).exists()) {
            return null;
        }
        String[] stringArray = new String[]{this._defaultPSPath + "/"};
        Document document = null;
        try {
            document = this._defaultPSXMLCache.getXMLTemplateDocument(DEFAULT_PSTORE_FILENAME, DEFAULT_PSTORE_DIC_PREFIX + string2 + ".xml", stringArray);
        }
        catch (XMLProcessingException xMLProcessingException) {
            Logging.error((int)2, (String)("DBHandler:getDefaultPS cant get defaultps.xml in " + stringArray + " : " + xMLProcessingException.getMessage()));
            return null;
        }
        return document;
    }

    public DBPluginMap getDBPluginMapFromURL(String string) {
        Logging.trace((int)32, (String)("Entered DBHandler.getDBPluginMapFromURL(" + string + ")"));
        String string2 = null;
        Enumeration enumeration = this._dbTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Logging.trace((int)32, (String)("Evaluating " + string3 + " if matches with " + string));
            if (!string.toLowerCase().startsWith(string3) || string2 != null && string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        if (string2 == null) {
            Logging.error((int)32, (String)("DBHandler.getDBPluginMapFromURL: no match for:" + string));
            return null;
        }
        Logging.trace((int)32, (String)("Match found: " + string2));
        return (DBPluginMap)this._dbTable.get(string2);
    }

    public int getMaxPagedSearch() {
        return this._maxPagedSearch;
    }

    public void setMaxEntries(int n) {
        this._quotaLimit = n;
    }

    public int getQuotaWarnLimit() {
        return this._quotaWarnLimit;
    }

    public String getEntryCachePolicy() {
        return this._entryCache;
    }

    public int getEntriesLimit() {
        return this._quotaLimit;
    }

    public boolean useUserPsRoot() {
        return this._useUserPsRoot;
    }

    public Hashtable getDBPluginMaps() {
        return this._dbTable;
    }

    public String getDefaultPsRoot(UserSession userSession) throws PStoreException {
        Logging.trace((int)32, (String)"Inside DBHandler.getDefaultPsRoot() method");
        String string = this.getDefaultPsRootPattern(userSession);
        DBPluginMap dBPluginMap = this.getDBPluginMapFromURL(string);
        if (dBPluginMap == null) {
            Logging.error((int)32, (String)"DBPluginMap could not be found, hence default psRoot cannot be obtained ");
            return null;
        }
        try {
            Logging.trace((int)32, (String)"Got DBPluginMap");
            return dBPluginMap.getDefaultPsRoot(string);
        }
        catch (piDbException piDbException2) {
            throw new PStoreException(23);
        }
    }
}

