/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.ui.Logging;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoreSearchResult {
    private String _bookEntryID = null;
    private String _filter = null;
    private String _sortBy = null;
    private int _entriesPerPage = 0;
    private int _highestFirstEntry = 0;
    private int _nbTotal = 0;
    private boolean _randomPaging = false;
    private PagedSearch _pagedSearch = null;

    public CoreSearchResult(String string, String string2, String string3, int n, boolean bl, PagedSearch pagedSearch) throws PStoreException {
        this._pagedSearch = pagedSearch;
        this._bookEntryID = string;
        this._filter = string2;
        this._sortBy = string3;
        this._entriesPerPage = n;
        this._highestFirstEntry = 0;
        this._randomPaging = bl;
        this._nbTotal = pagedSearch.getTotalEntryCount();
    }

    public void getResult(int n, Element element) throws PStoreException {
        if (this._pagedSearch == null) {
            throw new PStoreException(3, "getResult failed: null psearch");
        }
        Document document = element.getOwnerDocument();
        if (this._entriesPerPage != 1 && n % this._entriesPerPage != 1) {
            throw new PStoreException(15, "getResult failed:firstentry/entriesperpage: " + n + "/" + this._entriesPerPage);
        }
        element.setAttribute("bookid", this._bookEntryID);
        element.setAttribute("filter", this._filter);
        element.setAttribute("sortby", this._sortBy);
        element.setAttribute("totalentries", String.valueOf(this._nbTotal));
        element.setAttribute("entriesperpage", String.valueOf(this._entriesPerPage));
        int n2 = 0;
        if (n <= this._nbTotal) {
            if (!this._randomPaging && n > this._highestFirstEntry + this._entriesPerPage) {
                this.getResult(n - this._entriesPerPage, document);
            }
            try {
                n2 = this._pagedSearch.getResult(n, 0, element);
            }
            catch (piDbException piDbException2) {
                if (piDbException2.getReason() == 29) {
                    throw new PStoreException(21, "getResult failed:" + piDbException2.getMessage());
                }
                throw new PStoreException(3, "getResult failed:" + piDbException2.getMessage());
            }
            this._highestFirstEntry = n;
        }
        if (n2 > 0) {
            element.setAttribute("firstentry", String.valueOf(n));
            element.setAttribute("lastentry", String.valueOf(n + n2 - 1));
        } else {
            element.setAttribute("firstentry", "0");
            element.setAttribute("lastentry", "0");
        }
        Logging.trace((int)32, (String)("getResult: nb entries found=" + n2));
    }

    public void stopSearch() throws PStoreException {
        if (this._pagedSearch == null) {
            throw new PStoreException(3, "getResult failed: null psearch");
        }
        try {
            this._pagedSearch.stopPagedSearch();
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "stopPagedSearch failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(3, "stopPagedSearch failed:" + piDbException2.getMessage());
        }
        this._pagedSearch = null;
    }

    private void getResult(int n, Document document) throws PStoreException {
        Element element = null;
        try {
            element = document.createElement("dummyElement");
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "getResult: Failed to create elt:" + dOMException.getMessage());
        }
        this.getResult(n, element);
    }
}

