/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.coresrv.CorePersonalStore;
import com.iplanet.iabs.coresrv.DBHandler;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.auth.ABUserSession;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import java.io.File;
import java.util.Hashtable;

public class CorePersonalStoreFactory
implements SessionObjectFactory {
    private File _configPath = null;
    private File _domainconfigPath = null;
    private Hashtable _perDomainDBTable;
    private static final transient String DEFAULT_DOMAIN = "default";
    private static final transient String ROOT_DOMAIN_PATH = "domain";

    public boolean init(File file) {
        try {
            this._perDomainDBTable = new Hashtable();
            this._configPath = file;
            this._domainconfigPath = file.getName().equals(".") ? file.getParentFile().getParentFile() : file.getParentFile();
            this._domainconfigPath = new File(this._domainconfigPath, ROOT_DOMAIN_PATH);
            DBHandler dBHandler = new DBHandler(this._domainconfigPath);
            if (dBHandler != null) {
                this._perDomainDBTable.put(DEFAULT_DOMAIN, dBHandler);
            }
        }
        catch (PStoreException pStoreException) {
            Logging.error((int)2, (String)("init:can't create DBHandler" + pStoreException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Logging.error((int)2, (String)("Error:init - " + exception.getMessage()));
            return false;
        }
        return true;
    }

    public Object newSessionObject(UserSession userSession, String string) {
        CorePersonalStore corePersonalStore = null;
        try {
            corePersonalStore = new CorePersonalStore(userSession, this.getDBHandler(string));
            corePersonalStore.init(this._configPath);
        }
        catch (PStoreException pStoreException) {
            Logging.error((int)32, (String)("newSessionObject:can't create: " + pStoreException.getMessage()));
            return null;
        }
        return corePersonalStore;
    }

    public DBHandler getDBHandler() {
        return this.getDBHandler(DEFAULT_DOMAIN);
    }

    public DBHandler getDBHandler(String string) {
        if (string == null) {
            return (DBHandler)this._perDomainDBTable.get(DEFAULT_DOMAIN);
        }
        if (this._perDomainDBTable.containsKey(string)) {
            return (DBHandler)this._perDomainDBTable.get(string);
        }
        File file = new File(this._domainconfigPath, string);
        try {
            DBHandler dBHandler = new DBHandler(file);
            if (dBHandler == null) {
                return null;
            }
            this._perDomainDBTable.put(string, dBHandler);
            Logging.trace((int)32, (String)("Obtained DBHandler for " + file.getName()));
            return dBHandler;
        }
        catch (PStoreException pStoreException) {
            Logging.trace((int)32, (String)("Warning:getDBHandler - " + pStoreException.getMessage()));
            Logging.trace((int)32, (String)"returning DBHandler for default");
            return (DBHandler)this._perDomainDBTable.get(DEFAULT_DOMAIN);
        }
    }

    public String getDefaultPsRoot(UserSession userSession) {
        Logging.trace((int)32, (String)"Inside CorePersonalStoreFactory.getDefaultPsRoot() method");
        String string = ((ABUserSession)userSession).getUserAttrib("domainname");
        DBHandler dBHandler = this.getDBHandler(string);
        if (dBHandler == null) {
            Logging.error((int)32, (String)"DBHandler could not be found, hence default psRoot cannot be obtained ");
            return null;
        }
        try {
            Logging.trace((int)32, (String)"Got DBHandler. Trying to get default psRoot from DBHandler");
            return dBHandler.getDefaultPsRoot(userSession);
        }
        catch (PStoreException pStoreException) {
            Logging.error((int)32, (String)("newSessionObject:can't create: " + pStoreException.getMessage()));
            return null;
        }
    }
}

