/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SmartList
implements List {
    private List originalList = null;
    private ThreadLocal listCopies = new ThreadLocal();

    private SmartList() {
    }

    public SmartList(List l) {
        this.originalList = l;
    }

    protected void copyIfNecessary() {
        ArrayList l = this.getCopiedList();
        if (l == null) {
            l = new ArrayList(this.originalList);
            this.listCopies.set(l);
        }
    }

    protected List getCopiedList() {
        List l = (List)this.listCopies.get();
        return l;
    }

    public List getList() {
        List l = this.getCopiedList();
        if (l == null) {
            l = this.originalList;
        }
        return l;
    }

    public void revert() {
        this.listCopies.set(null);
    }

    public void evolve() {
        this.originalList = this.getList();
    }

    public boolean isCopied() {
        return this.getCopiedList() != null;
    }

    public List cloneOriginalList() {
        return new ArrayList(this.originalList);
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public boolean contains(Object o) {
        return this.getList().contains(o);
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public Object[] toArray() {
        return this.getList().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getList().toArray(a);
    }

    public boolean add(Object o) {
        this.copyIfNecessary();
        return this.getList().add(o);
    }

    public boolean remove(Object o) {
        this.copyIfNecessary();
        return this.getList().remove(o);
    }

    public boolean containsAll(Collection c) {
        this.copyIfNecessary();
        return this.getList().containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.copyIfNecessary();
        return this.getList().addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.copyIfNecessary();
        return this.getList().addAll(index, c);
    }

    public boolean removeAll(Collection c) {
        this.copyIfNecessary();
        return this.getList().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.copyIfNecessary();
        return this.getList().retainAll(c);
    }

    public void clear() {
        this.copyIfNecessary();
        this.getList().clear();
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    public Object get(int index) {
        return this.getList().get(index);
    }

    public Object set(int index, Object element) {
        this.copyIfNecessary();
        return this.getList().set(index, element);
    }

    public void add(int index, Object element) {
        this.copyIfNecessary();
        this.getList().add(index, element);
    }

    public Object remove(int index) {
        this.copyIfNecessary();
        return this.getList().remove(index);
    }

    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getList().listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    public String toString() {
        String s = this.getList().toString();
        if (this.getCopiedList() != null) {
            String id = Thread.currentThread().getName();
            s = s + " (copied, id=" + id + ")";
        } else {
            s = s + " (original)";
        }
        return s;
    }
}

