/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FileLookup {
    private static final String UNDERSCORE = "_";
    private static final String NULL_LOCALE = "nullLocale";
    private static Map paths = new HashMap();

    private static File[] getCachedPaths(String base, String type, String locale, String app, String provider, String clientPath, String file) {
        Map types = (Map)paths.get(base);
        if (types == null) {
            return null;
        }
        Map locales = (Map)types.get(type);
        if (locales == null) {
            return null;
        }
        Map apps = (Map)locales.get(locale);
        if (apps == null) {
            return null;
        }
        Map providers = (Map)apps.get(app);
        if (providers == null) {
            return null;
        }
        Map clientPaths = (Map)providers.get(provider);
        if (clientPaths == null) {
            return null;
        }
        Map files = (Map)clientPaths.get(clientPath);
        if (files == null) {
            return null;
        }
        File[] fs = (File[])files.get(file);
        return fs;
    }

    private static void putCachedPaths(String base, String type, String locale, String app, String provider, String clientPath, String file, File[] fs) {
        HashMap<String, File[]> files;
        HashMap<String, HashMap<String, File[]>> clientPaths;
        HashMap providers;
        HashMap apps;
        HashMap locales;
        HashMap types = (HashMap)paths.get(base);
        if (types == null) {
            types = new HashMap();
            paths.put(base, types);
        }
        if ((locales = (HashMap)types.get(type)) == null) {
            locales = new HashMap();
            types.put(type, locales);
        }
        if ((apps = (HashMap)locales.get(locale)) == null) {
            apps = new HashMap();
            locales.put(locale, apps);
        }
        if ((providers = (HashMap)apps.get(app)) == null) {
            providers = new HashMap();
            apps.put(app, providers);
        }
        if ((clientPaths = (HashMap<String, HashMap<String, File[]>>)providers.get(provider)) == null) {
            clientPaths = new HashMap<String, HashMap<String, File[]>>();
            providers.put(provider, clientPaths);
        }
        if ((files = (HashMap<String, File[]>)clientPaths.get(clientPath)) == null) {
            files = new HashMap<String, File[]>();
            clientPaths.put(clientPath, files);
        }
        files.put(file, fs);
    }

    protected static File[] getOrderedPaths(String base, String type, String locale, String channel, String provider, String clientPath, String filename) {
        File[] files = FileLookup.getCachedPaths(base, type, locale, channel, provider, clientPath, filename);
        if (files == null) {
            files = FileLookup.buildPaths(base, type, locale, channel, provider, clientPath, filename);
            FileLookup.putCachedPaths(base, type, locale, channel, provider, clientPath, filename, files);
        }
        return files;
    }

    protected static File[] buildPaths(String base, String type, String locale, String channel, String provider, String clientPath, String filename) {
        int orderedPathLength;
        if (filename == null) {
            throw new DesktopError("FileLookup.getOrderedPaths(): file was null");
        }
        String[] types = null;
        int numberOfTypes = 1;
        boolean haveType = false;
        if (type != null && !type.equals("default")) {
            haveType = true;
            ++numberOfTypes;
        }
        types = new String[numberOfTypes];
        if (haveType) {
            types[0] = type;
            types[1] = "default";
            orderedPathLength = 2;
        } else {
            types[0] = "default";
            orderedPathLength = 1;
        }
        int numberOfLocales = 0;
        int indexOfLastUS = 0;
        String[] locales = null;
        if (locale != null && locale.length() != 0) {
            ++numberOfLocales;
            String frontOfStr = locale;
            while (indexOfLastUS != -1) {
                indexOfLastUS = frontOfStr.lastIndexOf(UNDERSCORE);
                if (indexOfLastUS == -1) continue;
                frontOfStr = frontOfStr.substring(0, indexOfLastUS);
                ++numberOfLocales;
            }
            frontOfStr = locale;
            locales = new String[numberOfLocales + 1];
            locales[0] = locale;
            indexOfLastUS = 0;
            int i = 1;
            while (indexOfLastUS != -1) {
                indexOfLastUS = frontOfStr.lastIndexOf(UNDERSCORE);
                if (indexOfLastUS == -1) continue;
                String thisPartOfStr = frontOfStr.substring(0, indexOfLastUS);
                locales[i++] = thisPartOfStr;
                frontOfStr = thisPartOfStr;
            }
            locales[i++] = NULL_LOCALE;
            if (++numberOfLocales > 1) {
                orderedPathLength *= numberOfLocales;
            }
        } else {
            locales = new String[1];
            locales[numberOfLocales++] = NULL_LOCALE;
        }
        boolean haveClientPath = false;
        String[] clientkeys = null;
        if (clientPath != null && clientPath.length() > 0) {
            clientkeys = FileLookup.getClientPathKeys(clientPath);
            orderedPathLength *= clientkeys.length + 1;
            haveClientPath = true;
        }
        boolean haveChannel = false;
        int tempPathLength = orderedPathLength;
        if (channel != null && channel.length() != 0) {
            haveChannel = true;
            orderedPathLength *= 2;
        }
        boolean haveProvider = false;
        if (provider != null && provider.length() != 0) {
            haveProvider = true;
            orderedPathLength = haveChannel ? (orderedPathLength += tempPathLength) : (orderedPathLength *= 2);
        }
        File[] orderedPaths = new File[++orderedPathLength];
        String thisFileName = "";
        int numberOfOrderedPaths = 0;
        int i = 0;
        while (i < numberOfTypes) {
            String currentFilePath = base + File.separator + types[i];
            int j = 0;
            while (j < numberOfLocales) {
                String filePath;
                int len;
                String thisFilePath = null;
                thisFilePath = locales[j].equals(NULL_LOCALE) ? currentFilePath : currentFilePath + UNDERSCORE + locales[j];
                if (haveClientPath) {
                    len = clientkeys.length;
                    while (len > 0) {
                        if (haveChannel) {
                            filePath = thisFilePath + File.separator + channel + FileLookup.buildClientPath(clientkeys, len);
                            FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, filePath, filename);
                        }
                        if (haveProvider) {
                            filePath = thisFilePath + File.separator + provider + FileLookup.buildClientPath(clientkeys, len);
                            FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, filePath, filename);
                        }
                        --len;
                    }
                    if (haveChannel) {
                        String channelFilePath = thisFilePath + File.separator + channel;
                        FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, channelFilePath, filename);
                    }
                    if (haveProvider) {
                        String providerFilePath = thisFilePath + File.separator + provider;
                        FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, providerFilePath, filename);
                    }
                }
                if (haveClientPath) {
                    len = clientkeys.length;
                    while (len > 0) {
                        thisFilePath = locales[j].equals(NULL_LOCALE) ? currentFilePath : currentFilePath + UNDERSCORE + locales[j];
                        filePath = thisFilePath + FileLookup.buildClientPath(clientkeys, len);
                        FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, filePath, filename);
                        --len;
                    }
                }
                thisFilePath = !locales[j].equals(NULL_LOCALE) ? currentFilePath + UNDERSCORE + locales[j] : currentFilePath;
                FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, thisFilePath, filename);
                ++j;
            }
            ++i;
        }
        FileLookup.addPath(orderedPaths, numberOfOrderedPaths++, base, filename);
        return orderedPaths;
    }

    private static void addPath(File[] files, int index, String path, String file) {
        File f;
        files[index] = f = new File(path, file);
    }

    public static File getFirstExisting(String base, String type, String locale, String channel, String provider, String clientPath, String filename) {
        File[] files = FileLookup.getOrderedPaths(base, type, locale, channel, provider, clientPath, filename);
        int i = 0;
        while (i < files.length) {
            if (files[i].exists()) {
                return files[i];
            }
            ++i;
        }
        return null;
    }

    public static File getMostSpecific(String base, String type, String locale, String channel, String provider, String clientPath, String filename) {
        File[] files = FileLookup.getOrderedPaths(base, type, locale, channel, provider, clientPath, filename);
        return files[0];
    }

    private static String buildClientPath(String[] keys, int len) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            sb.append(File.separator).append(keys[i]);
            ++i;
        }
        return sb.toString();
    }

    private static String[] getClientPathKeys(String cp) {
        StringTokenizer st = new StringTokenizer(cp, File.separator);
        int numTokens = st.countTokens();
        String[] keyArray = new String[numTokens];
        int i = 0;
        while (i < numTokens) {
            keyArray[i] = st.nextToken();
            ++i;
        }
        return keyArray;
    }

    private static String toString(File[] files) {
        String s = "[";
        int i = 0;
        while (i < files.length) {
            s = files[i] == null ? s + "<null>" : s + files[i].toString();
            if (i < files.length - 1) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + "]";
        return s;
    }

    private static void logFiles(File[] files) {
        String f = FileLookup.toString(files);
        FileLookup.log("FileLookup.logFiles(): f=" + f);
    }

    private static void log(String msg) {
        if (DesktopAppContextThreadLocalizer.exists()) {
            DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
            dac.debugError(msg);
        }
    }
}

