/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPAvailable;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPSelected;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAvailable;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPReferenceList;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPSelected;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPContainerChannel
extends XMLDPChannel
implements DPContainerChannel,
DPTypes,
XMLDPTags {
    private Element selectedElement = null;
    private Element availableElement = null;

    XMLDPContainerChannel(DPContext dpc, DPRoot r, Document d, String name, String providerName) {
        this(dpc, r, XMLDPContainerChannel.createElement(dpc, d, name, providerName, XMLDPProperties.createElement(dpc, d)));
    }

    XMLDPContainerChannel(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public short getType() {
        return 5;
    }

    public DPChannel copy(DPRoot dpr, boolean deep) {
        XMLDPRoot xmldpr = (XMLDPRoot)dpr;
        Document ownerDocument = xmldpr.getElement().getOwnerDocument();
        Element copyElement = (Element)ownerDocument.importNode(this.getElement(), deep);
        if (!deep) {
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Properties", null), false));
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Available", null), false));
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Selected", null), false));
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Channels", null), false));
        }
        return XMLDPFactory.getInstance().getChannel(this.getContext(), dpr, copyElement);
    }

    Element getAvailableElement() {
        if (this.availableElement == null) {
            this.availableElement = XMLDPObject.getChildElement(this.getElement(), "Available", null);
            if (this.availableElement == null) {
                throw new DPError("XMLDPContainerChannel.getAvailableElement(): no Available child found");
            }
        }
        return this.availableElement;
    }

    public DPAvailable getAvailableFromThis() {
        Element a = this.getAvailableElement();
        DPAvailable dpAvailable = (DPAvailable)this.getObject(a);
        if (dpAvailable == null) {
            dpAvailable = XMLDPFactory.getInstance().getAvailable(this.getContext(), this.getRoot(), a);
            this.putObject(dpAvailable);
        }
        return dpAvailable;
    }

    protected DPAvailable getAvailableFromThis(Element a) {
        DPAvailable dpAvailable = null;
        if (a == null) {
            throw new DPError("XMLDPContainerChannel.getAvailableFromThis(): no Available child found");
        }
        dpAvailable = XMLDPFactory.getInstance().getAvailable(this.getContext(), this.getRoot(), a);
        return dpAvailable;
    }

    public DPSelected getSelectedFromThis() {
        Element s = this.getSelectedElement();
        DPSelected dpSelected = (DPSelected)this.getObject(s);
        if (dpSelected == null) {
            dpSelected = XMLDPFactory.getInstance().getSelected(this.getContext(), this.getRoot(), s);
            this.putObject(dpSelected);
        }
        return dpSelected;
    }

    Element getSelectedElement() {
        if (this.selectedElement == null) {
            this.selectedElement = XMLDPObject.getChildElement(this.getElement(), "Selected", null);
            if (this.selectedElement == null) {
                throw new DPError("XMLDPContainerChannel.getSelectedElement(): no Selected child found");
            }
        }
        return this.selectedElement;
    }

    public DPAvailable getAvailable() {
        DPAvailable dpAvailable = this.getAvailableFromThis();
        if (dpAvailable == null || !dpAvailable.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPContainerChannel dpcc = (DPContainerChannel)i.next();
                DPAvailable dpa = ((XMLDPContainerChannel)dpcc).getAvailableFromThis();
                dpAvailable.addMerger(dpa);
            }
        }
        return dpAvailable;
    }

    public void setAvailable(List avail) {
        this.getAvailable().setCollectionValue(avail);
    }

    public DPSelected getSelected() {
        DPSelected dpSelected = this.getSelectedFromThis();
        if (dpSelected == null || !dpSelected.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPContainerChannel dpcc = (DPContainerChannel)i.next();
                DPSelected dps = ((XMLDPContainerChannel)dpcc).getSelectedFromThis();
                dpSelected.addMerger(dps);
            }
        }
        return dpSelected;
    }

    public void setSelected(List set) {
        this.getSelected().setCollectionValue(set);
    }

    DPChannel createDummy(DPRoot dpr) {
        DPContainerChannel dpc = (DPContainerChannel)super.createDummy(dpr);
        dpc.setMergeDefaults();
        return dpc;
    }

    static Element createElement(DPContext dpc, Document d, String name, String providerName, Element propertiesElement) {
        Element e = XMLDPObject.createElement(dpc, d, "Container", name);
        e.setAttribute("provider", providerName);
        e.appendChild(propertiesElement);
        Element ae = XMLDPAvailable.createElement(dpc, d);
        e.appendChild(ae);
        Element se = XMLDPSelected.createElement(dpc, d);
        e.appendChild(se);
        Element channelsElement = d.createElement("Channels");
        e.appendChild(channelsElement);
        XMLDPContainerChannel.setMergeDefaultsElement(e);
        return e;
    }

    public void setMergeDefaults() {
        XMLDPContainerChannel.setMergeDefaultsElement(this.getElement());
    }

    static void setMergeDefaultsElement(Element e) {
        XMLDPObject.setMergeTypeElement(e, XMLDPPropertyHolder.staticGetDefaultMergeType());
        e.setAttribute("lock", "false");
        e.setAttribute("advanced", "false");
        Element pe = XMLDPObject.getChildElement(e, "Properties", null);
        XMLDPCollection.setMergeDefaultsElement(pe);
        Element ae = XMLDPObject.getChildElement(e, "Available", null);
        XMLDPReferenceList.setMergeDefaultsElement(ae);
        Element se = XMLDPObject.getChildElement(e, "Selected", null);
        XMLDPReferenceList.setMergeDefaultsElement(se);
    }
}

