/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.desktop.deployment.ProviderPackageFile;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class ParXferPPF
extends ProviderPackageFile {
    private ParFile m_PF;
    private String m_Path;
    private static final int CLASSFILE = 1;
    private static final int PBFILE = 3;

    public ParXferPPF(ParFile pf, String path, int types) {
        super(types);
        this.m_PF = pf;
        this.m_Path = path;
    }

    public InputStream getStream() throws ParFileException {
        try {
            return this.m_PF.getInputStream(this.m_PF.getEntry(this.m_Path));
        }
        catch (Exception ex) {
            throw new ParFileException("Exception opening .par file entry for transfer.", ex);
        }
    }

    public void addManifestInclusion(ParManifest man, String name) throws ParFileException {
        ParManifest mf = this.m_PF.getParManifest();
        switch (mf.getPathRootType(this.m_Path)) {
            case 1: {
                man.addDPEntryIncludeClass(name, mf.getFullFromClassPath(this.m_Path), this.getTypes());
                break;
            }
            case 3: {
                man.addDPEntryIncludePBFile(name, mf.getPropertyFromPBFPath(this.m_Path), mf.getPathFromPBFPath(this.m_Path), this.getTypes());
                break;
            }
            default: {
                throw new ParFileException("Bad root type in .par file transfer.");
            }
        }
    }

    public ZipEntry getZipEntry(ParManifest man) throws ParFileException {
        ParManifest mf = this.m_PF.getParManifest();
        switch (mf.getPathRootType(this.m_Path)) {
            case 1: {
                return man.getClassZip(mf.getFullFromClassPath(this.m_Path));
            }
            case 3: {
                return man.getPBFileZip(mf.getPropertyFromPBFPath(this.m_Path), mf.getPathFromPBFPath(this.m_Path));
            }
        }
        throw new ParFileException("Bad root type in .par file transfer.");
    }
}

