/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.CmdOpts;
import com.sun.portal.desktop.deployment.DPBasedPPCtx;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ExportFile;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.desktop.deployment.ProviderPackageContext;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class CmdExport {
    public static void doExport(boolean verbose, boolean modify, String parfile, DPRootSpecifier dpr, Vector expfiles, PrintStream out) throws ParFileException {
        ParFileBuilder pfb = new ParFileBuilder(verbose, out);
        if (modify) {
            ParFile oldpf = ParFile.makeParFile(parfile);
            ParManifest oldmf = oldpf.getParManifest();
            oldmf.transferFileEntries(pfb, oldpf);
        }
        DPBasedPPCtx ppctx = new DPBasedPPCtx(dpr);
        HashMap<String, String> namecheck = new HashMap<String, String>();
        int i = 0;
        while (i < expfiles.size()) {
            String fn = (String)expfiles.elementAt(i);
            ExportFile xpf = ExportFile.makeExportFile(fn, dpr.getDN(), (ProviderPackageContext)ppctx);
            String nm = xpf.getDPEntryName();
            if (namecheck.get(nm) != null) {
                throw new ParFileException("Duplicate entry name - " + nm);
            }
            namecheck.put(nm, nm);
            xpf.addEntry(pfb);
            ++i;
        }
        if (modify) {
            File tf = null;
            String tfn = null;
            try {
                tf = File.createTempFile("parexp", "par");
                tfn = tf.getAbsolutePath();
            }
            catch (Exception ex) {
                throw new ParFileException("Exception creating temporary file.", ex);
            }
            pfb.makeParFile(tfn);
            pfb.clear();
            try {
                tf.renameTo(new File(parfile));
            }
            catch (Exception ex) {
                System.err.println("Error attempting to rename temporary file.  Par file constructed in " + tfn);
            }
            return;
        }
        pfb.makeParFile(parfile);
    }

    public static void main(String[] args) {
        CmdOpts opts = CmdOpts.parseOpts(args, 3, 3, "export [<options>] -- <parfile> <dn|global> <exportfile> [<exportfile> ....]", "rpdvm");
        if (opts != null) {
            try {
                CmdExport.doExport(opts.verbose(), opts.modify(), opts.parfile(), opts.dproot(), opts.remaining(), System.out);
            }
            catch (Exception ex) {
                opts.produceErrorMessage(ex);
            }
        }
        System.exit(0);
    }
}

