/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DSAMEClientContext
implements ClientContext {
    protected DesktopContext desktopContext = null;
    protected Map clientCache = new HashMap();
    protected AMClientDetector cd = null;

    public void init() {
        this.cd = new AMClientDetector();
    }

    private Client getClient(String clientType) {
        Client client = (Client)this.clientCache.get(clientType);
        if (client == null) {
            Map map = this.clientCache;
            synchronized (map) {
                client = (Client)this.clientCache.get(clientType);
                if (client == null) {
                    try {
                        client = Client.getInstance((String)clientType);
                    }
                    catch (ClientException c) {
                        throw new ContextError("DSAMEDPContext.init(): can not get client instance", c);
                    }
                }
                this.clientCache.put(clientType, client);
            }
        }
        return client;
    }

    public String getContentType(String clientType) {
        return this.getClientTypeProperty(clientType, "contentType");
    }

    public String getClientPath(String clientType) {
        return this.getClientTypeProperty(clientType, "filePath");
    }

    public String getClientType() {
        return this.cd.getClientType(RequestThreadLocalizer.getRequest());
    }

    public String getDefaultClientType() {
        Client cli = Client.getDefaultInstance();
        return cli.getClientType();
    }

    public String getClientTypeProperty(String clientType, String key) {
        Client client = this.getClient(clientType);
        return client.getProperty(key);
    }

    public String getCharset(String clientType, Locale locale) {
        Client client = this.getClient(clientType);
        return client.getCharset(locale);
    }
}

