/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.servlet;

import com.sun.portal.netmail.servlet.NetMailContext;
import com.sun.portal.netmail.servlet.NetMailSession;
import com.sun.portal.netmail.servlet.ParseQueryString;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetMailServlet
extends HttpServlet {
    private final String packageName = "com.sun.portal.netmail.servlet";
    private Hashtable sessions = new Hashtable();
    private String title = "";
    private String badContextMsg = "";
    private long lastSessionCheck = System.currentTimeMillis();
    private static final long sessionCheckInterval = 300000L;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n;
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null && string2.length() > 0) {
            string = string + "?" + string2;
        }
        if ((n = string.indexOf("NetMailServlet")) == -1 || string.length() <= n + 16) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType("text/html");
            servletOutputStream.println("<html><body text=#000000 bgcolor=#FFFFFF><p>Welcome to NetMail.</body></html>");
            return;
        }
        if (string.charAt(n + 14) == '?') {
            string2 = string.substring(n + 15);
        } else {
            int n2 = string.lastIndexOf("/");
            string2 = string.substring(n + 15, n2);
        }
        Hashtable hashtable = ParseQueryString.parse(string2);
        NetMailSession netMailSession = this.getSession(httpServletRequest, hashtable, httpServletResponse);
        if (netMailSession != null) {
            netMailSession.doGet(httpServletRequest, hashtable, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Hashtable hashtable = ParseQueryString.parse(httpServletRequest.getQueryString());
        NetMailSession netMailSession = this.getSession(httpServletRequest, hashtable, httpServletResponse);
        if (netMailSession != null) {
            netMailSession.doPost(httpServletRequest, hashtable, httpServletResponse);
        }
    }

    synchronized NetMailSession getSession(HttpServletRequest httpServletRequest, Hashtable hashtable, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray = (String[])hashtable.get("nsid");
        if (stringArray == null || stringArray.length != 1) {
            throw new ServletException("bad request query string: " + httpServletRequest.getQueryString());
        }
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        String string = stringArray[0];
        hashtable.remove("nsid");
        NetMailSession netMailSession = null;
        if (!string.startsWith("new")) {
            this.checkForExpiredSessions();
            netMailSession = (NetMailSession)this.sessions.get(string);
            if (netMailSession == null || !netMailSession.updateContext(httpServletRequest)) {
                if (httpServletRequest.getMethod().equalsIgnoreCase("POST") && httpServletRequest.getContentType().equals("application/x-netmail-data")) {
                    httpServletResponse.setContentType("application/x-netmail-timeout");
                } else {
                    httpServletResponse.setContentType("text/html");
                }
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.println("<html><head><title>" + this.title + "</title></head>");
                servletOutputStream.println("<body text=#000000 bgcolor=#FFFFFF>");
                servletOutputStream.println(this.badContextMsg);
                servletOutputStream.println("</body></html>");
                return null;
            }
            netMailSession.setLastAccessed(System.currentTimeMillis());
            return netMailSession;
        }
        try {
            this.checkForExpiredSessions();
            String string2 = string.substring(3);
            Class<?> clazz = Class.forName("com.sun.portal.netmail.servlet." + string2);
            netMailSession = (NetMailSession)clazz.newInstance();
            netMailSession.setOwner(this);
            String[] stringArray2 = (String[])hashtable.get("context");
            if (stringArray2 == null) {
                stringArray2 = new String[]{"PortalServerContext"};
            }
            Class<?> clazz2 = Class.forName("com.sun.portal.netmail.servlet." + stringArray2[0]);
            netMailSession.setContext((NetMailContext)clazz2.newInstance());
            boolean bl = netMailSession.updateContext(httpServletRequest);
            netMailSession.determineHTMLCharset(httpServletRequest);
            if (this.title.equals("")) {
                this.title = netMailSession.getString("ns.a");
                this.badContextMsg = netMailSession.getString("ns.b");
            }
            if (!bl) {
                httpServletResponse.setContentType("text/html");
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.println("<html><head><title>" + this.title + "</title></head>");
                servletOutputStream.println("<body text=#000000 bgcolor=#FFFFFF>");
                servletOutputStream.println(this.badContextMsg);
                servletOutputStream.println("</body></html>");
                return null;
            }
            netMailSession.setLastAccessed(System.currentTimeMillis());
            this.sessions.put(netMailSession.getId(), netMailSession);
            return netMailSession;
        }
        catch (Exception exception) {
            System.out.println("NetMailServlet.getSession: " + exception);
            exception.printStackTrace();
            throw new ServletException("NetMailServlet.getSession" + exception);
        }
    }

    synchronized void removeSession(NetMailSession netMailSession) {
        if (this.sessions.containsKey(netMailSession.getId())) {
            netMailSession.close();
            this.sessions.remove(netMailSession.getId());
        }
    }

    void checkForExpiredSessions() {
        if (System.currentTimeMillis() - this.lastSessionCheck < 300000L) {
            return;
        }
        this.lastSessionCheck = System.currentTimeMillis();
        Hashtable hashtable = (Hashtable)this.sessions.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            NetMailSession netMailSession = (NetMailSession)enumeration.nextElement();
            if (!netMailSession.isValid()) {
                netMailSession.debug("removing session " + netMailSession.getId() + " because it is no longer valid");
                this.removeSession(netMailSession);
                continue;
            }
            if (System.currentTimeMillis() - netMailSession.getLastAccessed() <= 300000L) continue;
            netMailSession.close();
        }
    }
}

