/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util;

import com.sun.portal.rewriter.util.ListSet;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SRAPRewriterProfile {
    private static final String MIME_MAP_NAME = "MIMEMap";
    private static final String RULESET_MAP_NAME = "DomainsAndRulesets";
    private static final String TRANSLATE_ALL_NAME = "TranslateAll";
    private static final String PROFILE_NAME = "gateway.profilename";
    private static boolean translateAll = false;
    private static Map rulesetMAP = Collections.EMPTY_MAP;
    private static Map mimeMAP = Collections.EMPTY_MAP;
    private static List intranetInfo = Collections.EMPTY_LIST;

    public static void init(String aContext) {
        if (aContext == null || aContext.equals("IDSAME")) {
            SRAPRewriterProfile.initIntranetInfo();
            SRAPRewriterProfile.initRuleSetMap();
            SRAPRewriterProfile.initMIMEMap();
        } else {
            translateAll = true;
        }
    }

    public static List getIntranetInfo() {
        return intranetInfo;
    }

    static boolean isTranslateAll() {
        return translateAll;
    }

    public static String getInstanceName() {
        return System.getProperty(PROFILE_NAME, "default");
    }

    public static Map getRuleSetMap() {
        return rulesetMAP;
    }

    public static Map getMIMEMap() {
        return mimeMAP;
    }

    private static void initIntranetInfo() {
        ListSet lInfo = new ListSet();
        String defaultDomain = GatewayProfile.getString("DefaultDomainAndSubdomains", "").trim();
        if (defaultDomain.length() != 0) {
            lInfo.add(defaultDomain.toLowerCase());
        }
        List proxyInfo = Collections.unmodifiableList(GatewayProfile.getStringList("DomainsAndSubdomains"));
        Iterator iterator = proxyInfo.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next().toString();
            String[] splited = StringHelper.separateTokens((String)line, (String)" ", (int)1);
            splited[0] = splited[0].trim();
            if (splited[0].length() == 0) continue;
            lInfo.add(splited[0].toLowerCase());
        }
        SRAPRewriterProfile.initTranslateAll((List)lInfo);
        intranetInfo = Collections.unmodifiableList(lInfo);
    }

    private static void initTranslateAll(List aInfo) {
        int starProxyIndex = aInfo.indexOf("*");
        if (starProxyIndex != -1) {
            aInfo.remove(starProxyIndex);
        }
        translateAll = GatewayProfile.getBoolean(TRANSLATE_ALL_NAME, false);
    }

    private static void initRuleSetMap() {
        HashMap<String, String> lMap = new HashMap<String, String>();
        List bRuleSetMap = Collections.unmodifiableList(GatewayProfile.getStringList(RULESET_MAP_NAME));
        Iterator iterator = bRuleSetMap.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next().toString();
            String[] splited = StringHelper.separateTokens((String)line, (String)"|", (int)2);
            splited[0] = splited[0].trim();
            splited[1] = splited[1].trim();
            if (splited[0].length() == 0 || splited[1].length() == 0) continue;
            lMap.put(splited[0].toLowerCase(), splited[1].toLowerCase());
        }
        rulesetMAP = Collections.unmodifiableMap(lMap);
    }

    private static void initMIMEMap() {
        HashMap<String, String> supportedContentTypes = new HashMap<String, String>();
        supportedContentTypes.put("css", "text/css");
        supportedContentTypes.put("html", "text/html");
        supportedContentTypes.put("javascript", "application/x-javascript");
        supportedContentTypes.put("java_script", "application/x-javascript");
        supportedContentTypes.put("xml", "text/xml");
        supportedContentTypes.put("wml", "text/wml");
        HashMap lMap = new HashMap();
        List mimeMapList = Collections.unmodifiableList(GatewayProfile.getStringList(MIME_MAP_NAME));
        Iterator iterator = mimeMapList.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next().toString();
            String[] splited = StringHelper.separateTokens((String)line, (String)"=");
            if (splited.length == 2) {
                String key = splited[0].trim();
                Object mime = supportedContentTypes.get(key.toLowerCase());
                if (mime != null) {
                    String[] values = StringHelper.separateTokens((String)splited[1], (String)";:|");
                    int i = 0;
                    while (i < values.length) {
                        String value = values[i].trim();
                        if (value.length() != 0) {
                            lMap.put(value.toLowerCase(), mime);
                        }
                        ++i;
                    }
                    continue;
                }
                System.out.println("No Rewriter Available for key:" + key);
                continue;
            }
            System.out.println("Illegal List Content:" + line);
        }
        mimeMAP = Collections.unmodifiableMap(lMap);
    }
}

