/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.AttributeExtractor;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.UserProfileGatewayCache;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserProfile {
    private static final String GET_REQUEST = "GET_USERS";
    private Map result;
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";

    public String toString() {
        return this.result.toString();
    }

    public UserProfile(String sessionId) throws SendRequestException, GetResponseException {
        try {
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            SSOToken s = ssoTokenManager.createSSOToken(sessionId);
            if (!ssoTokenManager.isValidToken(s)) {
                this.result = null;
            }
            this.result = UserProfileGatewayCache.getResponse(sessionId);
        }
        catch (Exception ex) {
            this.result = null;
        }
    }

    public String getString(String name, String defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getString(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String name, int defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getInt(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getBoolean(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public List getStringList(String name) {
        if (this.result != null) {
            return AttributeExtractor.getStringList(this.result, name);
        }
        return null;
    }

    public static void setAttributes(String sessionId, String attribute, Set value) throws SendRequestException, GetResponseException {
        UserProfileGatewayCache.setAttribute(sessionId, attribute, value);
    }
}

