/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.idsame;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.authentication.AuthPrincipal;
import com.iplanet.sm.SMSException;
import com.iplanet.sm.ServiceConfig;
import com.iplanet.sm.ServiceConfigManager;
import com.iplanet.sm.ServiceListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rewriter.DataServiceException;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.idsame.IDSAMEEventListenerImpl;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;

public final class IDSAMEDataService
implements DataService {
    private static final IDSAMEEventListenerImpl registar = new IDSAMEEventListenerImpl();
    private static final String REWRITER_BIND_DN = "REWRITER_BIND_DN";
    private static final String REWRITER_PASSWORD = "REWRITER_PASSWORD";
    private static final String SERVICE_NAME = "SunPortalRewriterService";
    private static final String SERVICE_SCHEMA_NAME = "SunPortalRewriterGlobal";
    private static final String ATTRIBUTE_NAME = "sunPortalRewriterRuleset";
    private static final String SUBCONFIG_ID = "SunPortalRewriterRuleSets";
    private ServiceConfig config;
    private ServiceConfigManager configManager;

    public IDSAMEDataService(Properties properties) throws DataServiceException {
        String string = properties.getProperty(REWRITER_BIND_DN, AdminUtils.getAdminDN());
        if (string != null) {
            byte[] byArray = AdminUtils.getAdminPassword();
            if (byArray == null) {
                byArray = Constants.EMTPY_BYTE_ARRAY;
            }
            String string2 = properties.getProperty(REWRITER_PASSWORD, new String(byArray));
            SSOToken sSOToken = this.getSSOToken(string, string2);
            this.config = this.getConfig(sSOToken);
        }
    }

    public IDSAMEDataService(SSOToken sSOToken) throws DataServiceException {
        this.config = this.getConfig(sSOToken);
    }

    public String deleteKey(String string) throws DataServiceException {
        this.checkRuleSetIDKeyInput(string);
        String string2 = StringHelper.findMatchByIgnoringCase(this.retrieveKeys(), string);
        String string3 = this.optimisticDeleteKey(string2);
        return string3;
    }

    public String retrieveXML(String string) throws DataServiceException {
        this.checkRuleSetIDKeyInput(string);
        return this.optimisticRetrieveXML(string.toLowerCase());
    }

    public String storeXML(String string, String string2) throws DataServiceException {
        try {
            this.checkRuleSetIDKeyInput(string);
            this.checkRuleSetInput(string2);
            String string3 = this.optimisticDeleteKey(string);
            this.config.addSubConfig(string.toLowerCase(), SUBCONFIG_ID, 0, this.prepareAttributeValue(string2));
            return string3;
        }
        catch (Exception exception) {
            throw new DataServiceException(exception.getMessage(), exception);
        }
    }

    public Set retrieveKeys() throws DataServiceException {
        try {
            return Collections.unmodifiableSet(this.config.getSubConfigNames());
        }
        catch (SMSException sMSException) {
            throw new DataServiceException(sMSException.getMessage(), sMSException);
        }
    }

    private Map prepareAttributeValue(String string) {
        HashSet<String> hashSet = new HashSet<String>(1);
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(1);
        hashSet.add(string);
        hashMap.put(ATTRIBUTE_NAME, hashSet);
        return hashMap;
    }

    private String optimisticDeleteKey(String string) throws DataServiceException {
        try {
            String string2 = null;
            if (this.matchesWithID(string) != null) {
                string2 = this.optimisticRetrieveXML(string);
                this.config.removeSubConfig(string);
            }
            return string2;
        }
        catch (SMSException sMSException) {
            throw new DataServiceException(sMSException.getMessage(), sMSException);
        }
        catch (SSOException sSOException) {
            throw new DataServiceException(sSOException.getMessage(), sSOException);
        }
    }

    private String optimisticRetrieveXML(String string) throws DataServiceException {
        try {
            ServiceConfig serviceConfig = this.config.getSubConfig(string);
            if (null == serviceConfig) {
                return null;
            }
            Map map = serviceConfig.getAttributes();
            Set set = (Set)map.get(ATTRIBUTE_NAME);
            Iterator iterator = set.iterator();
            return (String)iterator.next();
        }
        catch (SMSException sMSException) {
            throw new DataServiceException(sMSException.getMessage(), sMSException);
        }
        catch (SSOException sSOException) {
            throw new DataServiceException(sSOException.getMessage(), sSOException);
        }
    }

    public String matchesWithID(String string) throws DataServiceException {
        String string2 = StringHelper.findMatchByIgnoringCase(this.retrieveKeys(), string);
        return string2;
    }

    private ServiceConfig getConfig(SSOToken sSOToken) throws DataServiceException {
        try {
            this.configManager = new ServiceConfigManager(SERVICE_NAME, sSOToken);
            this.registerForIDSMAEEvents();
            ServiceConfig serviceConfig = this.configManager.getGlobalConfig(null);
            return serviceConfig.getSubConfig(SERVICE_SCHEMA_NAME);
        }
        catch (SSOException sSOException) {
            throw new DataServiceException("Not able to get ServiceConfigManager - ", sSOException);
        }
        catch (SMSException sMSException) {
            throw new DataServiceException(sMSException.getMessage(), sMSException);
        }
    }

    private SSOToken getSSOToken(String string, String string2) throws DataServiceException {
        try {
            AuthPrincipal authPrincipal = new AuthPrincipal(string);
            return SSOTokenManager.getInstance().createSSOToken((Principal)authPrincipal, string2);
        }
        catch (SSOException sSOException) {
            throw new DataServiceException("Not able to get TokenManager", sSOException, 5001);
        }
    }

    private void checkRuleSetIDKeyInput(String string) {
        if (null == string || 0 == string.trim().length()) {
            throw new IllegalArgumentException("aRuleSetIDKey cannot be nullor empty");
        }
    }

    private void checkRuleSetInput(String string) {
        if (null == string || 0 == string.trim().length()) {
            throw new IllegalArgumentException("aXMLRuleSet cannot be nullor empty");
        }
    }

    public Observable getChangeNotifier() {
        return registar;
    }

    private void registerForIDSMAEEvents() {
        this.configManager.addListener((ServiceListener)registar);
    }

    public static void main(String[] stringArray) throws DataServiceException {
    }
}

