/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.econnection.CipherMsg;
import com.sun.portal.netlet.econnection.MessageConstants;
import com.sun.portal.netlet.econnection.SizeConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DataCipherMsg
extends CipherMsg
implements MessageConstants,
SizeConstants {
    protected static final int MAX_DATA_LEN = 8192;
    protected byte[] data = null;

    public DataCipherMsg() {
    }

    public DataCipherMsg(CipherGroup c) {
        super((byte)1, (short)3, c);
    }

    public DataCipherMsg(byte[] buffer, int buffer_len, CipherGroup c) {
        super((byte)1, (short)3, c);
        if (buffer_len <= 8192) {
            this.data = new byte[buffer_len];
            this.msgLen = buffer_len;
            System.arraycopy(buffer, 0, this.data, 0, buffer_len);
        }
        this.msgLen = 0;
    }

    public int readMsg(DataInputStream in) {
        int rc = 0;
        rc = this.readHeader(in);
        if (rc == 0 && this.msgLen >= 0 && this.msgLen <= 8192) {
            if (this.data == null) {
                this.data = new byte[this.msgLen];
            } else if (this.msgLen > this.data.length) {
                this.data = null;
                this.data = new byte[this.msgLen];
            }
            try {
                in.readFully(this.data, 0, this.msgLen);
                byte[] decrypted = this.ciphergroup.getDecryptCipher().doFinal(this.data, 0, this.msgLen);
                int outLen = decrypted.length;
                System.arraycopy(decrypted, 0, this.data, 0, decrypted.length);
                if (outLen >= 0) {
                    this.msgLen = outLen;
                } else {
                    this.msgLen = 0;
                    rc = -1;
                }
            }
            catch (IOException e) {
                System.out.println("DataMsg: readMsg IOE:" + e);
                rc = -1;
            }
            catch (NetletCryptoException ne) {
                ne.printStackTrace();
                rc = -1;
            }
        }
        return rc;
    }

    public int writeMsg(DataOutputStream out) {
        int rc;
        block6: {
            rc = 0;
            if (this.msgLen >= 0 && this.msgLen < 8192) {
                try {
                    byte[] encrypted = this.ciphergroup.getEncryptCipher().doFinal(this.data, 0, this.msgLen);
                    int outLen = encrypted.length;
                    System.arraycopy(encrypted, 0, this.data, 0, encrypted.length);
                    if (outLen >= 0) {
                        ByteArrayOutputStream b_out = new ByteArrayOutputStream(8203);
                        int oldmsgLen = this.msgLen;
                        this.msgLen = outLen;
                        this.writeHeaderToByteArray(b_out);
                        b_out.write(this.data, 0, outLen);
                        b_out.writeTo(out);
                        out.flush();
                        this.msgLen = oldmsgLen;
                        break block6;
                    }
                    rc = -1;
                }
                catch (IOException e) {
                    System.out.println("DataMsg: writeMsg IOException");
                    rc = -1;
                }
                catch (NetletCryptoException ne) {
                    ne.printStackTrace();
                    rc = -1;
                }
            } else {
                rc = -1;
            }
        }
        return rc;
    }

    public byte[] getData() {
        byte[] tempBuffer = null;
        if (this.msgLen >= 0 && this.msgLen <= 8192) {
            tempBuffer = new byte[this.msgLen];
            System.arraycopy(this.data, 0, tempBuffer, 0, this.msgLen);
        }
        return tempBuffer;
    }

    public void setData(byte[] buffer, int buffer_len) {
        if (buffer_len > 0 && buffer_len <= 8192) {
            this.msgLen = buffer_len;
            this.data = new byte[buffer_len];
            System.arraycopy(buffer, 0, this.data, 0, buffer_len);
        } else {
            this.data = null;
            this.msgLen = 0;
        }
    }

    public byte[] getDataByRef() {
        return this.data;
    }

    public void setDataByRef(byte[] buffer, int buffer_len) {
        this.data = buffer;
        this.msgLen = buffer_len;
    }
}

