/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.watch_unavailable;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEventImpl;
import com.sun.portal.util.HostAvailabilityMediator;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServersList {
    static Set _servers = new HashSet();
    public static Map _unavailable_servers = new HashMap();
    private static int _retry = GatewayProfile.getInt("ServerRetryInterval", 5) * 60;
    private static Iterator iterator;

    public static boolean contains(String server) {
        if (server == null || server.trim().length() == 0) {
            return false;
        }
        return _servers.contains(server.toLowerCase());
    }

    private static synchronized String getServer() {
        if (iterator.hasNext()) {
            return iterator.next().toString();
        }
        iterator = _servers.iterator();
        return iterator.next().toString();
    }

    private static boolean aLive(String server) {
        Map map = _unavailable_servers;
        synchronized (map) {
            if (!_unavailable_servers.isEmpty() && _unavailable_servers.get(server) != null) {
                boolean bl = false;
                return bl;
            }
            try {
                URL url = new URL(server);
                URLConnection conn = url.openConnection();
                conn.connect();
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementPlainSockets();
                }
                conn = null;
                url = null;
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.decrementPlainSockets();
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServersList::aLive open socket exception:" + e);
                }
                long time = System.currentTimeMillis();
                _unavailable_servers.put(server, new Long(time));
                HostAvailabilityEventImpl event = new HostAvailabilityEventImpl();
                event.setHost(server);
                HostAvailabilityMediator.getHostAvailabilityMediator();
                HostAvailabilityMediator.notifyListeners(event);
                watch_unavailable wus = new watch_unavailable(server, _retry);
                wus.start();
            }
        }
        return false;
    }

    static String getServeraLive() {
        String server = null;
        boolean alive = false;
        while (!alive) {
            server = ServersList.getServer();
            alive = ServersList.aLive(server);
        }
        return server;
    }

    static String getServeraLive(String server) {
        if (ServersList.aLive(server)) {
            return server;
        }
        return ServersList.getServeraLive();
    }

    static Set getAllSessionServersSet() {
        return _servers;
    }

    static {
        List all_servers = GatewayProfile.getStringList("PortalServerList");
        Iterator it = all_servers.iterator();
        String pshostUrl = null;
        String protocol = null;
        String port = null;
        String host = null;
        while (it.hasNext()) {
            int indx2;
            pshostUrl = it.next().toString().trim().toLowerCase();
            int indx1 = pshostUrl.indexOf(":/");
            if (indx1 == -1) {
                indx1 = pshostUrl.indexOf(58);
                if (indx1 == -1) {
                    pshostUrl = "http://" + pshostUrl + ":80";
                } else {
                    indx2 = pshostUrl.indexOf(47, indx1);
                    if (indx2 == -1) {
                        indx2 = pshostUrl.length();
                    }
                    host = pshostUrl.substring(0, indx1);
                    port = pshostUrl.substring(indx1 + 1, indx2);
                    int portVal = -1;
                    try {
                        portVal = Integer.parseInt(port);
                    }
                    catch (NumberFormatException nfex) {
                        portVal = -1;
                    }
                    if (portVal == -1) {
                        portVal = 80;
                    }
                    if (portVal == 80) {
                        protocol = "http://";
                    } else {
                        if (portVal != 443) continue;
                        protocol = "https://";
                    }
                    pshostUrl = protocol + host + ":" + portVal;
                }
            } else {
                indx2 = pshostUrl.indexOf(58, indx1 + 1);
                if (indx2 == -1) {
                    protocol = pshostUrl.substring(0, indx1);
                    if (protocol.equals("http")) {
                        port = ":80";
                    } else {
                        if (!protocol.equals("https")) continue;
                        port = ":443";
                    }
                    if (pshostUrl.endsWith("/")) {
                        pshostUrl = pshostUrl.substring(0, pshostUrl.length() - 1);
                    }
                    pshostUrl = pshostUrl + port;
                }
            }
            _servers.add(pshostUrl);
        }
        iterator = _servers.iterator();
    }
}

