/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.SSLCachedSSLSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSession;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.AuthContext;
import sun.security.ssl.SSLSocketImpl;

public class SSLHTTPSRetriever
extends HTTPRetriever {
    private static final String DEFAULT_SSL_PORT = "443";
    private SSLSession session;
    public static String currentReqHost;
    private static String rpSubdomain;
    private static String rpDomain;

    public byte[] getServerCertificate() {
        return null;
    }

    public Response getResponse(Request req, String destinationHost, Integer logId) {
        HTTPResponse result;
        block20: {
            CachedSocket s = null;
            result = new HTTPResponse();
            try {
                int to;
                CSBufferedInputStream in;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SSLHTTPSRetriever: AttemptRetrieve " + req);
                }
                if (req.getUseProxy()) {
                    s = this.createTunnelSocket(req);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("SSLHTTPSRetriever: Connecting to " + req.getProxyHost());
                    }
                } else {
                    s = SSLCachedSSLSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "ssl", logId);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("SSLHTTPSRetriever: Connecting to: " + req.getHost());
                    }
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SSLHTTPSRetriever: Connecting to: " + req.getHost());
                }
                if (s == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("SSLHTTPSRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                this.ForceSSLHandshake(req, s);
                try {
                    this.sendRequest(req, s);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                catch (Exception e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Exception while sending request/recieving response", e);
                    }
                    return null;
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                String ka = result.getResponseHeader("keep-alive");
                if (ka != null && (to = Integer.parseInt(ka.substring(ka.indexOf("timeout=") + 8, ka.indexOf(44)))) > 0) {
                    s.setTimeout(to);
                }
                if (result.getResponseHeader("Connection: close") != null) {
                    in.setClosed();
                } else {
                    in.setKeepAlive();
                }
                in.setLength(length);
                result.setContentStream(in);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("SSLHTTPSRetriever: ErrorRetrieve " + req, ex);
                }
                result = null;
                if (s == null) break block20;
                try {
                    s.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementSSLSockets();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private CachedSocket createTunnelSocket(Request req) throws IOException {
        String replyStr;
        byte[] b;
        Socket tunnel = new Socket(req.getProxyHost(), req.getProxyPort());
        if (PerfContextObject.ENABLE_PERF) {
            SocketCount.incrementPlainSockets();
        }
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + req.getHost() + ":" + Integer.parseInt(req.getPort()) + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + req.getProxyHost() + ":" + req.getProxyPort() + ".  Proxy returns \"" + replyStr + "\"");
        }
        SSLSocketImpl s = new SSLSocketImpl(tunnel, AuthContext.getDefault(), req.getHost(), Integer.parseInt(req.getPort()));
        return SSLCachedSSLSocketFactory.createSocket(s);
    }

    public void ForceSSLHandshake(Request req, CachedSocket s) throws IOException {
        String string = DEFAULT_SSL_PORT;
        synchronized (string) {
            StringTokenizer st;
            int tokenCount;
            String h = req.getHost();
            currentReqHost = h != null ? ((tokenCount = (st = new StringTokenizer(h, ".")).countTokens()) == 1 ? h + "." + rpSubdomain + rpDomain : (tokenCount == 2 ? h + rpDomain : h)) : null;
            try {
                s.getOutputStream().write(new byte[0]);
            }
            catch (IOException ex) {
                currentReqHost = null;
                throw ex;
            }
            currentReqHost = null;
        }
    }

    static {
        String _host = SystemProperties.get("gateway.host", null);
        String rphost = "https://" + _host + "/";
        if (rphost != null) {
            int len = rphost.length();
            int index1 = rphost.indexOf(46);
            if (index1 != -1 && index1 + 1 < len) {
                int index2 = rphost.indexOf(46, index1 + 1);
                if (index2 == -1) {
                    rpSubdomain = rphost.substring(index1 + 1);
                } else {
                    rpSubdomain = rphost.substring(index1 + 1, index2);
                    rpDomain = rphost.substring(index2);
                }
            }
        }
    }
}

