/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.Socket;

public class CachedSocketFactory {
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    public static int _timeout = GatewayProfile.getInt("BlockedSocketTimeout", 200000);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CachedSocket createSocket(String host, int port, String socketType, Integer logId) {
        Socket socket;
        CachedSocket cachedSocket;
        block24: {
            int i;
            int retries;
            cachedSocket = null;
            socket = null;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Connecting to " + host + ":" + port);
            }
            try {
                socket = new Socket(host, port);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementPlainSockets();
                }
                break block24;
            }
            catch (Exception se) {
                String retryTimes;
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("CachedSocketFactory cannot open connection to " + host + ":" + port, se);
                }
                if ((retryTimes = SystemProperties.get("gateway.sockretries")) == null) {
                    return null;
                }
                retries = Integer.parseInt(retryTimes);
                i = 1;
            }
            while (i <= retries) {
                block25: {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    try {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("CachedSocketFactory: Open new socket; retry #" + i);
                        }
                        socket = new Socket(host, port);
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.incrementPlainSockets();
                        }
                        if (socket != null) {
                            break;
                        }
                    }
                    catch (Exception rse) {
                        if (!GWDebug.debug.errorEnabled()) break block25;
                        GWDebug.debug.error("CachedSocketFactory cannot open connection to " + host + ":" + port, rse);
                    }
                }
                ++i;
            }
            if (socket == null) {
                return null;
            }
        }
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("RProxy", GWLocale.getPFString("csf1", new Object[]{logId, host, new Integer(socket.getPort())}));
        }
        try {
            socket.setSoTimeout(_timeout);
            socket.setTcpNoDelay(true);
            return new CachedSocket(socket);
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("CachedSocketFactory socket error", e);
            }
            if (socket == null) return cachedSocket;
            try {
                try {
                    socket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (IOException e1) {
                    return cachedSocket;
                }
                Object var12_15 = null;
                return cachedSocket;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                socket = null;
                throw throwable;
            }
        }
    }

    public static CachedSocket getCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }

    public static CachedSocket getNewCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }
}

