/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.BlockCipher;
import com.sun.portal.netlet.crypt.ciph.ModeCBC;
import com.sun.portal.netlet.crypt.ciph.ModeECB;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;

abstract class Mode {
    protected final BlockCipher cipher;
    protected final int CIPHER_BLOCK_SIZE;
    protected boolean decrypt;
    protected int bufCount;

    Mode(BlockCipher cipher) {
        this.cipher = cipher;
        this.CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }

    static Mode getInstance(String mode, BlockCipher cipher) throws NetletCryptoException {
        try {
            if (mode.equalsIgnoreCase("CBC")) {
                return new ModeCBC(cipher);
            }
            if (mode.equalsIgnoreCase("ECB")) {
                return new ModeECB(cipher);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new NetletCryptoException("Mode (" + mode + ") not available.");
    }

    void init(boolean decrypt, byte[] key) throws NetletCryptoException {
        this.decrypt = decrypt;
        this.coreInit(decrypt, key);
    }

    final byte[] getIV() {
        return this.coreGetIV();
    }

    final int getOutputSize(int inputLen) {
        return this.coreGetOutputSize(inputLen);
    }

    final int getBlockSize() {
        return this.CIPHER_BLOCK_SIZE;
    }

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        return this.coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    final int getBufSize() {
        return this.bufCount;
    }

    abstract int coreGetOutputSize(int var1);

    abstract void coreInit(boolean var1, byte[] var2) throws NetletCryptoException;

    abstract int coreUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    abstract byte[] coreGetIV();
}

