/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo.tag;

import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.userinfo.tag.ReadTag;
import com.sun.portal.providers.userinfo.tag.TagCastException;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagModule;
import com.sun.portal.providers.userinfo.tag.TagModuleElement;
import com.sun.portal.providers.userinfo.tag.UndefinedTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TagModuleManager {
    private ProviderContext context = null;
    private Map modules = null;
    private Map tags = null;
    private String channel = null;

    public TagModuleManager(String string, HttpServletRequest httpServletRequest) throws TagException {
        this.init(string, httpServletRequest);
    }

    private void init(String string, HttpServletRequest httpServletRequest) throws TagException {
        this.channel = string;
        this.context = ProviderContextThreadLocalizer.get();
        if (this.context == null) {
            throw new TagException("TagModuleManager.init(): provider context was null");
        }
        this.tags = null;
        this.modules = new HashMap();
        Map map = null;
        try {
            this.tags = this.context.getCollectionProperty(string, "tags");
            map = this.context.getCollectionProperty(string, "tagModules");
        }
        catch (ProviderContextException providerContextException) {
            throw new TagException("TagModuleManager.init(): Failed to get properties");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("TagModuleManager.init(): module=" + string2 + " moduleClass=" + string3));
            }
            try {
                TagModule tagModule = (TagModule)Class.forName(string3).newInstance();
                try {
                    tagModule.init(string, httpServletRequest);
                }
                catch (TagException tagException) {
                    this.context.debugError((Object)"TagModuleManager.init()", (Throwable)((Object)tagException));
                    continue;
                }
                this.modules.put(string2, tagModule);
                if (!this.context.isDebugMessageEnabled()) continue;
                this.context.debugMessage((Object)"TagModuleManager.init(): success");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.context.debugError((Object)"TagModuleManager.init()", (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.context.debugError((Object)"TagModuleManager.init()", (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                this.context.debugError((Object)"TagModuleManager.init()", (Throwable)instantiationException);
            }
        }
    }

    public WriteTag getWriteTag(String string) throws TagException {
        String string2 = (String)this.tags.get(string);
        WriteTag writeTag = null;
        try {
            writeTag = (WriteTag)this.modules.get(string2);
        }
        catch (ClassCastException classCastException) {
            throw new TagCastException("error casting to write tag", classCastException);
        }
        if (writeTag == null) {
            throw new UndefinedTagException("undefined tag=" + string);
        }
        return writeTag;
    }

    public ReadTag getReadTag(String string) throws TagException {
        String string2 = (String)this.tags.get(string);
        ReadTag readTag = null;
        try {
            readTag = (ReadTag)this.modules.get(string2);
        }
        catch (ClassCastException classCastException) {
            throw new TagCastException("error casting to read tag", classCastException);
        }
        if (readTag == null) {
            throw new UndefinedTagException("no module defined for tag=" + string);
        }
        return readTag;
    }

    public Hashtable getTable() {
        Hashtable<String, TagModuleElement> hashtable = new Hashtable<String, TagModuleElement>();
        Iterator iterator = this.tags.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ReadTag readTag = null;
            try {
                readTag = this.getReadTag(string);
            }
            catch (TagCastException tagCastException) {
                if (!this.context.isDebugWarningEnabled()) continue;
                this.context.debugWarning((Object)("TagModuleManager.getTable(): was not read module for tag=" + string));
                continue;
            }
            catch (TagException tagException) {
                this.context.debugError((Object)"TagModuleManager.getTable()", (Throwable)((Object)tagException));
                continue;
            }
            if (readTag == null) {
                this.context.debugError((Object)("TagModuleManager.getTable(): couldn't get read module for tag=" + string));
                continue;
            }
            TagModuleElement tagModuleElement = new TagModuleElement(readTag, string, this.context);
            hashtable.put(string, tagModuleElement);
        }
        return hashtable;
    }
}

