/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TimeBoundHashMap
extends HashMap {
    private long _timeOut;
    private long _lastCheck;
    private Map _lastAccess;

    public TimeBoundHashMap(int n) {
        this.init(n);
    }

    public TimeBoundHashMap(int n, int n2) {
        super(n);
        this.init(n2);
    }

    public TimeBoundHashMap(int n, float f, int n2) {
        super(n, f);
        this.init(n2);
    }

    public Object put(Object object, Object object2) {
        long l = System.currentTimeMillis();
        this._lastAccess.put(object, new Long(l));
        this.purge();
        return super.put(object, object2);
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v != null) {
            long l = System.currentTimeMillis();
            this._lastAccess.put(object, new Long(l));
        }
        this.purge();
        return v;
    }

    public Object remove(Object object) {
        this._lastAccess.remove(object);
        return super.remove(object);
    }

    public Set entrySet() {
        Set set = super.entrySet();
        Iterator iterator = this._lastAccess.keySet().iterator();
        Long l = new Long(System.currentTimeMillis());
        while (iterator.hasNext()) {
            this._lastAccess.put(iterator.next(), l);
        }
        return set;
    }

    private void init(int n) {
        this._timeOut = n * 1000;
        this._lastCheck = System.currentTimeMillis();
        this._lastAccess = new HashMap();
    }

    private void purge() {
        long l = System.currentTimeMillis();
        if (l - this._lastCheck > this._timeOut / 8L) {
            Iterator iterator = this._lastAccess.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                long l2 = (Long)this._lastAccess.get(k);
                if (l - l2 <= this._timeOut) continue;
                iterator.remove();
                super.remove(k);
            }
            this._lastCheck = l;
        }
    }
}

