/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.AbstractURI;
import com.sun.portal.rewriter.util.uri.URI;
import com.sun.portal.rewriter.util.uri.URIIntf;
import com.sun.portal.rewriter.util.uri.URISyntaxException;
import java.net.MalformedURLException;

public final class StandardURI
extends AbstractURI
implements URIIntf {
    private URI jdkURI;

    private StandardURI(String string, URI uRI) throws MalformedURLException {
        super(string);
        try {
            int n;
            int n2;
            this.jdkURI = uRI != null ? uRI : new URI(this.uriString);
            if (this.jdkURI.isOpaque()) {
                throw new URISyntaxException("Opaque URI:" + this.uriString, "");
            }
            String string2 = this.getProtocol();
            if (this.jdkURI.isAbsolute() && (n2 = this.uriString.indexOf(string2)) != (n = this.uriString.indexOf(string2 + "://"))) {
                throw new URISyntaxException(this.uriString, "Absolute URI does not contain pattern '://' after the protocol");
            }
            this.setValid(true);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setValid(false);
            throw new MalformedURLException("\nInput to StandardURI:" + string + "\nCause StackTrace:" + StringHelper.stackTrace2String(uRISyntaxException) + "\nWraped Exception:");
        }
    }

    public StandardURI(String string) throws MalformedURLException {
        this(string, null);
    }

    public String getProtocol() {
        return StringHelper.normalize(this.jdkURI.getScheme());
    }

    public String getHost() {
        return StringHelper.normalize(this.jdkURI.getHost());
    }

    public int getPort() {
        return this.jdkURI.getPort();
    }

    public String getAuthority() {
        return StringHelper.normalize(this.jdkURI.getAuthority());
    }

    public String getUserInfo() {
        return StringHelper.normalize(this.jdkURI.getUserInfo());
    }

    public String getPath() {
        return URI.normalize(StringHelper.normalize(this.jdkURI.getPath()));
    }

    public String getReference() {
        return StringHelper.normalize(this.jdkURI.getFragment());
    }

    public String getQuery() {
        return StringHelper.normalize(this.jdkURI.getQuery());
    }

    public boolean hasReference() {
        return this.jdkURI.getFragment() != null;
    }

    public boolean hasQuery() {
        return this.jdkURI.getQuery() != null;
    }

    public boolean isAbsolute() {
        return this.jdkURI.isAbsolute();
    }

    public String getImplID() {
        return "StandardURI";
    }

    public StandardURI resolve(String string) throws MalformedURLException {
        try {
            URI uRI = this.jdkURI.resolve(new URI(string));
            return new StandardURI(uRI.toString(), uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException(uRISyntaxException.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"http://user@password@srap.india.sun.com"};
        int n = 0;
        while (n < stringArray2.length) {
            StandardURI standardURI = new StandardURI(stringArray2[n]);
            System.out.println("Original: " + stringArray2[n]);
            System.out.println("ExternalForm: " + standardURI.toExternalForm());
            System.out.println("ToString " + standardURI.jdkURI.toString());
            System.out.println("Host: " + standardURI.getHost());
            System.out.println("Path: " + standardURI.getPath());
            System.out.println("Normalized: " + new URI("HTTP://RAJA.COM/?abc=10").resolve(new URI(standardURI.getPath())).toString());
            System.out.println("Port: " + standardURI.getPort() + "\n\n");
            ++n;
        }
    }
}

