/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.idsame.cli;

import com.sun.portal.rewriter.DataServiceException;
import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.RewriterFactory;
import com.sun.portal.rewriter.RuleSetManager;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.clip.CLIHandler;
import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public final class RewriterCLI
implements CLIHandler {
    private static final String SUB_COMMAND_LIST = "list";
    private static final String SUB_COMMAND_STORE = "store";
    private static final String SUB_COMMAND_GET = "get";
    private static final String SUB_COMMAND_REMOVE = "remove";
    private static final String OPTION_RULESET_ID = "rulesetid";
    private static final String OPTION_BIND_DN = "runasdn";
    private static final String OPTION_PASSWORD = "password";

    private void doInit(Map map) {
        String string = ((String[])map.get(OPTION_BIND_DN))[0];
        String string2 = ((String[])map.get(OPTION_PASSWORD))[0];
        Properties properties = new Properties();
        properties.setProperty("DATA_SERVICE_TYPE", "IDSAME");
        properties.setProperty("REWRITER_BIND_DN", string);
        properties.setProperty("REWRITER_PASSWORD", string2);
        try {
            RewriterFactory.init(properties);
        }
        catch (DataServiceException dataServiceException) {
            if (dataServiceException.getLocaleID() == 5001) {
                System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgAuthorizationFailed", new Object[]{string}));
                System.exit(0);
            }
            throw dataServiceException;
        }
    }

    private Object doList(String[] stringArray, Map map) {
        String[] stringArray2 = RuleSetManager.getRuleSetNames().toArray(Constants.EMPTY_STRING_ARRAY);
        if (stringArray2.length == 0) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgNoRulesPresent"));
        } else {
            int n = 0;
            while (n < stringArray2.length) {
                System.out.println(stringArray2[n]);
                ++n;
            }
        }
        return stringArray2;
    }

    private Object doStore(String[] stringArray, Map map) {
        String string = Resource.readXML(stringArray[0]);
        if (string.trim().length() == 0) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFileDoesNotExist", new Object[]{stringArray[0]}));
        } else {
            try {
                String string2 = RuleSetManager.matchesWithID(string);
                if (string2 == null) {
                    String string3 = RuleSetManager.store(string);
                    System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
                    return string3;
                }
                System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgRuleSetIDConsumed", new Object[]{string2}));
            }
            catch (InvalidXMLException invalidXMLException) {
                System.err.println(invalidXMLException.getCause());
            }
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFailure"));
        return null;
    }

    private Object doGet(String[] stringArray, Map map) {
        String string = ((String[])map.get(OPTION_RULESET_ID))[0];
        String string2 = RuleSetManager.retrieve(string);
        if (string2 == null) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgMissingRuleSet", new Object[]{string}));
            return string2;
        }
        if (stringArray.length == 0) {
            System.out.println(string2);
            return string2;
        }
        String string3 = stringArray[0];
        if (Resource.saveXML(string3, string2)) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
            return string2;
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgCouldNotSave2File", new Object[]{string3}));
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFailure"));
        return string2;
    }

    private Object doRemove(String[] stringArray, Map map) {
        String string = null;
        String string2 = ((String[])map.get(OPTION_RULESET_ID))[0].trim();
        string = RuleSetManager.delete(string2);
        if (string != null) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
            return string;
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgMissingRuleSet", new Object[]{string2}));
        return string;
    }

    public Object executeCommand(CLIPSpec cLIPSpec, String[] stringArray) {
        try {
            CLIPParser cLIPParser = cLIPSpec.getCLIPParser();
            Map map = Collections.unmodifiableMap(cLIPParser.getOptions(stringArray));
            String[] stringArray2 = cLIPParser.getOperands(stringArray);
            this.doInit(map);
            String string = cLIPParser.getSubCommand(stringArray);
            if (string.equals(SUB_COMMAND_LIST)) {
                return this.doList(stringArray2, map);
            }
            if (string.equals(SUB_COMMAND_STORE)) {
                return this.doStore(stringArray2, map);
            }
            if (string.equals(SUB_COMMAND_GET)) {
                return this.doGet(stringArray2, map);
            }
            if (string.equals(SUB_COMMAND_REMOVE)) {
                return this.doRemove(stringArray2, map);
            }
        }
        catch (CLIPException cLIPException) {
            System.err.println(cLIPException);
        }
        return null;
    }
}

