/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.NetFileContext;
import com.sun.portal.netfile.servlet.NetFileHostDenialProcessor;
import com.sun.portal.netfile.servlet.NetFileLogManager;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class NetFileHostDataProcessor {
    public NetFileLogManager logMgr;
    private Debug debug;
    private static final char c_eol = '\n';
    private static final char DOT = '.';
    private String s_empty_string = "";
    private String S_DEFAULT_ENCODING = "ISO-8859-1";
    String szDefaultDomain = this.s_empty_string;
    String[] localHostAddrs;
    InetAddress[] ia_denied_hosts = null;
    ArrayList al_denied_hosts = null;
    NetFileHostDenialProcessor nfDenyProc = null;
    NetFileContext nfContext = null;
    NetFileResource nfRes;
    List mergedHosts;
    ArrayList listOrigParsedCommonHosts;
    ArrayList listNotMergedCommonHosts = new ArrayList(7);

    public NetFileHostDataProcessor(NetFileLogManager logMgr, NetFileContext nfContext, NetFileResource nfRes) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        if (logMgr == null) {
            this.logMgr = logMgr;
        }
        this.nfDenyProc = new NetFileHostDenialProcessor();
        this.al_denied_hosts = new ArrayList();
        this.nfRes = nfRes;
        this.nfContext = nfContext;
        this.localHostAddrs = this.getRPaddrs();
    }

    public List getCommonHostsAsList() {
        return this.listOrigParsedCommonHosts;
    }

    public List getMergedCommonDeniedHosts(String commonHosts, List deniedHosts, List allowedHosts) {
        this.writeDebug("Determining common and denied hosts ");
        this.loadDeniedHostsAddresses(deniedHosts);
        List listCommonHosts = this.parseCommonHostsData(commonHosts);
        Iterator iterComHostsList = listCommonHosts.iterator();
        this.mergedHosts = new ArrayList(listCommonHosts.size());
        while (iterComHostsList.hasNext()) {
            HashMap mapComHostInfo = (HashMap)iterComHostsList.next();
            String szHostShare = (String)mapComHostInfo.get("machine_name");
            String szHostName = this.nfDenyProc.getHostName(szHostShare);
            String szFQHostName = this.nfDenyProc.getFQHostName(szHostName, this.szDefaultDomain);
            this.writeDebug("Fully qualified host name is " + szFQHostName);
            InetAddress[] hostIAddresses = null;
            try {
                hostIAddresses = InetAddress.getAllByName(szFQHostName);
            }
            catch (UnknownHostException uhe) {
                this.debug.error("Exception in determining the host address", (Throwable)uhe);
                continue;
            }
            if (this.isLocalHost(hostIAddresses)) continue;
            try {
                if (this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostIAddresses, true)) {
                    if (this.ia_denied_hosts != null && this.nfDenyProc.isHostDenied(hostIAddresses, this.ia_denied_hosts) && (szHostName != null || szHostName.trim().length() != 0)) {
                        this.al_denied_hosts.add(szHostName);
                        mapComHostInfo.remove("machine_name");
                        mapComHostInfo.put("machine_name", szHostName);
                    }
                } else {
                    if (this.debug.messageEnabled()) {
                        this.debug.message(szHostName + "is not an allowed host");
                    }
                    this.al_denied_hosts.add(szHostName);
                    mapComHostInfo.remove("machine_name");
                    mapComHostInfo.put("machine_name", szHostName);
                }
            }
            catch (Exception e) {
                this.debug.error("Exception in finding denied host for " + szHostName, (Throwable)e);
            }
            String szCommonHostInfo = this.convertHostInfoHashMapToString(mapComHostInfo);
            this.mergedHosts.add(szCommonHostInfo);
        }
        return this.mergedHosts;
    }

    public List getMergedCommonUserHosts(String commonHosts, List deniedHosts, List allowedHosts, List userHosts) {
        this.writeDebug("Merging common, user-added and denied hosts ");
        this.loadDeniedHostsAddresses(deniedHosts);
        List listCommonHosts = this.parseCommonHostsData(commonHosts);
        Iterator iterUserHosts = userHosts.iterator();
        this.mergedHosts = new ArrayList(listCommonHosts.size());
        while (iterUserHosts.hasNext()) {
            String szUserHost;
            block20: {
                szUserHost = (String)iterUserHosts.next();
                if (szUserHost != null || szUserHost.length() != 0) {
                    szUserHost = AMPasswordUtil.decrypt((String)szUserHost);
                }
                String szHostName = this.nfDenyProc.getHostName(szUserHost);
                String szFQHostName = this.nfDenyProc.getFQHostName(szHostName, this.szDefaultDomain);
                InetAddress[] hostIAddresses = null;
                try {
                    hostIAddresses = InetAddress.getAllByName(szFQHostName);
                }
                catch (UnknownHostException uhe) {
                    this.debug.error("Exception in determining the host address", (Throwable)uhe);
                    continue;
                }
                if (this.isLocalHost(hostIAddresses)) continue;
                try {
                    if (this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostIAddresses, true)) {
                        if (this.ia_denied_hosts != null && this.nfDenyProc.isHostDenied(hostIAddresses, this.ia_denied_hosts) && (szHostName != null || szHostName.trim().length() != 0)) {
                            this.al_denied_hosts.add(szHostName);
                        }
                    } else {
                        this.al_denied_hosts.add(szHostName);
                    }
                }
                catch (Exception e) {
                    this.debug.error("Exception in finding denied host for " + szHostName, (Throwable)e);
                    continue;
                }
                try {
                    this.writeDebug("Verifying a matching common host for " + szHostName);
                    int index_ht_matching_host = this.getMatchingHost(hostIAddresses, listCommonHosts);
                    if (index_ht_matching_host < 0) break block20;
                    szUserHost = this.mergeHost(szUserHost, (HashMap)listCommonHosts.get(index_ht_matching_host));
                    listCommonHosts.remove(index_ht_matching_host);
                }
                catch (Exception e) {
                    this.debug.error("Error in merging user-added and common hosts", (Throwable)e);
                    continue;
                }
            }
            this.mergedHosts.add(szUserHost);
        }
        int i = 0;
        while (i < listCommonHosts.size()) {
            block21: {
                HashMap mapComHosts = (HashMap)listCommonHosts.get(i);
                String szHostName = (String)mapComHosts.get("machine_name");
                szHostName = this.nfDenyProc.getHostName(szHostName);
                String szFQHostName = this.nfDenyProc.getFQHostName(szHostName, this.szDefaultDomain);
                InetAddress[] hostIAddresses = null;
                try {
                    hostIAddresses = InetAddress.getAllByName(szFQHostName);
                }
                catch (UnknownHostException uhe) {
                    this.debug.error("Exception in determining the host address", (Throwable)uhe);
                    break block21;
                }
                if (!this.isLocalHost(hostIAddresses)) {
                    try {
                        if (this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostIAddresses, true)) {
                            if (this.ia_denied_hosts != null && this.nfDenyProc.isHostDenied(hostIAddresses, this.ia_denied_hosts) && (szHostName != null || szHostName.trim().length() != 0)) {
                                this.al_denied_hosts.add(szHostName);
                            }
                        } else {
                            this.al_denied_hosts.add(szHostName);
                        }
                    }
                    catch (Exception e) {
                        this.debug.error("Error in verifying if the not merged hosts are denied " + e);
                        break block21;
                    }
                    String szCommonHostInfo = this.convertHostInfoHashMapToString(mapComHosts);
                    this.listNotMergedCommonHosts.add(szCommonHostInfo);
                }
            }
            ++i;
        }
        return this.mergedHosts;
    }

    public List mergeDeniedUserHosts(List deniedHosts, List allowedHosts, List userHosts) {
        this.writeDebug("Determining denied and user-added hosts ");
        this.loadDeniedHostsAddresses(deniedHosts);
        Iterator iterHostsList = userHosts.iterator();
        this.mergedHosts = new ArrayList();
        while (iterHostsList.hasNext()) {
            String szHostShare = (String)iterHostsList.next();
            if (szHostShare != null || szHostShare.length() != 0) {
                szHostShare = AMPasswordUtil.decrypt((String)szHostShare);
            }
            String szHostName = this.nfDenyProc.getHostName(szHostShare);
            String szFQHostName = this.nfDenyProc.getFQHostName(szHostName, this.szDefaultDomain);
            InetAddress[] hostIAddresses = null;
            try {
                hostIAddresses = InetAddress.getAllByName(szFQHostName);
            }
            catch (UnknownHostException uhe) {
                this.debug.error("Exception in determining the host address", (Throwable)uhe);
                continue;
            }
            if (this.isLocalHost(hostIAddresses)) continue;
            try {
                if (this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostIAddresses, true)) {
                    if (this.ia_denied_hosts != null && this.nfDenyProc.isHostDenied(hostIAddresses, this.ia_denied_hosts)) {
                        this.al_denied_hosts.add(szHostName);
                    }
                } else {
                    this.al_denied_hosts.add(szHostName);
                }
            }
            catch (Exception e) {
                this.debug.error("Exception in finding denied host for " + szHostName, (Throwable)e);
            }
            this.mergedHosts.add(szHostShare);
        }
        return this.mergedHosts;
    }

    public void loadDeniedHostsAddresses(List deniedHosts) {
        if (deniedHosts == null) {
            this.ia_denied_hosts = null;
            return;
        }
        this.ia_denied_hosts = !deniedHosts.isEmpty() ? this.nfDenyProc.getDeniedHostsAddresses(deniedHosts) : null;
    }

    public List getUserDeniedHostsAsList() {
        return this.al_denied_hosts;
    }

    public List getNotMergedCommonHosts() {
        return this.listNotMergedCommonHosts;
    }

    public void setDefaultDomain(String szDefDomName) {
        this.szDefaultDomain = szDefDomName;
    }

    List parseCommonHostsData(String szCommonHosts) {
        StringTokenizer tokens = new StringTokenizer(szCommonHosts, "\n");
        ArrayList<Object> listComHosts = new ArrayList<Object>();
        StringBuffer sbHostData = null;
        while (tokens.hasMoreTokens()) {
            String szToken = tokens.nextToken();
            if (szToken.startsWith("machine_name=")) {
                if (sbHostData != null) {
                    listComHosts.add(sbHostData.toString());
                }
                sbHostData = new StringBuffer();
                sbHostData.append(szToken).append('\n');
                continue;
            }
            sbHostData.append(szToken).append('\n');
        }
        if (sbHostData != null) {
            listComHosts.add(sbHostData.toString());
        }
        int i = 0;
        while (i < listComHosts.size()) {
            try {
                String s_common_host_data = (String)listComHosts.get(i);
                HashMap ht_s_common_host_data = this.parseHost(s_common_host_data, "\n");
                ht_s_common_host_data = this.verifyHostData(ht_s_common_host_data, this.nfContext, this.nfRes);
                listComHosts.remove(i);
                listComHosts.add(i, ht_s_common_host_data);
            }
            catch (NetFileException e) {
                this.debug.message("Unable to parse common host data " + e.getMessage());
                listComHosts.remove(i);
            }
            ++i;
        }
        this.listOrigParsedCommonHosts = (ArrayList)listComHosts.clone();
        return listComHosts;
    }

    String convertHostInfoHashMapToString(HashMap commonHost) {
        if (commonHost == null) {
            return null;
        }
        Object objHost = commonHost.get("machine_name");
        if (objHost == null) {
            return null;
        }
        Object objHostType = commonHost.get("machine_type");
        if (objHostType == null) {
            return null;
        }
        StringBuffer sbHostInfo = new StringBuffer(100);
        this.removeCtrlMChar("machine_name=", (String)objHost, sbHostInfo);
        this.removeCtrlMChar("machine_type=", (String)objHostType, sbHostInfo);
        this.removeCtrlMChar("machine_encoding=", (String)commonHost.get("machine_encoding"), sbHostInfo);
        this.removeCtrlMChar("machine_domain=", (String)commonHost.get("machine_domain"), sbHostInfo);
        this.removeCtrlMChar("machine_password=", (String)commonHost.get("machine_password"), sbHostInfo);
        this.removeCtrlMChar("machine_user_name=", (String)commonHost.get("machine_user_name"), sbHostInfo);
        Object objListShares = commonHost.get("shares");
        Object objListSharePwds = commonHost.get("share_passwords");
        if (objListShares == null || objListSharePwds == null) {
            return sbHostInfo.toString();
        }
        ArrayList listShares = (ArrayList)objListShares;
        ArrayList listSharePwds = (ArrayList)objListSharePwds;
        if (listShares.isEmpty() || listSharePwds.isEmpty() || listShares.size() != listSharePwds.size()) {
            return sbHostInfo.toString();
        }
        int i = 0;
        while (i < listShares.size()) {
            this.removeCtrlMChar("share_name=", (String)listShares.get(i), sbHostInfo);
            this.removeCtrlMChar("share_password=", (String)listSharePwds.get(i), sbHostInfo);
            ++i;
        }
        return sbHostInfo.toString();
    }

    void removeCtrlMChar(String szPrefix, String szValue, StringBuffer sbHostInfo) {
        int i = szValue.lastIndexOf(10);
        int j = szValue.lastIndexOf(13);
        if (i < 0 && j < 0) {
            sbHostInfo.append(szPrefix).append(szValue).append('\n');
        } else if (j < 0 && i >= 0) {
            sbHostInfo.append(szPrefix).append(szValue.substring(0, i)).append('\n');
        } else {
            this.debug.message("i is " + i + " j is " + j + " value is " + szValue.substring(0, j));
            sbHostInfo.append(szPrefix).append(szValue.substring(0, j)).append('\n');
        }
    }

    String removeCtrlMChar(String szValue) {
        int i = szValue.lastIndexOf(10);
        int j = szValue.lastIndexOf(13);
        if (i < 0 && j < 0) {
            return szValue + '\n';
        }
        if (j < 0 && i >= 0) {
            return szValue.substring(0, i) + '\n';
        }
        return szValue.substring(0, j) + '\n';
    }

    HashMap parseHost(String s_user_added_host_share, String separator) throws NetFileException {
        StringTokenizer st_tokens = new StringTokenizer(s_user_added_host_share, separator);
        HashMap<String, Object> ht_host = new HashMap<String, Object>(st_tokens.countTokens() + 2);
        try {
            ArrayList<String> v_shares = new ArrayList<String>();
            ArrayList<String> v_share_passwords = new ArrayList<String>();
            ht_host.put("shares", v_shares);
            ht_host.put("share_passwords", v_share_passwords);
            String s_name = null;
            while (st_tokens.hasMoreTokens()) {
                String token = st_tokens.nextToken();
                if (token.startsWith("machine_name=")) {
                    s_name = this.removePrefix("machine_name=", token);
                    if (s_name == null || s_name.equals("")) {
                        throw new NetFileException(500, this.nfRes.getString("illegal_machine_name"));
                    }
                    ht_host.put("machine_name", s_name);
                    InetAddress[] ia_common_host = this.getAllInetAddresses(s_name);
                    ht_host.put("all_inet_addresses", ia_common_host);
                    continue;
                }
                if (token.startsWith("machine_type=")) {
                    s_name = this.removePrefix("machine_type=", token);
                    if (s_name == null || s_name.equals("")) {
                        throw new NetFileException(500, this.nfRes.getString("illegal_machine_type"));
                    }
                    ht_host.put("machine_type", s_name);
                    continue;
                }
                if (token.startsWith("machine_encoding=")) {
                    ht_host.put("machine_encoding", this.removePrefix("machine_encoding=", token));
                    continue;
                }
                if (token.startsWith("machine_domain=")) {
                    ht_host.put("machine_domain", this.removePrefix("machine_domain=", token));
                    continue;
                }
                if (token.startsWith("machine_password=")) {
                    ht_host.put("machine_password", this.removePrefix("machine_password=", token));
                    continue;
                }
                if (token.startsWith("machine_user_name=")) {
                    ht_host.put("machine_user_name", this.removePrefix("machine_user_name=", token));
                    continue;
                }
                if (!token.startsWith("share_name=")) continue;
                v_shares.add(this.removePrefix("share_name=", token));
                String s_password = st_tokens.nextToken();
                v_share_passwords.add(this.removePrefix("share_password=", s_password));
            }
        }
        catch (Exception e) {
            this.debug.error("Unable to parse host data", (Throwable)e);
            throw new NetFileException(500, "Illegal data format for common host ");
        }
        return ht_host;
    }

    void removeValue(HashMap ht_contaier, HashMap ht_contained) {
        Set s_keys = ht_contaier.keySet();
        Iterator i_contaier = s_keys.iterator();
        while (i_contaier.hasNext()) {
            Object o_key = i_contaier.next();
            Object o_value = ht_contaier.get(o_key);
            if (o_value == null || !(o_value instanceof HashMap) || (HashMap)o_value != ht_contained) continue;
            ht_contaier.remove(o_key);
        }
    }

    StringBuffer mergeAttribute(String s_attribute_name, String attribute_tag, HashMap ht_host_data, StringBuffer sb_host_data) {
        Object o_temp = ht_host_data.get(s_attribute_name);
        String s_temp = this.s_empty_string;
        if (o_temp != null) {
            s_temp = (String)o_temp;
        }
        sb_host_data.append(attribute_tag).append(s_temp).append('\n');
        return sb_host_data;
    }

    InetAddress[] getAllInetAddresses(String s_host_name) throws Exception {
        return InetAddress.getAllByName(s_host_name.trim());
    }

    HashMap verifyHostData(HashMap ht_s_common_host_data, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
        if (ht_s_common_host_data.get("machine_name") == null) {
            throw new NetFileException(500, nfRes.getString("illegal_machine_name"));
        }
        ht_s_common_host_data = this.verifyCharacterEncoding(ht_s_common_host_data, nfContext, nfRes);
        this.verifyMachineType(ht_s_common_host_data);
        if (ht_s_common_host_data.get("machine_domain") == null) {
            ht_s_common_host_data.put("machine_domain", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_password") == null) {
            ht_s_common_host_data.put("machine_password", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_user_name") == null) {
            ht_s_common_host_data.put("machine_user_name", this.s_empty_string);
        }
        return ht_s_common_host_data;
    }

    void verifyMachineType(HashMap ht_s_common_host_data) throws NetFileException {
        Object o_type = ht_s_common_host_data.get("machine_type");
        if (o_type == null) {
            throw new NetFileException(500, this.nfRes.getString("illegal_machine_type"));
        }
        String s_type = (String)o_type;
        if (!((s_type = s_type.trim()).equals("FTP") || s_type.equals("NETWARE") || s_type.equals("NFS") || s_type.equals("NT") || s_type.equals("WIN"))) {
            throw new NetFileException(500, this.nfRes.getString("illegal_machine_type"));
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Machine Type verified is " + (String)o_type);
        }
    }

    HashMap verifyCharacterEncoding(HashMap ht_host, NetFileContext nfContext, NetFileResource nfRes) {
        String s_encoding_display_name;
        Object o_encoding = ht_host.remove("machine_encoding");
        String s_encoding = this.s_empty_string;
        if (o_encoding != null) {
            s_encoding = (String)o_encoding;
            s_encoding = s_encoding.trim();
        }
        if ((s_encoding_display_name = nfRes.getString("encoding_" + s_encoding)) == null || s_encoding_display_name.trim().equals(this.s_empty_string) || s_encoding_display_name.trim().equals("encoding_" + s_encoding)) {
            String s_os_char_set = nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileOSCharSet", this.S_DEFAULT_ENCODING);
            if (s_os_char_set.equals(this.s_empty_string)) {
                s_os_char_set = this.S_DEFAULT_ENCODING;
            } else {
                String s_os_char_set_display_name = nfRes.getString("encoding_" + s_os_char_set);
                if (s_os_char_set_display_name == null || s_os_char_set_display_name.trim().equals(this.s_empty_string) || s_os_char_set_display_name.equals("encoding_" + s_os_char_set)) {
                    s_os_char_set = this.S_DEFAULT_ENCODING;
                }
            }
            s_encoding = s_os_char_set;
            s_encoding_display_name = nfRes.getString("encoding_" + s_encoding);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Machine encoding being placed is " + s_encoding_display_name);
        }
        ht_host.put("machine_encoding", s_encoding_display_name);
        return ht_host;
    }

    String mergeHost(String s_user_added_host_share, HashMap ht_matching_common_host) throws NetFileException {
        HashMap ht_user_added_host = this.parseHost(s_user_added_host_share, "\n");
        StringBuffer sb_host_data = new StringBuffer();
        sb_host_data.append("machine_name=").append(ht_user_added_host.get("machine_name")).append('\n');
        boolean b_are_types_different = this.areTypeDifferent(ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_type", "machine_type", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_encoding", "machine_encoding", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_domain", "machine_domain", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_password", "machine_password", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_user_name", "machine_user_name", ht_matching_common_host, ht_user_added_host);
        ArrayList v_shares = (ArrayList)ht_user_added_host.get("shares");
        ArrayList v_passwords = (ArrayList)ht_user_added_host.get("share_passwords");
        ArrayList v_common_shares = (ArrayList)ht_matching_common_host.get("shares");
        ArrayList v_common_share_passwords = (ArrayList)ht_matching_common_host.get("share_passwords");
        if (b_are_types_different && this.debug.messageEnabled()) {
            this.debug.message("Host type specified by user for " + (String)ht_user_added_host.get("machine_name") + " is " + (String)ht_user_added_host.get("machine_type"));
            this.debug.message("Host type specified by user for " + (String)ht_user_added_host.get("machine_name") + " is " + (String)ht_user_added_host.get("machine_type"));
        }
        if (!b_are_types_different) {
            ArrayList[] v_share_data = this.mergeShares(v_shares, v_passwords, v_common_shares, v_common_share_passwords);
            v_shares = v_share_data[0];
            v_passwords = v_share_data[1];
        }
        int i_num_shares = v_shares.size();
        int i = 0;
        while (i < i_num_shares) {
            sb_host_data.append("share_name=").append((String)v_shares.get(i)).append('\n').append("share_password=").append((String)v_passwords.get(i)).append('\n');
            ++i;
        }
        sb_host_data.append('\n');
        return sb_host_data.toString();
    }

    boolean areTypeDifferent(HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        Object o_common_type = ht_matching_common_host.get("machine_type");
        if (o_common_type == null) {
            return false;
        }
        return !((String)ht_user_added_host.get("machine_type")).equals((String)o_common_type);
    }

    ArrayList[] mergeShares(ArrayList v_shares, ArrayList v_passwords, ArrayList v_common_shares, ArrayList v_common_share_passwords) {
        Iterator e_shares = ((AbstractList)v_shares).iterator();
        while (e_shares.hasNext()) {
            String s_share = (String)e_shares.next();
            if (!v_common_shares.contains(s_share)) continue;
            ((AbstractCollection)v_common_shares).remove(s_share);
        }
        Iterator e_common_shares = ((AbstractList)v_common_shares).iterator();
        Iterator e_common_share_passwords = ((AbstractList)v_common_share_passwords).iterator();
        while (e_common_shares.hasNext()) {
            v_shares.add(e_common_shares.next());
            if (e_common_share_passwords.hasNext()) {
                v_passwords.add((String)e_common_share_passwords.next());
                continue;
            }
            v_passwords.add(this.s_empty_string);
        }
        return new ArrayList[]{v_shares, v_passwords};
    }

    StringBuffer mergeAttribute(StringBuffer sb_host_data, String attribute_name1, String attribute_name2, HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        sb_host_data.append(attribute_name1).append("=");
        Object o_temp = ht_user_added_host.get(attribute_name1);
        if (o_temp == null) {
            o_temp = ht_matching_common_host.get(attribute_name2);
        }
        if (o_temp != null) {
            sb_host_data.append((String)o_temp);
        }
        sb_host_data.append('\n');
        return sb_host_data;
    }

    String removePrefix(String prefix, String szValue) throws NetFileException {
        if (!szValue.startsWith(prefix)) {
            throw new NetFileException(500, this.nfRes.getString("illegal_machine_data_format"));
        }
        szValue = szValue.substring(prefix.length(), szValue.length());
        return this.removeCtrlMChar(szValue);
    }

    int getMatchingHost(InetAddress[] ia_host_added_by_user, List ht_host_shares_set_by_admin) {
        int index = -1;
        int count = 0;
        while (count < ia_host_added_by_user.length) {
            int i = 0;
            while (i < ht_host_shares_set_by_admin.size()) {
                block5: {
                    try {
                        InetAddress[] ia_host;
                        HashMap ht_host = (HashMap)ht_host_shares_set_by_admin.get(i);
                        Object o_inet_addresses = ht_host.get("all_inet_addresses");
                        if (o_inet_addresses != null && (ia_host = (InetAddress[])o_inet_addresses)[0].equals(ia_host_added_by_user[count])) {
                            index = i;
                            return index;
                        }
                    }
                    catch (Exception e) {
                        this.debug.message("Exception while finding host matching a given host among common hosts by IP", (Throwable)e);
                        if (i < ht_host_shares_set_by_admin.size() || count < ia_host_added_by_user.length) break block5;
                        return -1;
                    }
                }
                ++i;
            }
            ++count;
        }
        return index;
    }

    boolean isLocalHost(InetAddress[] hostIAddresses) {
        if (this.localHostAddrs == null || this.localHostAddrs.length < 1) {
            return true;
        }
        int i = 0;
        while (i < hostIAddresses.length) {
            int k = 0;
            while (k < this.localHostAddrs.length) {
                if (this.localHostAddrs[k].trim().equals(hostIAddresses[i].getHostAddress().trim())) {
                    this.writeDebug(hostIAddresses[i].getHostName() + " is a local host");
                    return true;
                }
                ++k;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    String[] getRPaddrs() {
        String[] rphostip = new String[20];
        String configparam = "";
        int rpj = 0;
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[]{"/sbin/ifconfig", "-a"};
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                void var5_13;
                char chtxt = (char)var5_13;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            this.debug.error("FileOption IOException in getrpaddrs: ", (Throwable)ex);
            rphostip[0] = "Failed Execution: " + ex;
            rphostip[1] = "\u0000";
            Object rt = null;
            return rphostip;
        }
        if (configparam.equals("")) {
            this.debug.message("Cannot get local machine hostname.");
            rphostip[0] = "Cannot get local machine hostname.";
            rphostip[1] = "\u0000";
            return rphostip;
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        String[] hostip = new String[100];
        int inetindx = 0;
        int inetmaskindx = 0;
        int j = 0;
        while (j < parscnt) {
            hostip[j] = pars.nextToken();
            inetindx = hostip[j].indexOf("inet", 0);
            inetmaskindx = hostip[j].indexOf("netmask", 0);
            if (inetindx >= 0 && inetmaskindx >= 0) {
                rphostip[rpj] = hostip[j].substring(inetindx + 5, inetmaskindx);
                ++rpj;
            }
            ++j;
        }
        int ips = rpj;
        while (ips < rphostip.length) {
            rphostip[ips] = "\u0000";
            ++ips;
        }
        return rphostip;
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }
}

