/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetFileAttributeExtractor {
    Map userAttribs;
    Debug debug;

    public NetFileAttributeExtractor(Map attribs) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.userAttribs = attribs;
    }

    public String getString(String name, String defaultValue) {
        Object data = this.extractObject(name, false);
        return data != null ? (String)data : defaultValue;
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        Object data = this.extractObject(name, false);
        return data != null ? new Boolean((String)data) : new Boolean(defaultValue);
    }

    public Integer getInt(String name, int defaultValue) {
        try {
            Object data = this.extractObject(name, false);
            return data != null ? new Integer(Integer.parseInt((String)data)) : new Integer(defaultValue);
        }
        catch (Exception e) {
            this.debug.error("The value of the attribute " + name + " is not a number. It should be a number", (Throwable)e);
            return new Integer(defaultValue);
        }
    }

    public List getStringList(String name) {
        Object data = this.extractObject(name, true);
        if (data == null) {
            return null;
        }
        Set dataSet = (Set)data;
        ArrayList<String> ret = new ArrayList<String>(dataSet.size());
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            ret.add((String)it.next());
        }
        return ret;
    }

    public Object extractObject(String szKeyName, boolean returnAll) {
        Set keys = this.userAttribs.keySet();
        Set values = null;
        Object obj = null;
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String attrib = (String)i.next();
            if (!attrib.equalsIgnoreCase(szKeyName)) continue;
            values = (Set)this.userAttribs.get(attrib);
            if (values == null) break;
            if (returnAll) {
                return values;
            }
            obj = this.getValue(values);
            return obj;
        }
        return null;
    }

    public Set getKeysSet() {
        return this.userAttribs.keySet();
    }

    public Object getValue(Set set) {
        Iterator it = set.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public void setUserAttributesMap(Map m) {
        this.userAttribs = m;
    }
}

