/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.xml;

import com.sun.portal.rewriter.DataRuleCollection;
import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterFactory;
import com.sun.portal.rewriter.RewriterTestInputs;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.RuleSetManager;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.CompositeRewriter;
import com.sun.portal.rewriter.engines.common.Attribute;
import com.sun.portal.rewriter.engines.common.TagText;
import com.sun.portal.rewriter.engines.xml.XMLRules;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.ListMap;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.FileReader;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLRewriter
extends AbstractRewriter {
    public static final String PROPERTY_IS_REWRITE_XSL = "IS_REWRITE_XSL";
    private final DataRuleCollection xmlAttributeRules;
    private final DataRuleCollection xmlTagTextRules;
    private static final String[][] xmlEntities = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&apos;"}};
    private static final String[][] decAndHexEntities = new String[][]{{"&#160;", "\u00a0"}, {"&#x200E;", "\u200e"}, {"&#x200F;", "\u200f"}};
    private static final String[][] revDecAndHexEntities = new String[][]{{"\u00a0", "&#160;"}, {"\u200e", "&#x200E;"}, {"\u200f", "&#x200F;"}};

    public XMLRewriter(CompositeRewriter compositeRewriter, RuleSet ruleSet) {
        super(compositeRewriter, ruleSet, "text/xml");
        XMLRules xMLRules = this.getRuleSet().getXMLRules();
        this.xmlAttributeRules = xMLRules.getAttributes();
        this.xmlTagTextRules = xMLRules.getTextStrings();
    }

    protected String plugableRewriter(String string, Translator translator) {
        return this.parseXML(string, translator);
    }

    private String parseXML(String string, Translator translator) {
        String string2 = Document.parseHeadder(string);
        try {
            Node node = Document.create(string, false, true, false).getRootNode().getW3CNode();
            if (!ConfigManager.getBoolean(PROPERTY_IS_REWRITE_XSL, "true") && node.getNodeName().equalsIgnoreCase("xsl:stylesheet")) {
                return string;
            }
            StringBuffer stringBuffer = this.printDOM(node, new StringBuffer(string.length()), translator, new Attribute("", ""), new TagText("", ""), false);
            if (string2.length() != 0) {
                stringBuffer.insert(0, "\n");
                stringBuffer.insert(0, string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (Debug.isWarningEnabled()) {
                Debug.recordPageWarning("Unable to translate XML:" + string, exception);
            }
            return string;
        }
    }

    public StringBuffer printDOM(Node node, StringBuffer stringBuffer, Translator translator, Attribute attribute, TagText tagText, boolean bl) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object object;
                Object object2;
                int n;
                ListMap listMap = ListMap.EMPTY_LISTMAP;
                String string = node.getNodeName();
                stringBuffer.append('<');
                stringBuffer.append(string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && namedNodeMap.getLength() != 0) {
                    listMap = new ListMap();
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object2 = namedNodeMap.item(n);
                        object = object2.getNodeName().trim();
                        String string2 = object2.getNodeValue();
                        listMap.put(object, string2);
                        if (!bl && string2.indexOf("\"") != -1) {
                            bl = true;
                        }
                        this.rewriteAttribute(stringBuffer, Attribute.cycleMatche(attribute, object2.getNodeName(), node.getNodeName()), XMLRewriter.processNodeValue(string2), translator, bl);
                        ++n;
                    }
                }
                n = stringBuffer.length();
                object2 = "/>";
                object = node.getChildNodes();
                int n2 = object.getLength();
                if (n2 > 0) {
                    object2 = ">";
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        Node node2 = object.item(n3);
                        short s2 = node2.getNodeType();
                        switch (s2) {
                            case 3: {
                                String string3 = node2.getNodeValue();
                                String string4 = string3.trim();
                                if (string4.length() != 0) {
                                    if (n3 == 0 && string4.indexOf("\"") != -1) {
                                        bl2 = true;
                                    }
                                    this.rewriteTagText(stringBuffer, TagText.cycleMatche(tagText, node.getNodeName(), listMap), string3, translator);
                                    break;
                                }
                                stringBuffer.append(string3);
                                break;
                            }
                            default: {
                                this.printDOM(node2, stringBuffer, translator, attribute, tagText, bl2);
                            }
                        }
                        ++n3;
                    }
                } else if (string.equalsIgnoreCase("span") || string.equalsIgnoreCase("div")) {
                    object2 = ">";
                }
                stringBuffer.insert(n, (String)object2);
                if (((String)object2).length() != 1) break;
                stringBuffer.append("</").append(node.getNodeName()).append(">");
                break;
            }
            default: {
                this.handleDefault(node, stringBuffer);
            }
        }
        return stringBuffer;
    }

    private static final String processNodeValue(String string) {
        string = StringHelper.searchAndReplace(string, decAndHexEntities);
        string = StringHelper.searchAndReplace(string, xmlEntities);
        string = StringHelper.searchAndReplace(string, revDecAndHexEntities);
        return string;
    }

    private void handleDefault(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 5: {
                stringBuffer.append("&").append(node.getNodeName()).append(";");
                break;
            }
            case 8: {
                stringBuffer.append("<!--").append(node.getNodeValue()).append("-->");
                break;
            }
            case 4: {
                stringBuffer.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
                break;
            }
            default: {
                if (!Debug.isWarningEnabled()) break;
                Debug.recordPageWarning("Ignoring :" + node.getNodeName() + " Node Type : " + node.getNodeType());
            }
        }
    }

    private void rewriteAttribute(StringBuffer stringBuffer, Attribute attribute, String string, Translator translator, boolean bl) {
        Attribute attribute2 = (Attribute)this.xmlAttributeRules.findMatch(attribute);
        stringBuffer.append(" ").append(attribute.getName()).append("=");
        XMLRewriter.appendQuotes(stringBuffer, bl);
        if (attribute2 != null) {
            List list = attribute2.getParsedPatterns();
            string = list.size() == 0 ? translator.convert2Absolute(string) : TranslatorHelper.translateSubStrings(list, string, translator);
        }
        stringBuffer.append(string);
        XMLRewriter.appendQuotes(stringBuffer, bl);
    }

    private static void appendQuotes(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append("'");
        } else {
            stringBuffer.append("\"");
        }
    }

    private void rewriteTagText(StringBuffer stringBuffer, TagText tagText, String string, Translator translator) {
        TagText tagText2 = (TagText)this.xmlTagTextRules.findMatch(tagText);
        if (tagText2 != null) {
            string = translator.convert2Absolute(string);
        }
        stringBuffer.append(string);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Resource.read(new FileReader(stringArray[0]));
        String string2 = Resource.read(new FileReader(stringArray[1]));
        Translator translator = RewriterTestInputs.defaultTranslator;
        RuleSet ruleSet = RuleSetManager.create(string);
        Rewriter rewriter = RewriterFactory.create(ruleSet, "text/xml");
        Debug.println(rewriter.rewrite(string2, translator));
    }
}

