/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.ApprovalCallback;
import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.JSSProxyRunnable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import sun.misc.RegexpPool;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public final class HttpsClient
extends HttpClient {
    private static String secureTunnelHost = null;
    private static int secureTunnelPort = 80;
    private static RegexpPool dontProxy = null;
    private static final int httpsPortNumber = 443;
    public static int jssProxyPort = -1;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSocket sslSocket = null;

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        String ourHost = HttpsClient.getProperty("https.proxyHost");
        JSSDebug.debug.message("HttpsClient: proxyHost = " + ourHost);
        if (ourHost == null || "".equals(ourHost)) {
            secureTunnelHost = null;
            secureTunnelPort = 80;
        } else {
            secureTunnelHost = ourHost;
            secureTunnelPort = Integer.getInteger("https.proxyPort", 80);
        }
        dontProxy = new RegexpPool();
        String rawList = HttpsClient.getProperty("http.nonProxyHosts");
        JSSDebug.debug.message("HttpsClient: nonProxyHosts = " + rawList);
        if (rawList != null) {
            StringTokenizer st = new StringTokenizer(rawList, "|", false);
            try {
                while (st.hasMoreTokens()) {
                    dontProxy.add(st.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0, 50);
        }
        catch (IOException e) {
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
    }

    public HttpsClient(URL url) throws IOException {
        super(url, true);
        JSSDebug.debug.message("HttpsClient: HttpsClient " + url);
    }

    public static HttpClient New(URL url) throws IOException {
        JSSDebug.debug.message("HttpsClient: New " + url);
        HttpsClient ret = (HttpsClient)HttpClient.kac.get(url);
        if (ret == null) {
            ret = new HttpsClient(url);
        } else {
            ret.url = url;
        }
        return ret;
    }

    protected boolean isNonProxyHost() {
        if (dontProxy.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress addr = InetAddress.getByName(this.url.getHost());
            String host = addr.getHostAddress();
            if (dontProxy.match(host) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    protected Socket doConnect(String host, int port) throws IOException, UnknownHostException {
        JSSDebug.debug.message("HttpsClient: doConnect(" + host + ", " + port + ")");
        this.instTunnelHost = secureTunnelHost;
        int n = this.instTunnelPort = secureTunnelPort < 0 ? super.getDefaultPort() : secureTunnelPort;
        if (this.instTunnelHost == null || this.isNonProxyHost()) {
            this.sslSocket = new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)ApprovalCallback.getInstance(), null);
        } else {
            JSSDebug.debug.message("HttpsClient: doConnect through proxy " + secureTunnelHost + ":" + secureTunnelPort);
            this.sslSocket = new SSLSocket(InetAddress.getByName("localhost"), jssProxyPort, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(host), null);
            Integer localport = new Integer(this.sslSocket.getLocalPort());
            String info = secureTunnelHost + " " + secureTunnelPort + " " + host + " " + port;
            JSSProxyRunnable.connectHashMap.put(localport, info);
        }
        return this.sslSocket;
    }

    public String getCipherSuite() {
        String cipher = null;
        try {
            cipher = this.sslSocket.getStatus().getCipher();
        }
        catch (SocketException se) {
            JSSDebug.debug.message("HttpsClient: getCipher failed");
        }
        return cipher;
    }

    public X509Certificate[] getServerCertificateChain() {
        return null;
    }

    private static String getProperty(String prop) {
        SecurityException ex = null;
        try {
            return System.getProperty(prop);
        }
        catch (SecurityException e) {
            ex = e;
            try {
                return AccessController.doPrivileged(new GetPropertyAction("prop"));
            }
            catch (LinkageError linkageError) {
                throw ex;
            }
        }
    }

    static {
        HttpsClient.resetSecureProperties();
    }
}

