/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.SocketCache;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLCachedSSLSocketFactory {
    private static SocketCache _cache;
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    private static int _timeout;

    private static CachedSocket createSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket;
        block4: {
            cachedSocket = null;
            SSLSocket sslSocket = null;
            Socket socket = null;
            try {
                socket = SSLSocketFactory.getDefault().createSocket(host, port);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementSSLSockets();
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("csslsf1", new Object[]{logId, socket.getInetAddress().toString(), new Integer(socket.getPort())}));
                }
                sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(true);
                socket.setSoTimeout(_timeout);
                cachedSocket = new CachedSocket(socket);
                cachedSocket.setType(socketType);
                cachedSocket.setActive();
                cachedSocket.setSocketCache(_cache);
                _cache.putSocket(cachedSocket);
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block4;
                GWDebug.debug.error("SSLCachedSSLSocketFactory cannot open connection to " + host + ":" + port, e);
            }
        }
        return cachedSocket;
    }

    public static CachedSocket createSocket(SSLSocket sslSocket) {
        CachedSocket cachedSocket;
        block2: {
            cachedSocket = null;
            try {
                sslSocket.setUseClientMode(true);
                sslSocket.setSoTimeout(_timeout);
                cachedSocket = new CachedSocket(sslSocket);
                cachedSocket.setType(new String("ssl"));
                cachedSocket.setActive();
                cachedSocket.setSocketCache(_cache);
                _cache.putSocket(cachedSocket);
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("SSLCachedSSLSocketFactory cannot create socket", e);
            }
        }
        return cachedSocket;
    }

    public static CachedSocket getCachedSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket = null;
        if (cachedSocket == null) {
            cachedSocket = SSLCachedSSLSocketFactory.createSocket(host, port, socketType, logId);
        }
        return cachedSocket;
    }

    public static CachedSocket getNewCachedSocket(String host, int port, String socketType, Integer logId) {
        return SSLCachedSSLSocketFactory.createSocket(host, port, socketType, logId);
    }

    static {
        _timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200000);
        _cache = new SocketCache();
    }
}

