/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

class SendFile {
    private Debug d_debug = null;

    SendFile() {
        if (this.d_debug == null) {
            this.d_debug = Debug.getInstance((String)"srapNetFile");
            this.d_debug.setDebug(1);
        }
    }

    String encode(String s_to_be_encoded, String character_set) throws Exception {
        if (character_set != null && !character_set.equals("")) {
            s_to_be_encoded = MimeUtility.encodeText((String)s_to_be_encoded, (String)character_set, (String)"B");
        }
        return s_to_be_encoded;
    }

    String sendAttachedFile(String to, String from, String replyto, String cc, String bcc, String host, String subject, String message, Map filetosendList, String dbgval, String charSet, NetFileResource nfr_user_locale_i18n_bucket, String displayFileName) throws NetFileException {
        boolean toAddressException = false;
        boolean ccAddressException = false;
        boolean bccAddressException = false;
        boolean errflg = false;
        try {
            this.d_debug.message("Charset=" + charSet);
            if (charSet.equals("")) {
                charSet = "UTF8";
            }
            boolean debug = Boolean.valueOf(dbgval);
            InternetAddress[] toaddress = null;
            InternetAddress[] ccaddress = null;
            InternetAddress[] bccaddress = null;
            Properties props = System.getProperties();
            ((Hashtable)props).put("mail.smtp.host", host);
            Session session = Session.getDefaultInstance((Properties)props, null);
            session.setDebug(debug);
            if (!charSet.equals("")) {
                String firstFrom = "";
                String restFrom = "";
                int leftAnglendx = from.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstFrom = from.substring(0, leftAnglendx);
                    restFrom = from.substring(leftAnglendx);
                    firstFrom = this.encode(firstFrom, charSet);
                    from = firstFrom + restFrom;
                }
                String firstTo = "";
                String restTo = "";
                leftAnglendx = to.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstTo = to.substring(0, leftAnglendx);
                    restTo = to.substring(leftAnglendx);
                    firstTo = this.encode(firstTo, charSet);
                    to = firstTo + restTo;
                }
                String firstReply = "";
                String restReply = "";
                leftAnglendx = replyto.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstReply = replyto.substring(0, leftAnglendx);
                    restReply = replyto.substring(leftAnglendx);
                    firstReply = this.encode(firstReply, charSet);
                    replyto = firstReply + restReply;
                }
                String firstCC = "";
                String restCC = "";
                leftAnglendx = cc.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstCC = cc.substring(0, leftAnglendx);
                    restCC = cc.substring(leftAnglendx);
                    firstCC = this.encode(firstCC, charSet);
                    cc = firstCC + restCC;
                }
                String firstBCC = "";
                String restBCC = "";
                leftAnglendx = bcc.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstBCC = bcc.substring(0, leftAnglendx);
                    restBCC = bcc.substring(leftAnglendx);
                    firstBCC = this.encode(firstBCC, charSet);
                    bcc = firstBCC + restBCC;
                }
            }
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            try {
                toaddress = this.parseAddress(to);
                msg.setRecipients(Message.RecipientType.TO, (Address[])toaddress);
            }
            catch (AddressException ae) {
                toAddressException = true;
                this.d_debug.error("AddressException while parsing TO address, ", (Throwable)ae);
            }
            if (replyto == null || replyto.equals("")) {
                replyto = from;
            }
            InternetAddress[] replytoaddress = new InternetAddress[]{new InternetAddress(replyto)};
            msg.setReplyTo((Address[])replytoaddress);
            if (!cc.equals("") && cc != null) {
                try {
                    ccaddress = this.parseAddress(cc);
                    msg.setRecipients(Message.RecipientType.CC, (Address[])ccaddress);
                }
                catch (AddressException ae) {
                    ccAddressException = true;
                    this.d_debug.error("AddressException while parsing CC address, ", (Throwable)ae);
                }
            }
            if (!bcc.equals("") && bcc != null) {
                try {
                    bccaddress = this.parseAddress(bcc);
                    msg.setRecipients(Message.RecipientType.BCC, (Address[])bccaddress);
                }
                catch (AddressException ae) {
                    bccAddressException = true;
                    this.d_debug.error("AddressException while parsing BCC address, ", (Throwable)ae);
                }
            }
            msg.setSubject(this.encode(subject, charSet));
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(message, charSet);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            Iterator it = filetosendList.keySet().iterator();
            while (it.hasNext()) {
                Object theFileName = it.next();
                String thefile = filetosendList.get(theFileName).toString();
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(theFileName.toString());
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(this.encode(thefile, charSet));
                mp.addBodyPart((BodyPart)mbp2);
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.processException(e, host, nfr_user_locale_i18n_bucket);
        }
        this.d_debug.message("Did not throw exception properly");
        String displayAddress = "";
        if (toAddressException) {
            displayAddress = displayAddress + "To: " + to + "\n";
        }
        if (ccAddressException) {
            displayAddress = displayAddress + "Cc: " + cc + "\n";
        }
        if (bccAddressException) {
            displayAddress = displayAddress + "Bcc: " + bcc + "\n";
        }
        if (!displayAddress.equals("")) {
            return nfr_user_locale_i18n_bucket.getString("sfErr.7") + displayAddress;
        }
        return nfr_user_locale_i18n_bucket.getString("info8");
    }

    private void processException(Exception e, String host, NetFileResource nfRes) throws NetFileException {
        this.d_debug.error("Exception is sending the message", (Throwable)e);
        if (e instanceof MessagingException) {
            Exception mex;
            MessagingException me = (MessagingException)e;
            while ((mex = me.getNextException()) != null) {
                if (mex instanceof MessagingException) {
                    me = (MessagingException)mex;
                    continue;
                }
                if (mex instanceof UnknownHostException) {
                    throw new NetFileException(11, nfRes.getString("sfErr.4"));
                }
                if (mex instanceof AuthenticationFailedException) {
                    throw new NetFileException(12, nfRes.getString("sfErr.5"));
                }
                if (!(mex instanceof SendFailedException)) continue;
                throw new NetFileException(14, nfRes.getString("sfErr.8"));
            }
            throw new NetFileException(14, nfRes.getString("sfErr.8"));
        }
        if (e instanceof UnsupportedEncodingException) {
            throw new NetFileException(13, nfRes.getString("sfErr.6"));
        }
        this.d_debug.message("Throwing generic exception");
        throw new NetFileException(14, nfRes.getString("sfErr.8"));
    }

    InternetAddress[] parseAddress(String s, String charset) throws AddressException {
        InternetAddress[] addrs = InternetAddress.parse((String)s);
        if (charset != null) {
            int i = 0;
            while (i < addrs.length) {
                String personal = addrs[i].getPersonal();
                if (personal != null) {
                    try {
                        personal = this.encode(personal, charset);
                        addrs[i].setPersonal(personal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return addrs;
    }

    InternetAddress[] parseAddress(String s) throws AddressException {
        Object[] addrs = null;
        InternetAddress addr = null;
        Vector<InternetAddress> addrsVector = new Vector<InternetAddress>();
        StringTokenizer parsedAddrs = new StringTokenizer(s, ",");
        while (parsedAddrs.hasMoreTokens()) {
            addr = new InternetAddress(parsedAddrs.nextToken());
            addrsVector.addElement(addr);
        }
        addrs = new InternetAddress[addrsVector.size()];
        addrsVector.copyInto(addrs);
        return addrs;
    }
}

